
const Header = () => (
    <header className="l-header">
        <nav className="wrapp row xs-no-row row-center">
            <a href="/" title="Main" className="header-logo col sm-2 xs-1"></a>
            <ul className="header-nav col order-xs-3 sm-6 xs-5">
                <li><Link to='/'>Home</Link></li>
                <li><Link to='/sites'>Sites</Link></li>
                <li><Link to='/site-form'>SiteForm</Link></li>
                <li><Link to='/login'>Login</Link></li>
            </ul>
            <p className="header-register col sm-3 order-xs-4 xs-2">
                <AuthButton />
            </p>
        </nav>
    </header>
)

const Main = () => (
    <main className="l-content">
        <section className="b-content__counter">
            <div className="row row-wrap wrapp">
                <div className="b-content__counter-title">
                    <h1>Повышайте количество показов рекламы</h1>
                    <p className="lead">Обходите блокировщики рекламы с помощью простой веб технологии</p>
                </div>
            </div>
        </section>
        <section className="b-content__work">
            <div className="wrapp">
                <Switch>
                    <Route exact path='/' component={Home}/>
                    <PrivateRoute path='/sites' component={SitesList}/>
                    <PrivateRoute path='/site-form' component={SiteForm}/>
                    <Route path="/login" component={Login} />
                    <Route path='/404' component={My404Component} />
                    <Redirect from='*' to='/404' />
                </Switch>
            </div>
        </section>
    </main>
)


const Footer = () => (
    <footer className="l-footer">
        <div className="wrapp">
            <div className="b-footer__column row row-wrap">
                <div className="b-footer__column-note col order-xs-5 sm-2 xs-12">
                </div>

                <div className="b-footer__column-item col order-xs-2 sm-2 xs-6">
                </div>
                <div className="b-footer__column-item col order-xs-3 sm-2 xs-6">

                </div>
                <div className="b-footer__column-item col order-xs-4 sm-2 xs-6">
                </div>

                <div className="b-footer__column-item col order-xs-5 sm-2 xs-6">
                </div>
            </div>
        </div>
    </footer>
)
