
class Login extends React.Component {
    state = {
        redirectToReferrer: false,
        'email': '',
        'password': '',
        'remember-pass': false
    };
    handleChange = (event) => {
        const target = event.target;
        const value = (target.type === 'checkbox') ? target.checked : target.value;
        const name = target.name;
        this.setState({[name]: value});
    };
    handleSubmit = (event) => {
        console.log('AAA handleSubmit = ', this.state)
        event.preventDefault();
    };
    login = () => {
        fakeAuth.authenticate(() => {
            this.setState({ redirectToReferrer: true });
        });
    };
    rendLoginRedirectLink = (page) => {
        return (
            <div>
                <p>You must log in to view the page at {page}</p>
                <button onClick={this.login}>Log in</button>
            </div>
        );
    };
    rendLogin = () => {
        return (
            <div>
                <button onClick={this.login}>Log in</button>
                <form action="" className="b-popup__login" name="login" data-url="/get-site-data/" onSubmit={this.handleSubmit}>
                    <h1>Вход</h1>
                    <span className="input input--akira">
                      <input className="input__field input__field--akira" type="text" id="login-email" name="email" value={this.state.email} onChange={this.handleChange} />
                      <label className="input__label input__label--akira" htmlFor="login-email">
                        <span className="input__label-content input__label-content--akira">E-mail</span>
                      </label>
                    </span>
                    <span className="input input--akira">
                      <input className="input__field input__field--akira" type="password" id="login-password" name="password" value={this.state.password} onChange={this.handleChange} />
                      <label className="input__label input__label--akira" htmlFor="login-password">
                        <span className="input__label-content input__label-content--akira">Пароль</span>
                      </label>
                      <a href="#" className="link call-password-reset button-open">Забыли?</a>
                    </span>
                    <label className="input-checkbox text">
                        <input type="checkbox" name="remember-pass" checked={this.state['remember-pass']} onChange={this.handleChange} />
                        <span>Запомнить</span>
                    </label>
                    <input type="submit" name="submit" value="Login" />
                </form>
            </div>
        );
    };
    render() {
        const { from } = this.props.location.state || { from: { pathname: "/" } };
        const { redirectToReferrer } = this.state;

        if (redirectToReferrer) {
            return <Redirect to={from} />;
        }

        if (this.props.location.state) {
            return this.rendLoginRedirectLink(from.pathname);
        } else {
            return this.rendLogin();
        }
        
    }
}