/*
    Codes
*/

class Codes extends React.Component {
    showCodesList = () => {
        return this.props.codes.map((item, i) => {
            return (
                <CodeItem key={item.id} index={i} data={item} deleteCode={(data) => this.props.deleteCode(data)} editCode={(data) => this.props.editCode(data)} />
            )
        })
    };
    render() {
        if (this.props.codes) {
            return (
                <div className="form-group code">
                    <div className="form-group-title">Коды (codes):</div>
                    <div className="codes">
                        <input className="form-control" type="hidden" id="codes" name="codes" defaultValue="" />
                        {this.showCodesList()}
                    </div>
                    <ClearBoth />
                    <div>
                        <div className="btn-group">
                            <a role="button" className="btn btn-primary add-code" href="#" onClick={(event) => this.props.addCode(event)}>Добавить код</a>
                        </div>
                    </div>
                </div>
            );
        } else {
            return (
                <div className="form-group code">
                    <div className="form-group-title">Коды (codes):</div>
                    <ClearBoth />
                </div>
            );  
        }
    }
}


function mapStateToProps(state) {
    return {
        codes: state.codes
    }
}

function matchDispatchToProps(dispatch) {
    return bindActionCreators({addCode: addCode, deleteCode: deleteCode, editCode: editCode}, dispatch);
}

const ConnectedCodes = connect(mapStateToProps, matchDispatchToProps)(Codes);
