/*
    ZoneItem
*/

class ZoneItem extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            data: this.props.data,
            showZone: (this.props.data.added) ? true : false,
            showAddFields: false,
            count: 0
        };
        //this.onInputChange = this.onInputChange.bind(this);
    };
    onInputChange = (e) => {
        //console.log('AAA onInputChange ', e.target.name, e.target.value, e.target.checked);
        var currentData = this.state.data;
        currentData[e.target.name] = e.target.value;
        this.props.editZone(currentData);
    };
    onTargetsChange = (data) => {
        var eventData = {target: {name: 'targets',value: data}};
        this.onInputChange(eventData);
    };
    onSelectorsChange = (data) => {
        var eventData = {target: {name: 'selectors',value: data}};
        this.onInputChange(eventData);
    };
    onMoreSelectorsChange = (data) => {
        var eventData = {target: {name: 'more_selectors',value: data}};
        this.onInputChange(eventData);
    };
    onCodesChange = (data) => {
        var eventData = {target: {name: 'codes',value: data}};
        this.onInputChange(eventData);
    };
    remove = () => {
        this.props.deleteZone(this.props.data);
    };
    toggleShowZone = () => {
        this.setState({showZone: !this.state.showZone});
    };
    toggleShowAddFields = () => {
        this.setState({showAddFields: !this.state.showAddFields});
    };
    addAddFields = () => {
        this.state.data.addition.push({b:{}, e: {}, a: {}});
        this.setState({data: this.state.data});
    };
    removeAddFields = (i) => {
        var additions = this.state.data.addition;
        additions.splice (i, 1);
        this.setState({data: this.state.data});
    };
    eachCode = (item, i) => {
        var codeName = (item == '__rtb__') ? 'RTB' : item;
        return (
            <span key={i} className="codes-titles"> [ {codeName} ] </span>
        );
    };
    eachAddField = (item, i) => {
        return (
            <AddField key={i} index={i} data={item} onRemove={this.removeAddFields} />
        );
    };
    rendAddFields = () => {
        return (
            <div className="addition-fields">
                {this.state.data.addition && this.state.data.addition.map(this.eachAddField)}
                <span className="addition-add" onClick={this.addAddFields}>Добавить блок данных</span>
            </div>
        );
    };
    rendClosed = () => {
        var
            dataZone = this.state.data,
            isHiddenClass = (dataZone.disabled) ? ' is-hidden' : '';
        
        return (
            <div className={"zone-item" + isHiddenClass}>
                <span className="show-zone" onClick={this.toggleShowZone}><span className="close">+</span></span>
                <label className="for-zone" data-id={dataZone.id}>{dataZone.id}</label>
                <span className="zone-info">
                    ( <span className="size">{dataZone.width} X {dataZone.height}</span> ) &emsp;
                    {dataZone.codes && dataZone.codes.map(this.eachCode)}
                    <span className="info-comment">{dataZone.comment}</span>
                </span>
                <div className="delete-zone" onClick={this.remove}>&#215;</div>
            </div>
        );
    };
    rendOpen = () => {
        var
            dataZone = this.state.data,
            isHiddenClass = (dataZone.disabled) ? ' is-hidden' : '',
            targetsOptions = [];
        
        if (dataZone.selectors) {
            for (var i = 0; i < dataZone.selectors.length; i++) {
                targetsOptions[i] = dataZone.selectors[i];
            }
        }
        targetsOptions.push('selector-0');
        
        // Формируем список из title кодов для выбора:
        const allCodes = [];
        (store.getState()).codes.forEach(function(code) {
            allCodes.push(code.title);
        });
        allCodes.push('__rtb__');
        
        return (
            <div className={"zone-item" + isHiddenClass}>
                <span className="show-zone" onClick={this.toggleShowZone}><span className="open">&ndash;</span></span>
                <label className="for-zone" data-id={dataZone.id}>{dataZone.id}</label>
                <div className="delete-zone" onClick={this.remove}>&#215;</div>
                <div className="zone-content">
                
                    <div className="is-hidden">
                        <input type="checkbox" className="is_hidden" name="isActive" onChange={this.onInputChange} checked={!dataZone.disabled} />&nbsp;
                        <label htmlFor="is_hidden">Активная зона</label>
                    </div>
                    
                    <div className="styles">
                        <span className="title">styles:</span>
                        <input type="text" className="form-control styles" name="styles" onChange={this.onInputChange} value={dataZone.styles} />
                    </div>
                    
                    <div className="form-group selectors">
                        <Values data={dataZone.selectors} name={'selectors'} onEditValues={(data) => this.onSelectorsChange(data)} />
                    </div>
                    
                    <div className="form-group more_selectors">
                        <Values data={dataZone.more_selectors} name={'more_selectors'} title={'Доп. селекторы:'} onEditValues={(data) => this.onMoreSelectorsChange(data)} />
                    </div>
                    
                    <div className="form-group codes_id">
                        <Values data={dataZone.codes} name={'codes'} options={allCodes} onEditValues={(data) => this.onCodesChange(data)} />
                    </div>
                    
                    <div className="targets">
                        <SelectValue data={dataZone.targets} options={targetsOptions} name={'targets'} onChange={this.onTargetsChange} />
                    </div>
                
                    <div className="comment">
                        <textarea className="form-control comment" placeholder="Комментарий для зоны..." name="comment" onChange={this.onInputChange} value={dataZone.comment} />
                    </div>
                    
                    <div className="addition-data">
                        <input type="checkbox" className="addition" onChange={this.toggleShowAddFields} checked={this.state.showAddFields} />&nbsp;
                        <span>Показать addition (дополнительные поля данных)</span>
                        {this.state.showAddFields && this.rendAddFields()}
                    </div>
                    
                </div>
                <ClearBoth />
            </div>
        );
    };
    render() {
        if (this.state.showZone) {
            return this.rendOpen ();
        } else {
            return this.rendClosed ();
        }
    }
}