
const AllProvidersReducers = function(state, action) {
    
    if (state == undefined) {
        return [];
    }
    
    switch(action.type) {
    case 'SITEFORM_LOADDATA':
        //console.log('AAA AllProvidersReducers SITEFORM_LOADDATA ', action.payload);
        return (action.payload.allProviders) ? action.payload.allProviders : [];
    default: 
        return state;
    }
}

const ServiceReducers = function(state, action) {
    
    if (state == undefined) {
        return {
            onlyNative: false,
            forcedStart: false,
            payBlock: false,
            onlyGoods: false
        };
    }
    
    switch(action.type) {
    case 'SERVICE_CHANGE':
        return Object.assign({}, state, {[action.payload]: !state[action.payload]});
    case 'SITEFORM_LOADDATA':
        return {
            onlyNative: action.payload.onlyNative,
            forcedStart: action.payload.forcedStart,
            payBlock: action.payload.payBlock,
            onlyGoods: action.payload.onlyGoods
        };
    default: 
        return state;
    }
}

const CodesReducers = function(state, action) {
    
    if (state == undefined) {
        return false;
    }
    
    switch(action.type) {
    case 'SITEFORM_LOADDATA':
        return (action.payload.codes) ? action.payload.codes : [];
    case 'CODE_ADD':
        var currentId = (state.length == 0) ? 0 : state[state.length - 1].id;
        return state.concat({id: currentId+1, title: '', provider: '', code: '', added: true});
    case 'CODE_DELETE':
        var ind = state.indexOf(action.payload);
        return state.slice(0, ind).concat(state.slice(ind+1));
    case 'CODE_EDIT':
        return state.map( (item) => {
            if(item.id !== action.payload.id) {
                return item;
            }
            return action.payload;
        });
    default: 
        return state;
    }
}

const SlotsReducers = function(state, action) {
    
    if (state == undefined) {
        return false;
    }
    
    switch(action.type) {
    case 'SITEFORM_LOADDATA':
        return (action.payload.slots) ? action.payload.slots : [];
    case 'SLOT_ADD':
        var currentId = (state.length == 0) ? 0 : state[state.length - 1].id;
        return state.concat({
            added: true,
            disabled: false,
            id: currentId+1,
            name: currentId+1,
            n: {},
            o: {},
            f: {node: {}},
            /*
            zones: [],
            comment: '',
            m: '',
            ha: '',
            sh: null,
            s: null,
            n: {
                selector: '',
                parent: '',
                next: ''
            },
            o: {
                top: '',
                right: '',
                bottom: '',
                left: ''
            },
            f: {
                topOffset: '',
                bottomSync: 'bottom',
                node: {selector: ''}
            },
            */
        });
    case 'SLOT_DELETE':
        var ind = state.indexOf(action.payload);
        return state.slice(0, ind).concat(state.slice(ind+1));
    case 'SLOT_EDIT':
        return state.map( (item) => {
            if(item.id !== action.payload.id) {
                return item;
            }
            return action.payload;
        });
    case 'ZONE_ADD':
    case 'ZONE_DELETE':
        //console.log('AAA ZONE_ADD_DELETE 222');
        return state.map( (item) => {
            return item;
        });
    default: 
        return state;
    }
}

const ZonesReducers = function(state, action) {
    
    if (state == undefined) {
        return false;
    }
    
    switch(action.type) {
    case 'SITEFORM_LOADDATA':
        //console.log('AAA SITEFORM_LOADDATA = ', action.payload.zones);
        return (action.payload.zones) ? action.payload.zones : [];
    case 'ZONE_ADD':
        //console.log('AAA ZONE_ADD');
        var currentId = (state.length == 0) ? 0 : parseInt(state[state.length - 1].id);
        return state.concat({
            added: true,
            id: currentId+1,
            styles: '',
            addition: [],
        });
    case 'ZONE_DELETE':
        //console.log('AAA ZONE_DELETE');
        var ind = state.indexOf(action.payload);
        return state.slice(0, ind).concat(state.slice(ind+1));
    case 'ZONE_EDIT':
        //console.log('AAA ZONE_EDIT');
        return state.map( (item) => {
            if(item.id !== action.payload.id) {
                return item;
            }
            return action.payload;
        });
    case 'CODE_DELETE':
    case 'CODE_EDIT':    
        //console.log('AAA CODE_EDIT_DELETE 222');
        var newState = [];
        state.forEach(function(slotItem) {
            newState.push(slotItem);
        });
        return newState;        
    default: 
        return state;
    }
}

const HidezonesReducers = function(state, action) {
    
    if (state == undefined) {
        return false;
    }
    
    switch(action.type) {
    case 'SITEFORM_LOADDATA':
        return (action.payload.hidezones) ? action.payload.hidezones : [];
    case 'HIDEZONES_EDIT':
        var editState = [];
        action.payload.forEach(function(item) {
            editState.push(item);
        });
        return editState;
    default: 
        return state;
    }
}

const StophideReducers = function(state, action) {
    
    if (state == undefined) {
        return false;
    }
    
    switch(action.type) {
    case 'SITEFORM_LOADDATA':
        return (action.payload.stophide) ? action.payload.stophide : [];
    case 'STOPHIDE_EDIT':
        var editState = [];
        action.payload.forEach(function(item) {
            editState.push(item);
        });
        return editState;
    default: 
        return state;
    }
}

const ProvidersReducers = function(state, action) {
    
    if (state == undefined) {
        return false;
    }
    
    switch(action.type) {
    case 'SITEFORM_LOADDATA':
        return (action.payload.providers) ? action.payload.providers : [];
    case 'PROVIDERS_EDIT':
        var editState = [];
        action.payload.forEach(function(item) {
            editState.push(item);
        });
        return editState;
    default: 
        return state;
    }
}



// Combine Reducers
const allReducers = Redux.combineReducers({
    allProviders: AllProvidersReducers,
    service: ServiceReducers,
    hidezones: HidezonesReducers,
    stophide: StophideReducers,
    providers: ProvidersReducers,
    codes: CodesReducers,
    slots: SlotsReducers,
    zones: ZonesReducers,
});

const store = Redux.createStore(allReducers);
const Provider = ReactRedux.Provider;
const connect = ReactRedux.connect;
const bindActionCreators = Redux.bindActionCreators;

console.log('AAA store = ', store.getState());
