$(document).ready(function () {
    "use strict";
   
    var
        $categoriesWrap = $('.b-filters');

    // Отображение категорий-подкатеорий:
    $categoriesWrap.on('change', 'select.data-category, select.data-subcategory', function(){
        var
            $this = $(this);

        if ($this.hasClass('data-category')) {
            var
                catId = $this.val(),
                $subcatWrap = $('.b-offers-list_controls-subcategory', $this.parent()),
                $subcategory = $('.data-subcategory', $this.parent()),
                $options = $('option', $subcategory);

            // Показываем выбор подкатегрий:
            (catId) ? $subcatWrap.show() : $subcatWrap.hide();
            // Устанавливаем набор подкатегрий:
            $options.addClass('hidden').prop('selected', false).filter('[data-parent="'+ catId +'"]').removeClass('hidden');
            $options.filter('[value=""]').removeClass('hidden');
        }
        
    });
    
    // Работа со списками:
    (function(){
        
        var
            $selectAllItems = $('table.offers thead tr th input.select-all'),
            $markCount = $('.b-offers-list_controls .mark-count b'),
            $actionsWrap = $('.b-data-item_action'),
            $actions = $('table.offers thead tr th b.action'),
            $applyButton = $('button.btn.btn-primary.apply');
        
        // Обработка получения новых данных:
        $applyButton.click(function(){
            $selectAllItems.prop('checked', false).change();
        });
        
        // Клик на галочку "Выбрать все":
        $selectAllItems.on('change', function(){
            var
                $this = $(this),
                isSelected = $this.prop('checked'),
                $tableTr = $('table.offers tbody tr'),
                markCount = 0;
                
            if (isSelected) {
                $tableTr.each(function(){
                    var $trItem = $(this);
                    if (!$trItem.hasClass('hidden') && $trItem.is(':visible')) {
                        $('input.is-active', $trItem).prop('checked', true);
                        $actionsWrap.show();
                        $actions.removeClass('hidden');
                        markCount++;
                    }
                });
            } else {
                $tableTr.each(function(){
                    $('input.is-active', $(this)).prop('checked', false);
                });
                $actionsWrap.hide();
                $actions.addClass('hidden');
            }
            
            $markCount.text(markCount);
        });
        
        // Клик на галочку в списке:
        $('table.offers').on('change', 'input.is-active', function(){
            var
                offersIsCheched = false,
                markCount = 0;
                
            $('table.offers input.is-active').each(function(){
                if ($(this).is(':checked')) {
                    offersIsCheched = true;
                    markCount++;
                }
            });
            
            if (offersIsCheched) {
                $actionsWrap.show();
                $actions.removeClass('hidden');
                $selectAllItems.prop('checked', true);
            } else {
                $selectAllItems.prop('checked', false);
                $actionsWrap.hide();
                $actions.addClass('hidden');
            }

            $markCount.text(markCount);
        });

        // Выбор действия с выделенными элементами:
        $actions.on('click', function(){

            var
                $this = $(this),
                actionType = $this.hasClass('activate') ? 'active' : 'disable',
                $wrap = $this.parents('.panel-body'),
                selectedOffersId = [];

            $('table tbody tr', $wrap).each(function() {
                var $item = $(this);
                if ($('input.is-active', $item).is(':checked')) {
                    selectedOffersId.push($item.data('id'));
                }
            });

            // Запрос на изменение статуса выбранных офферов:
            if (selectedOffersId.length > 0) {

                var
                    action = $('table', $wrap).data('action'),
                    method = 'POST',
                    data = {
                        'toggle_active': 1,
                        'is_active': (actionType == 'active') ? 1 : 0,
                        'id_offers': selectedOffersId,
                    };

                $.ajax(action, {
                    type: method,
                    data: data,
                    success: function(data) {
                        $applyButton.click();
                        /*
                        $('table tbody tr', $wrap).each(function() {
                            var $item = $(this);
                            if ($('input.is-active', $item).is(':checked')) {
                                switch(actionType) {
                                    case 'active':
                                        $item.removeClass('disabled');
                                    break;
                                    case 'disable':
                                        $item.addClass('disabled');
                                    break;
                                }
                            }
                        });
                        */
                    },
                    error: function(rew, status, err) {
                        console.log(status, err);
                    }
                });

            }

        });
        
        
    })();
    
});