$(document).ready(function(){
    
    (function(){
        
            
        // Выбор дат для Stat http://t1m0n.name/air-datepicker/docs/index-ru.html
        var
            nowDate = new Date(),
            datepicker1 = $('#date-value-1').datepicker({
                dateFormat: "yyyy-mm-dd",
                autoClose: true,
                maxDate: nowDate
            }).data('datepicker'),
            datepicker2 = $('#date-value-2').datepicker({
                dateFormat: "yyyy-mm-dd",
                autoClose: true,
                maxDate: nowDate
            }).data('datepicker'),
            currentDay1 = new Date($('#date-value-1').val()),
            currentDay2 = new Date($('#date-value-2').val());

            // Установка стартовых значений дат:
            datepicker1.selectDate(currentDay1);
            datepicker2.selectDate(currentDay2);
    
    })();
    
    
    var 
        $chartStat = $('#chart-graph-stat'),
        $chartTable = $('#table-stat'),
        $chartStatInfo = $('.chart-graph-stat-info'),
        $chartStatError = $('.chart-graph-stat-error'),
        $chartStatLoading = $('.chart-graph-stat-loading'),
        $chartStatErrorMessage = $('.chart-graph-stat-error .message'),
        dataLineChartStat;
    
    // Получение данных для отрисовки графика Stat при старте:
    if ($('#period-stats').val()) {
        dataLineChartStat = JSON.parse($('#period-stats').val());
    }
    
    // Отрисовка графика и таблицы по стартовым данным:
    renderLineChart();
    renderHourTable();
    
    // Сортировка по колонкам внутри таблицы:
    $('#table-line').on('click', 'thead.metric.sortable th b', function(){
        $('#table-line thead.metric.sortable th b').removeClass('selected');
        $(this).addClass('selected');
        $(this).toggleClass('desc');
        renderHourTable();
    });
    
    // Клик на checkbox в названии поля таблицы:
    $('#table-line').on('change', 'thead.metric.sortable th input[type="checkbox"]', function(){
        //var $this = $(this);
        //console.log('AAA check ', $this.data('field'), ' ', $this.prop('checked'));
        renderLineChart();
    });
    
    
    // Отрисовка графика Stat
    function renderLineChart()
    {
        if(dataLineChartStat) {
            $.ChartStat.DateStat(dataLineChartStat);
            return false;
        }
    }
    
    // Отрисовка почасовой таблицы
    function renderHourTable()
    {
        if(dataLineChartStat) {
            $.TableStat.Render(dataLineChartStat);
            $chartTable.show();
        } else {
            $chartTable.hide();
        }     
    }
    
    
});