<?php
/**
 * Copyright (c) 2017 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

use App\Model\Translations;

if (!(isset($containter) && $containter instanceof \Interop\Container\ContainerInterface)) {
    chdir(dirname(__DIR__));
    require 'vendor/autoload.php';

    /** @var \Interop\Container\ContainerInterface $containter */
    $containter = require 'config/container.php';
}


echo 'FIX translations context and incorrect linebreaks';

$translationsModel = $containter->get(Translations::class);
$dirsToProceed = $translationsModel->getDirs();

foreach ($dirsToProceed as $dir) {
    $files = array_diff(scandir($dir), ['..', '.']);
    foreach ($files as $file) {
        $data = file_get_contents($dir . DIRECTORY_SEPARATOR . $file);
        if ($data) {
            // remove unused msg context
            $result = str_replace([
                'msgctxt "vacancies.items"',
                'msgctxt "faq.categories"',
                'msgctxt "faq.items"',
            ], '', $data);
            // remove incorrect line feed characters
            $result = str_replace([
                '\n\\n'
            ], '\\n', $result);
            echo 'Proceed ' . $dir . DIRECTORY_SEPARATOR . $file . PHP_EOL;
            file_put_contents($dir . DIRECTORY_SEPARATOR . $file, $result);
        }

    }
}