<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Model\Feeds;

use App\Model\Common;


/**
 * Class OrdersStatus
 * @package App\Model
 */
class OrdersStatus extends Common
{
    
    public function saveRetargOrderStatus($entity, $action)
    {
        $data_entity = $this->delegatingHydrator->extract($entity);
        
        $table_fields = $this->tableGateway->getColumns();
        $data = [];
        foreach ($table_fields as $field) {
            if (isset($data_entity[mb_strtolower($field)])) {
                $data[$field] = $data_entity[mb_strtolower($field)];
            }
        }
        
        if ($action == 'insert') {
            $query = function($data) {
                $this->tableGateway->insert($data);
                return $data['order_id'];
            };
        }
        
        if ($action == 'update') {
            $query = function($data) {
                $id = $data['order_id'];
                unset($data['order_id']);
                $this->tableGateway->update($data, ['order_id' => $id]);
                return $id;
            };
        }
        
        try {
            $this->tableGateway->getAdapter()->getDriver()->getConnection()->beginTransaction();
            $id = $query($data);
            $this->tableGateway->getAdapter()->getDriver()->getConnection()->commit();
        } catch (\Exception $e) {
            $this->tableGateway->getAdapter()->getDriver()->getConnection()->rollback();
            throw $e;
        }
        return $id;
        
    }
    
    /*
    public function deleteRetargCatFee($entity)
    {
        $result = false;
        $cat_id = $entity->getCatid();
        
        if ($entity) {
            $result = $this->tableGateway->delete(['CatID' => $cat_id]);
        } else {
            throw new \Exception("Record not found ID:" . $cat_id);
        }

        return $result;
    }
    */
}