$(document).ready(function () {
    "use strict";
    
    // Свернуть-развернуть дочерние ячейки в таблице:
    $('.table.campaigns').on('click', 'span.group', function(e) {

        var
            $this = $(this),
            $tableBody = $('tbody', $this.parents('table')),
            $wrap = $this.parents('tr').eq(0),
            id = $wrap.data('id'),
            isOpen,
            $subcats = $('tr.campaign-item[data-parent="'+ id + '"]', $tableBody);

        $this.toggleClass('open');
        isOpen = $this.hasClass('open');

        if (isOpen) {
            $subcats.addClass('open');
        } else {
            $subcats.removeClass('open');
        }

    });
    
    // Разворачиваем списки групп кампаний при старте:
    $('.table.campaigns span.group').click();
    
    // Фильтрация для таблицы:
    var
        $table = $('.table.campaigns'),
        $selectStatus = $('.form-control.campaign-status'),
        filters = ['all', 'active', 'not-active', 'archive', 'not-archive'],
        cookieName = 'table_filter_status',
        currentFilter = ($.cookie(cookieName)) ? $.cookie(cookieName) : 'not-archive';
    
    function setTableFilter(val)
    {
        $selectStatus.val(val);
        filters.forEach(function(item) {
            $table.removeClass(item);
        })
        $table.addClass(val);
        $.cookie(cookieName, val, { expires : 365 });
    }
    
    $selectStatus.on('change', function(){
        setTableFilter($(this).val());
    });
    
    // Устанавливаем по-умолчанию фильтр для таблицы:
    setTableFilter(currentFilter);
    
});

