$(document).ready(function(){

    $('.wrapp-button').on('click', function(){
        
        var
            $this = $(this),
            form = $(this).parent('form')[0],
            formData = new FormData(form),
            redirectUrl = $(form).attr("data-url-success");

        if ($this.eq(0).hasClass("reset")) {
            document.location.href = redirectUrl;
        } else {
            $.ajax({
                url: $(form).attr("data-url"),
                type: "POST",
                contentType: false,
                processData: false,
                data: formData,
                successUrl: form.getAttribute("data-url-success"),
                fadePanel: $this,
                success: function(data) {
                    if (data.result) {
                        console.log(data);
                        $.showMessage('info', $this.data('action'));
                        setTimeout(function(){
                            //document.location.reload();
                            document.location.href = redirectUrl;
                        }, 1000);                        
                    } else {
                        console.log(data);
                        $.showMessage('error', data.msg.text);
                    }
                },
                error: function (e) {
                    console.log('error: ', e);
                }
            });
        }

        return false;
    });

    
});