<?php
use Interop\Container\ContainerInterface;

return [
    'dependencies' => [
        'factories' => [
            \App\Authentication\Tokenizer\Authentication::class => function (ContainerInterface $container) {
                $secret = $container->get('config')['authentication']['token']['secret'];
                $expire = $container->get('config')['authentication']['token']['expire'];
                if (!$secret) {
                    throw new Exception('secret key required');
                }
                if (!$expire) {
                    throw new Exception('secret key expire required');
                }
                return new \App\Authentication\Tokenizer\Authentication(
                    $secret,
                    $expire
                );
            },
            \App\Authentication\Tokenizer\Confirmation::class => function (ContainerInterface $container) {
                $secret = $container->get('config')['confirmation']['token']['secret'];
                $expire = $container->get('config')['confirmation']['token']['expire'];
                if (!$secret) {
                    throw new Exception('secret key required');
                }
                if (!$expire) {
                    throw new Exception('secret key expire required');
                }
                return new \App\Authentication\Tokenizer\Confirmation(
                    $secret,
                    $expire
                );
            },
            \Zend\Authentication\AuthenticationService::class => function (ContainerInterface $container) {
                return new \App\Authentication\AggregateAuth(
                    $container->get(\App\Authentication\UserService::class),
                    $container->get(\App\Authentication\SupportService::class)
                );
            },
            \App\Authentication\UserService::class => function (ContainerInterface $container) {
                return new \App\Authentication\UserService(
                    $container->get(\App\Model\Users::class),
                    $container->get(\App\Authentication\Tokenizer\Authentication::class)
                );
            },
            \App\Authentication\SupportService::class => function (ContainerInterface $container) {
                return new \App\Authentication\SupportService(
                    $container->get(\App\Model\Supports::class),
                    $container->get(\App\Authentication\Tokenizer\Authentication::class)
                );
            },
            \App\Authentication\AggregateAuth::class => function (ContainerInterface $container) {
                return new \App\Authentication\AggregateAuth(
                    $container->get(\App\Authentication\UserService::class),
                    $container->get(\App\Authentication\SupportService::class)
                );
            },
            \App\Middleware\Authentication::class => function (ContainerInterface $container) {
                return new \App\Middleware\Authentication(
                    $container->get(\Zend\Authentication\AuthenticationService::class),
                    $container->get(\App\Action\Logout::class)
                );
            },
            \App\Middleware\Authorization::class => function (ContainerInterface $container) {
                return new \App\Middleware\Authorization(
                    $container->get(\Zend\Authentication\AuthenticationService::class),
                    $container->get(\Zend\Permissions\Acl\AclInterface::class),
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container->get('layout')
                );
            },
        ],
    ],

    'authentication' => [
        'token' => [
            'expire' => 604800, // 1 week - time to expire in seconds
            'secret' => 'RecYQSyKdZpMpCxGaRewX8sB9CATtG8tGFwf4Wqd4MWxYSthbGk65WSrt9WJWAJVtJe9HsXmaUHp9V8q', // secret key for token signing algorithm
        ],
    ],

    'confirmation' => [
        'token' => [
            'expire' => 86400, // 1 day - time to expire in seconds
            'secret' => 'CsmAaFVJE5BVjV6H4FcXhwYLnrU7LgzsXhdRrppuAE6GWrL7PGa9up428K2NubWLPnQCqccn7UgFFJYu', // secret key for token signing algorithm
        ],
    ],
];
