$(document).ready(function () {
    "use strict";
    
    /* Стр. создания-редактирования кампании */
    
    var
        $contentWrap = $('.b-content__work.inner'),
        isCreatePage = $('.campaign-id').data('id') == 0,
        datepicker1 = $('#campaign-date-begin').datepicker({
            dateFormat: "yyyy-mm-dd",
            autoClose: true,
            onSelect: function(fd, d, picker) {
                dataChanged($('#campaign-date-begin'));
            },
        }).data('datepicker'),
        datepicker2 = $('#campaign-date-end').datepicker({
            dateFormat: "yyyy-mm-dd",
            autoClose: true,
            onSelect: function(fd, d, picker) {
                dataChanged($('#campaign-date-end'));
            },
        }).data('datepicker'),
        $form = $('#campaign-create-form', $contentWrap),
        isChanged = false,
        popupIsOpen = false,
        changeContriolsListenerIsActive = false,
        $checkTrackingAction = $('#group-tracking-action'),
        $btnSubmitAction = $('.btn.submit-action', $form),
        $btnCancelAction = $('.btn.cancel-action', $form),
        $btnArchive = $('.action-archive', $form),
        $btnArchiveSend = $('.action-archive.send', $form),
        $btnArchiveRemove = $('.action-archive.remove', $form);
    
    // Покидание страницы:
    window.onbeforeunload = function(e) {
        if (isChanged || popupIsOpen) {
            return "Данные не сохранены. Закрыть страницу без сохранения?";
        }
    };
    
    function CheckNullValueInput(value) {
        return ($.trim(value) != '') ? $.trim(value) : null;
    }
    
    function CheckFloatValueInput(value) {
        value = value.replace(',', '.');
        return (isNaN(parseFloat(value))) ? null : parseFloat(value);
    }
    
    function checkPriceValue() {
        var
            $inputPrice = $('input#campaign-price', $form),
            $notice = $('.form-group.price .value-notice', $form);
        
        if ($inputPrice.val() == '') {
            $notice.show();
        } else {
            $notice.hide();
        }
    }
    
    function checkOrderSumValue() {
        var
            $inputOrderSum = $('input#campaign-order-sum', $form),
            $notice = $('.form-group.tracking-action .value-notice', $form);
        
        if ($inputOrderSum.val() == '') {
            $notice.show();
        } else {
            $notice.hide();
        }
    }
    
    function CheckTrackingAction($check) {
        var
            $content = $('.tracking-action_content'),
            isChecked = $check.prop("checked");
    
        if (isChecked) {
            $content.show();
        } else {
            $content.hide();
        }
    }
    
    function dataChanged($target)
    {
        if (changeContriolsListenerIsActive) {
            isChanged = true;
            $btnCancelAction.attr('disabled',false);
            $btnSubmitAction.attr('disabled',false);
            
            var
                $formGroup = $target.parents('.form-group').eq(0),
                $label = $('label.title-field', $formGroup);

            $label.addClass('changed');
            
            // Название в header-панели
            if ($formGroup.hasClass('title')) {
                $target.siblings('.value-show').addClass('changed');
            }
        }
    }
    
    function AddListenerChangeContriols()
    {
        changeContriolsListenerIsActive = true;
        // Действие по какому-либо контролу:
        $form.on('change', 'input, select:not(.banners-status)', function(){
            dataChanged($(this));
        });
        $form.on('keyup', 'input', function(){
            dataChanged($(this));
        });
        $('.panel-heading input.campaign-title').on('change', function(){
            dataChanged($(this));
        });
    }
    
    // Клик на редактируемый элемент (название кампании):
    $contentWrap.on('click', '.edited', function(){
        var
            $field = $(this),
            fieldName = $field.data('field'),
            $input = $('input.'+fieldName, $field.parent()),
            oldVal = $input.val(),
            oldText = $field.html();
        
        $field.hide();
        $input.off('blur').off('keyup').show().focus();
        
        $input.on('keyup', function(e) {
            
            if (e.keyCode == 13) {
                $input.blur();
            }
            
            if (e.keyCode == 27) {
                $input.off('blur');
                $input.val(oldVal);
                $field.html(oldText);
                $input.hide();
                $field.show();
            }
           
        });
        $input.on('blur', function() {
            
            var
                textInput = $input.val(),
                textField = textInput;
            
            $input.hide();
            $field.html(textField);
            
            if (textInput != oldVal) {
                $field.addClass('was-edited');
            }
            
            $field.show();
        });
    });
    
    // Изменение стоимости
    $('input#campaign-price', $form).on('keyup', function(){
        checkPriceValue();
    });
    checkPriceValue();
    
    // Клик на галочку Трекинг действий:
    $checkTrackingAction.on('change', function(e) {
        CheckTrackingAction($(this));
    });
    CheckTrackingAction($checkTrackingAction);
    
    // Изменение значения Цена действия по-умолчанию:
    $('input#campaign-order-sum', $form).on('keyup', function(){
        checkOrderSumValue();
    });
    checkOrderSumValue();
    
    // Редактирование элементов формы:
    (function(){
        
        var
            $popupBg = $('.l-popup'),
            $popupEdit = $('.b-popup__window.edit', $popupBg),
            $popupInner = $('.b-popup-inner', $popupEdit),
            $popupClose = $('.button-close', $popupEdit),
            $popupTitle = $('.b-popup-content h1', $popupEdit),
            $saveBtn = $('.btn.save-edit', $popupEdit),
            $cancelBtn = $('.btn.cancel-edit', $popupEdit);
        
        // Склонение числительных
        function declOfNum(number, titles) {
            var cases = [2, 0, 1, 1, 1, 2];
            return titles[ (number%100 > 4 && number %100 < 20) ? 2 : cases[Math.min(number%10, 5)] ];
        }
        
        function ChangeEditValue($formGroup) {

            var
                type = $formGroup.data('type'),
                $valueShow = $('.value-show', $formGroup),
                $valueEdit = $('.value-edit', $formGroup),
                content = '';

            if (type == 'title') {
                content = $('input', $valueEdit).val();
            }
            if (type == 'url') {
                var urlValue = $('input', $valueEdit).val();
                content = '<a href="' + urlValue + '" target="_blank">' + urlValue + '</a>';
            }
            if (type == 'visitor-limit') {
                $('.campaign-visitor-limit input', $valueEdit).each(function(){
                    var
                        $this = $(this),
                        itemVal = parseInt($this.val());

                    if (itemVal) {
                        var titles = ($this.parent().hasClass('view')) ? ['показ', 'показа', 'показов'] : ['клик', 'клика', 'кликов'];
                        content += '<span><b>' + itemVal + '</b> <i>' + declOfNum(itemVal, titles) + '</i> ' + $this.data('desc') + '</span><br />';
                    }
                });
            }
            if (type == 'money-limit') {
                $('input', $valueEdit).each(function(){
                    var
                        $this = $(this),
                        itemVal = CheckFloatValueInput($this.val());

                    if (itemVal) {
                        var titles = 'грн.';
                        content += '<span><b>' + itemVal + '</b> ' + titles + ' ' + $this.data('desc') + '</span><br />';
                    }
                });
            }
            if (type == 'geo') {
                var
                    countryVal = $('.geo_country select option:selected', $valueEdit).text(),
                    regionItems = [],
                    cityItems = [],
                    regionVal = '',
                    cityVal = '';

                if ($('.geo_country select', $valueEdit).val() == 'UA' && $('.geo_country .b-exclude input').is(':checked')) {
                    countryVal += ' (исключить неподконтрольные территории)';
                }
                content += '<span>Страна: <b>' + countryVal + '</b></span><br />';

                $('.geo_region .filters-values ul li input', $valueEdit).each(function(){
                    regionItems.push($(this).data('text').replace(' область', ''));
                });
                if (regionItems.length > 0) {
                    regionVal += ($('.geo_region .b-exclude input', $valueEdit).is(':checked')) ? '<i>кроме:</i> ' : '<i>только:</i> ';
                    regionVal += '<b>' + regionItems.join(', ') + '</b>';
                    content += '<span>Области ' + regionVal + '</span><br />';
                }

                $('.geo_city .filters-values ul li input', $valueEdit).each(function(){
                    cityItems.push($(this).data('text'));
                });
                if (cityItems.length > 0) {
                    cityVal += ($('.geo_city .b-exclude input', $valueEdit).is(':checked')) ? '<i>кроме:</i> ' : '<i>только:</i> ';
                    cityVal += '<b>' + cityItems.join(', ') + '</b>';
                    content += '<span>Города ' + cityVal + '</span><br />';
                }

                var
                    geoData = {},
                    countryValue,
                    countryExclude,
                    regionValues = [],
                    regionExclude,
                    cityValues = [],
                    cityExclude,
                    isGeoSet;

                // country
                countryValue = $('select#targeting_geo_country', $formGroup).val();
                countryExclude = ($('input#country-exclude', $formGroup).is(':checked')) ? true : false;
                geoData['country'] = {
                    values: [countryValue],
                    exclude: false
                };

                // special
                if (countryValue == 'UA' && countryExclude) {
                    geoData['special'] =  {
                        values: ["ATO", "Crimea"],
                        exclude: true
                    }
                }

                // region
                $('.geo_region .filters-values ul li', $formGroup).each(function(){
                    regionValues.push(parseInt($('input', $(this)).data('id')));
                });
                regionExclude = ($('input#region-exclude', $formGroup).is(':checked')) ? true : false;
                geoData['region'] = {
                    values: regionValues,
                    exclude: regionExclude
                };

                // city
                $('.geo_city .filters-values ul li', $formGroup).each(function(){
                    cityValues.push(parseInt($('input', $(this)).data('id')));
                });
                cityExclude = ($('input#city-exclude', $formGroup).is(':checked')) ? true : false;
                geoData['city'] = {
                    values: cityValues,
                    exclude: cityExclude
                };

                if ((countryValue == 'UA' && countryExclude) && (regionValues.length == 0) && (cityValues.length == 0)) {
                    isGeoSet = false;
                } else {
                    isGeoSet = true;
                }

                // Проверка на совпадение данных с родительскими:
                var
                    $groupValue = $('#group-targeting-value'),
                    geoGroupValues = ($groupValue.length > 0) ? JSON.parse($groupValue.val()) : null;

                if (geoGroupValues) {
                    if (JSON.stringify(geoGroupValues.geo) === JSON.stringify(geoData)) {
                        isGeoSet = false;
                    }
                }

                if (isGeoSet) {
                    $formGroup.removeClass('null-value');
                    $formGroup.attr('data-value', JSON.stringify({geo: geoData}))
                } else {
                    $formGroup.addClass('null-value');
                    $formGroup.attr('data-value', null)
                }

            }
            if (type == 'tracking-pixels') {

                var
                    dataTrackingPixels = {},
                    isTrackingPixelsSet = false;

                $('.tracking_pixels_item', $formGroup).each(function(){

                    var
                        $this = $(this),
                        name = $this.data('name'),
                        dataValues = [],
                        noItems = true,
                        inputValue;

                    $('.tracking_pixels_urls input', $this).each(function(){
                        var $input = $(this);
                        if ($input.val()) {
                            isTrackingPixelsSet = true;
                            if (noItems) {
                                content += '<div>' + $('label', $this).text() + '</div>';
                                noItems = false;
                            }
                            inputValue = $.trim($input.val());
                            content += '<div class="url"><a href="' + inputValue + '" target="_blank">' + inputValue + '</a></div>';
                            dataValues.push(inputValue);
                        }
                    });

                    dataTrackingPixels[name] = dataValues;
                });
                if (isTrackingPixelsSet) {
                    $formGroup.attr('data-value', JSON.stringify(dataTrackingPixels))
                } else {
                    $formGroup.attr('data-value', null)
                }

            }

            $valueShow.empty().append(content);
        }
        
        function AddEditPopupEventsListener() {
            // Закрыввем попап по клику на Х:
            $popupClose.on('click', function(){
                ClosePopupEdit();
            });
            // Закрыввем попап по клику извне:
            /*
            $popupEdit.on('click', function(event){
                event.stopPropagation();
            });
            
            $popupBg.on('click', function(){
                ClosePopupEdit();
            });
            */
            
            AddControlsEventsListener();
        }
        
        function RemoveEditPopupEventsListener() {
            $popupClose.off('click');
            $popupEdit.off('click');
            $popupBg.off('click');
        }
        
        function ShowPopupEdit(type, title, data)
        {
            popupIsOpen = true;
            $saveBtn.attr('disabled', true);
            InsertPopupEdit(title, data);
            $popupBg.addClass('open-popup');
            $popupEdit.show();
            $popupEdit.attr('data-type', type);
            AddEditPopupEventsListener();
        }
        
        function ClosePopupEdit()
        {
            popupIsOpen = false;
            $popupBg.removeClass('open-popup');
            $popupEdit.hide();
            $popupInner.empty();
            RemoveEditPopupEventsListener();
        }
        
        function InsertPopupEdit(title, data)
        {
            $popupTitle.text(title);
            $popupInner.append(data);
        }

        function AddControlsEventsListener()
        {
            // Действие по какому-либо контролу внутри попапа:
            $('input, select', $popupInner).on('change', function(){
                $saveBtn.attr('disabled', false);
            });
            $('input', $popupInner).on('keyup', function(){
                $saveBtn.attr('disabled', false);
            });
            $('.add-row, .delete-item', $popupInner).on('click', function(){
                $saveBtn.attr('disabled', false);
            });
            
            // Добавление/удаление tracking_pixels urls
            (function(){
                
                $popupEdit.on('click', '.tracking_pixels_item .add-row', function(){
                    var
                        $this = $(this),
                        $trackingItem = $this.parents('.tracking_pixels_item'),
                        $urlsWrap = $('.tracking_pixels_urls', $trackingItem);
                    $urlsWrap.append('<div class="url-item"><input type="text" class="form-control" value="" placeholder="url"><div class="delete-item">×</div></div>');
                });
                $popupEdit.on('click', '.tracking_pixels_urls .delete-item', function(){
                    $(this).parent().remove();
                });
                
            })();
            
            // Гео
            (function(){
            
                var
                    $geoCountrySelect = $('.form-control#targeting_geo_country', $popupEdit),
                    $geoWrap = $('.targeting_geo', $popupEdit);
            
                // Изменение значения страны
                $geoCountrySelect.on('change', function(){
                    var $geoCountryExclude = $('.geo_country .b-exclude', $popupEdit);
                    if ($(this).val() == 'UA') {
                        $geoCountryExclude.show();
                    } else {
                        $geoCountryExclude.hide();
                    }
                });
                
                // Изменение списка фильтров чекбоксом:
                $geoWrap.on('change', '.geo_region-city .list-filter input',function(){

                    var
                        $this = $(this),
                        $listItems = $('li', $this.parents('ul')),
                        $listString = $('.values-string-list', $this.parents('.form-group')[0]),
                        values = [],
                        tplId = ($this.parents('.geo_region').length) ? 'l-region-id-' : 'l-city-id-';

                    $this.attr('checked', $this.is(':checked'));

                    $listItems.each(function(){
                        var
                            $this = $(this),
                            $checkbox = $('input', $this);

                        if ($checkbox.is(':checked')) {
                            values.push([$checkbox.data('id'), $checkbox.data('text')]);
                        }
                    });

                    // Редактируем список выбранных фильтров справа:
                    $listString.empty();
                    if (values.length > 0) {
                        values.forEach(function(valuesItem) {
                            $listString.append('<li><input type="checkbox" checked id="' + tplId + valuesItem[0] + '" data-id="' + valuesItem[0] + '" data-text="' + valuesItem[1] + '"> <label for="' + tplId + valuesItem[0] + '">' + valuesItem[1] + '</label></li>');
                        });
                    }
                    //$listString.trigger('change-list');

                });

                // Удаление из списка фильтров снятием галочки:
                $geoWrap.on('change', '.geo_region-city .values-string-list input',function(){
                    var
                        itemId = $(this).data('id'),
                        $listFilterItem = $('.list-filter input[data-id="' + itemId + '"]', $(this).parents('.form-group'));

                    $listFilterItem.attr('checked', false);
                    $listFilterItem.change();
                });

                // Изменение фильтрации внутри фильтра:
                $geoWrap.on('keyup', '.geo_region-city input.filter',function(){
                    var
                        $this = $(this),
                        val = $this.val().toLowerCase(),
                        $listItems = $('li', $this.parents('.filters-select'));


                    // Фильтрация списка значений:
                    $listItems.each(function(){
                        var
                            $item = $(this),
                            itemTitle = $('input', $item).data('text').toLowerCase(),
                            filteredByVal = itemTitle.indexOf(val) == 0;

                        $item.hide().removeClass('filtered');
                        if (filteredByVal) {
                            $item.show().addClass('filtered');
                        }
                    });

                });
                
            })();
        }

        // Клик на "Правка" для блока
        $('.form-group').on('click', '.edit-item', function(){
            var
                $this = $(this),
                $formGroup = $this.parents('.form-group').eq(0),
                typeGroup = $formGroup.data('type'),
                $valueEdit = $('.value-edit', $formGroup),
                titleGroup = $('label.title-field', $this.parent()).text();

            $formGroup.attr('data-tempstate', $valueEdit.html());

            ShowPopupEdit(typeGroup, titleGroup, $valueEdit.html());
            
            return false;
        });

        // Клик на "Сохранить" значение блока
        $saveBtn.on('click', function(){
            
            if ($(this).attr('disabled') == 'disabled') return false;
            
            var
                type = $popupEdit.attr('data-type'),
                $formGroup = $('.form-group[data-type="' + type + '"]'),
                $valueEdit = $('.value-edit', $formGroup);
                
            $formGroup.attr('data-tempstate', null);
            
            $('input', $popupEdit).each(function(){
                var $this = $(this);
                $this.attr("value", $.trim($this.val()));
            });
           
            $valueEdit.html($popupInner.html());
            
            ChangeEditValue($formGroup);
           
            ClosePopupEdit();
            dataChanged($valueEdit);
            return false;
        });

        // Клик на "Отменить" редактирование блока
        $cancelBtn.on('click', function(){
            var
                type = $popupEdit.attr('data-type'),
                $formGroup = $('.form-group[data-type="' + type + '"]'),
                $valueEdit = $('.value-edit', $formGroup);
                
            $valueEdit.html($formGroup.attr('data-tempstate'));
            $formGroup.attr('data-tempstate', null);

            ClosePopupEdit();
            return false;
        });

        // Устанавливаем стартовые значения блоков формы
        if (!isCreatePage) {
            $('.form-group[data-type]').each(function(){
                ChangeEditValue($(this));
            });
        }
        
    })();
    
    // Баннеры:
    (function(){
        
        var
            $popupBg = $('.l-popup'),
            $popup = $('.b-popup__window.preview', $popupBg),
            $popupClose = $('.button-close', $popup),
            $popupInner = $('.b-popup-content', $popup),
            $popupMessage = $('.b-popup-message', $popup),
            $banners = $('.form-group.banners', $form),
            $tableBanners = $('table.campaign-banners', $banners),
            $addItem = $('.add-row', $banners),
            $inputImage = $('input#img', $banners);
        
        
        if (!isCreatePage)
        {
            // Фильтрация в таблице баннеров:
            $('.panel-body').filterAmsystemTable({
                table: '.table.campaign-banners',
                selectStatus: '.form-control.banners-status',
            });
            
            // Сортировка в таблице баннеров:
            $tableBanners.sortAmsystemTable();
        }
        
        
        // Открываем попап превью:
        $tableBanners.on('click', '.banner-preview', function(){
            var
                $this = $(this),
                size = $.trim($('.banner-size', $this.parents('tr')).text()),
                data = {
                    id: $this.parents('tr').data('id'),
                    size: size.split('x'),
                    img: $this.attr('src')
                };
                
            ShowPopup('preview', data);
        });
        // Открываем попап добавления баннера:
        $addItem.on('click', function(){
            ShowPopup('add');
        });
        
        function AddPreviewPopupEventsListener() {
            // Закрыввем попап по клику на Х:
            $popupClose.on('click', function(){
                ClosePopup();
            });
            // Закрыввем попап по клику извне:
            /*
            $popup.on('click', function(event){
                event.stopPropagation();
            });
            $popupBg.on('click', function(){
                ClosePopup();
            });
            */
        }
        
        function RemovePreviewPopupEventsListener() {
            $popupClose.off('click');
            $popup.off('click');
            $popupBg.off('click');
        }
        
        function ShowPopup(type, data)
        {
            if (type == 'preview') InsertPopupPreview(data);
            if (type == 'add') InsertPopupAdd();
            
            $popupBg.addClass('open-popup');
            $popup.show();
            AddPreviewPopupEventsListener();
        }
        
        function ClosePopup()
        {
            $popupBg.removeClass('open-popup');
            $popupMessage.hide();
            $popup.hide();
            $popupInner.empty();
            RemovePreviewPopupEventsListener();
        }
        
        function InsertPopupPreview(data)
        {
            var $content = $(document.createElement('div'));
            
            $content.append('<h2>id: <b>'+ data.id +'</b> <span>('+ data.size[0] +'х'+ data.size[1] +')</span></h2>');
            $content.append('<div class="banner-img"><img width="' + data.size[0] + 'px" height="' + data.size[1] + 'px" src="' + data.img + '" /></div>');
            
            $popupInner.append($content)
        }
        
        function InsertPopupAdd()
        {
            var
                $content = $(document.createElement('div')),
                $tplBannerForm = $('.form-pattern div.form-group', $banners).clone();
            
            $content.append('<h2>Добавление баннера</h2>');
            $content.append($tplBannerForm);
            
            $popupInner.append($content)
        }
        
        // Клик на "Загрузите изображение":
        $popupInner.on('click', '.btn.select-image', function(){
            $inputImage.click();
            return false;
        });

        // Выбор изображения:
        $inputImage.on('change', function() {
            
            var file = $(this)[0].files[0];
            if (!file) {
                return false;
            }
            
            var
                $imageWrap = $('.image-wrap', $popupInner),
                $imageBanner = $('img', $imageWrap),
                $controlsPopup = $('.controls', $popupInner),
                $bannerSize = $('.form-control.banner-size', $popupInner);
            
            if (file.type.match('image.*')) {
                var fileReader = new FileReader();
                fileReader.onload = function(f) {
                    CheckBannerSize(
                        function(imgPath, imgSize, imgTitle){
                            $popupMessage.hide();
                            var d = new Date();
                            $imageBanner.attr('src', imgPath + '?' + d.getTime());
                            $imageBanner.attr('width', imgSize[0] + 'px');
                            $imageBanner.attr('height', imgSize[1] + 'px');
                            $imageBanner.attr('title', imgTitle);
                            $bannerSize.val(imgSize[0]+'x'+imgSize[1]);
                            $imageWrap.show();
                            $controlsPopup.show();
                        },
                        function(dataMsg){
                            ShowPopupMessage('error', dataMsg);
                            $imageWrap.hide();
                            $controlsPopup.hide();
                        }
                    );
                };
                fileReader.readAsDataURL(file);
            } else {
                $.showMessage('error', 'Выбранный файл не является изображением!');
            }
            
        });
        
        // Клик на "Сохранить" внутри попапа:
        $popupInner.on('click', '.btn.submit-action', function(){
            ApplyBannerLoad(
                function(bannerId, bannerSize, bannerImg){
                    AdTableRow(bannerId, bannerSize, bannerImg);
                    ClosePopup();
                },
                function(dataMsg){
                    $.showMessage('error', dataMsg);
                }
            );
            return false;
        });
        
        // Клик на "Отмена" внутри попапа:
        $popupInner.on('click', '.btn.cancel-action', function(){
            CancelBannerLoad(
                function(){
                    ClosePopup();
                },
                function(dataMsg){
                    $.showMessage('error', dataMsg);
                }
            );
            return false;
        });
        
        // Запрос для проверки размера изображения при его загрузке:
        function CheckBannerSize(callback, callbackError)
        {
            var
                $form = $('form#img-size-form'),
                action = $form.attr('action'),
                method = $form.attr('method'),
                formData = new FormData();

            // Данные картинки:
            if ($inputImage.length>0) {
                formData.append('img', $inputImage.prop('files')[0]);
            }

            formData.append('size', $('.form-control.banner-size', $popupInner).val().split('x'));
            
            if ($('.image-wrap img', $popupInner).attr('title')) {
                formData.append('current_img', $('.image-wrap img', $popupInner).attr('title'));
            } else {
            }
            
            
            //console.log('AAA CheckBannerSize = ', formData);
            //return false;
            
            $.ajax(action, {
                type: method,
                data: formData,
                cache:false,
                contentType: false,
                processData: false,
                success: function(data) {
                    if(data) {
                        if(data.result === true && data.img_path && data.img_size) {
                            if (callback && $.isFunction(callback)) {
                                callback(data.img_path, data.img_size, data.img_title);
                            }
                        }
                        if(data.result === false && data.msg) {
                            if (callbackError && $.isFunction(callbackError)) {
                                callbackError(data.msg);
                            }
                        }
                    }
                },
                error: function(rew, status, err) {
                    console.log(status, err);
                    if (callbackError && $.isFunction(callbackError)) {
                        callbackError('Ошибка: ' + rew.responseText);
                    }
                }
            });

            return false;
        }
        
        // Запрос для подтверждения загрузки баннера:
        function ApplyBannerLoad(callback, callbackError)
        {
            var
                $form = $('form#img-size-form'),
                action = $form.attr('action'),
                method = $form.attr('method'),
                $img = $('.image-wrap img', $popupInner),
                data = {
                    type: 'apply_load',
                    img: $img.attr('title'),
                    width: parseInt($img.attr('width')),
                    height: parseInt($img.attr('height'))
                };
        
            $.ajax(action, {
                type: method,
                data: data,
                success: function(data) {
                    if(data) {
                        if(data.result === true) {
                            if (callback && $.isFunction(callback)) {
                                callback(data.id, data.size, data.img);
                            }
                        }
                        if(data.result === false && data.msg) {
                            $.showMessage('error', data.msg);
                            if (callbackError && $.isFunction(callbackError)) {
                                callbackError(data.msg);
                            }
                        }
                    } 
                },
                error: function(rew, status, err) {
                    console.log(status, err);
                    if (callbackError && $.isFunction(callbackError)) {
                        callbackError(data.msg);
                    }
                }
            });
            
        }
        
        // Запрос для отмены загрузки баннера:
        function CancelBannerLoad(callback, callbackError)
        {
            var
                $form = $('form#img-size-form'),
                action = $form.attr('action'),
                method = $form.attr('method'),
                data = {
                    type: 'cancel_load',
                    img: $('.image-wrap img', $popupInner).attr('title')
                };
            
            $.ajax(action, {
                type: method,
                data: data,
                success: function(data) {
                    if(data) {
                        if(data.result === true) {
                            if (callback && $.isFunction(callback)) {
                                callback();
                            }
                        }
                        if(data.result === false && data.msg) {
                            $.showMessage('error', data.msg);
                            if (callbackError && $.isFunction(callbackError)) {
                                callbackError(data.msg);
                            }
                        }
                    } 
                },
                error: function(rew, status, err) {
                    console.log(status, err);
                    if (callbackError && $.isFunction(callbackError)) {
                        callbackError(data.msg);
                    }
                }
            });
            
        }
        
        // Добавление строки в таблицу для баннера:
        function AdTableRow(bannerId, bannerSize, bannerImg)
        {
            var statFieldsCount = $('thead th.stat', $tableBanners).length;
            
            var $tableRow = '' +
            '<tr class="banner-item" data-id="' + bannerId + '">' +
                '<td class="check"><input type="checkbox" checked></td>' +
                '<td><span class="banner-size">' + bannerSize.join('x') + '</span></td>' +
                '<td><span class="banner-preview" src="' + bannerImg + '" style="background-image: url(' + bannerImg + ')"></span></td>'
            ;
            
            for (var i=0; i<statFieldsCount; i++) {
                $tableRow += '<td class="stat">0</td>';
            }
    
            $tableRow += '' +
            '</tr>';
    
            $('tbody', $tableBanners).append($tableRow);
            /*
            if ($('tbody tr.total', $tableBanners).length > 0) {
                $('tbody tr.total', $tableBanners).before($tableRow);
            } else {
                $('tbody', $tableBanners).append($tableRow);
            }
            */
        }
        
        // Инфо сообщение внутри попапа:
        function ShowPopupMessage(type, msg)
        {
            $popupMessage.text(msg);
            $popupMessage.fadeIn(500);
        }
        
    })();
    
    // Фокус на название и раскрытие блоков, установка времени старта при создании новой кампании:
    if (isCreatePage) {
        datepicker1.selectDate(new Date());
    }
    AddListenerChangeContriols();
    
    // Форма создания-редактирование кампании Клик на "Сохранить":
    $btnSubmitAction.on('click', function(e) {
        
        if ($(this).attr('disabled') == 'disabled') return false;
        
        isChanged = false;
        
        e.stopPropagation();
        
        var
            action = $form.attr('action'),
            method = $form.attr('method'),
            data = {},
            warningInfo = null;
        
        // Основные данные для страниц создания и редактирования:
        data['active'] = ($('input#campaign-active', $form).is(':checked')) ? 1 : 0;
        data['date_begin'] = CheckNullValueInput($('input#campaign-date-begin', $form).val());
        data['date_end'] = CheckNullValueInput($('input#campaign-date-end', $form).val());
        data['price'] = CheckFloatValueInput($('input#campaign-price', $form).val());
        var groupPrice = CheckFloatValueInput($('input#campaign-price', $form).attr('group-value'));
        
        if ($checkTrackingAction.prop("checked")) {
            data['tracking_action'] = 1;
            data['order_sum'] = CheckFloatValueInput($('input#campaign-order-sum', $form).val());
        } else {
            data['order_sum'] = null;
            data['tracking_action'] = 0;
        }
        
        // Основные данные для стр. создания:
        if (isCreatePage) {
            
            data['title'] = CheckNullValueInput($('input.campaign-title', $form).val());
            
            if (data['date_end']) {
                var
                    now = new Date(),
                    nowDate = new Date(now.getFullYear(), now.getMonth(), now.getDate()),
                    endDate = new Date(data['date_end']);
                    
                if (nowDate > endDate) {
                    warningInfo = 'Нельзя создать кампанию, которая полностью в прошлом';
                }
            }
            
            data['url'] = CheckNullValueInput($('input#campaign-url', $form).val());
            
            var
                totalValue = CheckFloatValueInput($('input#campaign-money-limit-total', $form).val()),
                dataMoneyLimit = {
                    total: totalValue,
                    day: 0,
                    week: 0,
                    month: 0,
                };
            data['money_limit'] = JSON.stringify(dataMoneyLimit);
            if (!totalValue) {warningInfo = 'Введите бюджет кампании';}
        }
        
        // Расширенные данные для стр. редактирования:
        if (!isCreatePage) {
            
            data['title'] = CheckNullValueInput($('.panel-heading input.campaign-title').val());
            data['url'] = CheckNullValueInput($('input#campaign-url', $form).attr('value'));
            data['max_speed'] = $('input[name=max_speed]:checked', $form).val();
            
            var
                visitorLimit = {},
                isVisitorLimitSet = false;
            $('.form-group.campaign-visitor-limit__wrap .value-edit .campaign-visitor-limit').each(function(){
                var
                    $this = $(this),
                    dataLimit = {};

                $('input', $this).each(function(){
                    var $input = $(this);
                    if (parseInt($input.attr('value'))) {
                        isVisitorLimitSet = true;
                        dataLimit[$input.attr('name')] = parseInt($input.attr('value'));
                    } else {
                        dataLimit[$input.attr('name')] = 0;
                    }
                    
                });
                visitorLimit[$this.data('name')] = dataLimit;
            });
            if (isVisitorLimitSet) {
                data['visitor_limit'] = JSON.stringify(visitorLimit);
            } else {
                data['visitor_limit'] = null;
            }
            
            var
                moneyLimit = {},
                isMoneyLimitSet = false;
            $('.form-group.campaign-money-limit .value-edit input').each(function(){
                var $this = $(this);
                
                if (parseFloat($this.attr('value'))) {
                    isMoneyLimitSet = true;
                    moneyLimit[$this.attr('name')] = CheckFloatValueInput($this.attr('value'));
                } else {
                    moneyLimit[$this.attr('name')] = 0;
                }
            });
            data['money_limit'] = JSON.stringify(moneyLimit);
            if (isMoneyLimitSet) {
                data['money_limit'] = JSON.stringify(moneyLimit);
            } else {
                data['money_limit'] = null;
            }
            
            
            data['targeting'] = $('.form-group.geo', $form).attr('data-value');

            var trackingPixelsData = $('.form-group.tracking_pixels', $form).attr('data-value');
            if (trackingPixelsData) {
                data['tracking_pixels'] = $('.form-group.tracking_pixels', $form).attr('data-value');
            }
            
            var
                $tableBanners = $('.form-group.banners table.campaign-banners'),
                $bannersItems = $('tbody tr', $tableBanners);

            if ($bannersItems.length>0) {
                var dataBanners = {};
                $bannersItems.each(function(){
                    var $this = $(this);
                    dataBanners[$this.data('id')] = $('td.check input', $this).is(':checked') ? 1 : 0;
                });
                data['banners'] = dataBanners;
            }
            
        }
        
        // Обработка сообщений валидации:
        if (!data['price'] && !groupPrice) {warningInfo = 'Введите стоимость кампании';}
        if (!data['url'] || data['url'] == '') {warningInfo = 'Введите url кампании';}
        if (!data['title'] || data['title'] == '') {warningInfo = 'Введите название кампании';}
        
        if (warningInfo) {
            alert(warningInfo);
            return false;
        }
        
        //console.log('AAA ', data);
        //return false;
        
        $.ajax(action, {
            type: method,
            data: data,
            success: function(data) {
                if(data) {
                    if(data.result === true && data.redirect) {
                        document.location.href = data.redirect;
                    }
                    if(data.result === false && data.msg) {
                        $.showMessage('error', data.msg);
                    }
                } 
            },
            error: function(rew, status, err) {
                console.log(status, err);                    
            }
        });

        return false;
    });
    
    // Клик на "Отменить изменения"
    $btnCancelAction.on('click', function(e) {
        
        if ($(this).attr('disabled') == 'disabled') return false;
        
        var isChangedCurrent = isChanged;
        
        if (confirm((isCreatePage) ? 'Отменить создание кампании?' : 'Отменить изменения в кампании?')) {
            isChanged = false;
            if (isCreatePage) {
                document.location.href = $('.group-title').attr('href');
            } else {
                location.reload();
            }
        } else {
            isChanged = isChangedCurrent;
        }
        return false;
    });
    
    // Клик на "Отправить в архив"
    $btnArchive.on('click', function(e) {
        
        var
            $this = $(this),
            $campaignActiveCheck = $('input#campaign-active', $form),
            data = {
                'set_archive': 1,
                'value': ($this.hasClass('send')) ? 1 : 0
            };
        
        $this.attr('disabled', true);
        
        $.ajax($this.attr('href'), {
            type: 'POST',
            data: data,
            success: function(data) {
                $this.attr('disabled', false);
                if (data.result) {
                    if (data.val) {
                        $.showMessage('info', data.msg);
                        $campaignActiveCheck.prop('checked', false);
                        $btnArchiveSend.addClass('hidden');
                        $btnArchiveRemove.removeClass('hidden');
                    } else {
                        $.showMessage('info', data.msg);
                        $campaignActiveCheck.prop('disabled', false);
                        $btnArchiveSend.removeClass('hidden');
                        $btnArchiveRemove.addClass('hidden');
                    }
                }
            },
            error: function(rew, status, err) {
                console.log(status, err);
                $this.prop("disabled", false);
            }
        });
        
        return false;
    });
    
});

