<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Model\FAQ;


use App\Model\Common;
use App\Entity\FAQ\Item as ItemEntity;
use App\Model\HideableInterface;
use Monolog\Logger;
use Netcarver\Textile\Parser;
use Zend\Db\TableGateway\TableGateway;
use Zend\Hydrator\DelegatingHydrator;

/**
 * Class Item
 * @package App\Model\FAQ
 */
class Items extends Common implements HideableInterface
{

    /**
     * @var Parser
     */
    protected $parser;

    /**
     * Items constructor.
     * @param TableGateway $tableGateway
     * @param DelegatingHydrator $delegatingHydrator
     * @param Logger $logger
     * @param Parser $parser
     */
    public function __construct(TableGateway $tableGateway, DelegatingHydrator $delegatingHydrator, Logger $logger, Parser $parser)
    {
        parent::__construct($tableGateway, $delegatingHydrator, $logger);

        $this->parser = $parser;
    }


    /**
     * @param $items \Traversable
     * @return array
     */
    public function makeGrouped($items)
    {
        $itemsGrouped = [];

        /**
         *  enumerate items for list
         */
        $i = 0;
        /** @var ItemEntity $item */
        foreach ($items as $item) {
            $this->parseContent($item);
            $itemsGrouped[$item->getFaqCategoriesId()][++$i] = $item;
        }
        return $itemsGrouped;
    }

    /**
     * @param ItemEntity $item
     */
    public function parseContent(ItemEntity $item)
    {
        $item->setContent($this->parser->parse(_t($item->getContent())));
    }
}