<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Model;

use App\Entity\Code;

/**
 * Class Codes
 * @package App\Model
 */
class Codes extends Common
{

    /**
     * @param $id
     * @return Code[]
     */
    public function findBySiteId($id)
    {
        /** @noinspection PhpIncompatibleReturnTypeInspection */
        return $this->findAll(['site_id' => $id]);
    }
    
    
    public function deleteBySiteId($site_id)
    {
        $code_items = $this->findAll(['site_id' => $site_id]);
        if ($code_items)
        {
            foreach ($code_items as $code_item)
            {
                $result = $this->deleteById($code_item->getId());
            }
        }
        return $result;
    }
    
    /**
     * @param \App\Entity\Common $entity
     * @return int
     * @throws \Exception
     */
    public function create($entity)
    {
        
        $data = $this->delegatingHydrator->extract($entity);
        
        // accept data columns only available at table
        $data = array_intersect_key($data, array_fill_keys($this->tableGateway->getColumns(), 1));

        $query = function($data) {
            $this->tableGateway->insert($data);
            $insertId = $this->tableGateway->lastInsertValue;
            return $insertId;
        };

        try {
            $this->tableGateway->getAdapter()->getDriver()->getConnection()->beginTransaction();
            $id = $query($data);
            $this->tableGateway->getAdapter()->getDriver()->getConnection()->commit();
        } catch (\Exception $e) {
            $this->tableGateway->getAdapter()->getDriver()->getConnection()->rollback();
            throw $e;
        }
        return $id;
    }

    public function clearTable()
    {
        $adapter = $this->tableGateway->getAdapter();
        $sql = 'TRUNCATE TABLE codes';
        $res = $adapter->query($sql, \Zend\Db\Adapter\Adapter::QUERY_MODE_EXECUTE);
        
        return $res;
    }
    
}