/*
    Render body
*/
console.log('AAA Render body');

const SiteAPI = {
    sites: [
        { id: 1, domain: "Sinoptik", info: "info-text" },
        { id: 2, domain: "Ukrnet", info: "info-text" },
        { id: 3, domain: "Alpha", info: "info-text" },
        { id: 4, domain: "Bravo", info: "info-text" },
        { id: 5, domain: "Charlie", info: "info-text" },
        { id: 6, domain: "Dendy", info: "info-text" }
    ],
    all: function() { return this.sites},
    get: function(id) {
        const isSite = site => site.id === id;
        return this.sites.find(isSite)
    }
}


const ListSites = () => (
    <div>
        <ul>
            {
            SiteAPI.all().map(site => (
                <li key={site.id}>
                    <Link to={`/sites/${site.id}`}>{site.domain}</Link>
                </li>
            ))
            }
        </ul>
    </div>
)


const SiteItem = (props) => {
    const site = SiteAPI.get(
        parseInt(props.match.params.id, 10)
    )
    if (!site) {
      return <div>Sorry, but the site was not found</div>
    }
    return (
      <div>
        <h1>{site.domain} (#{site.id})</h1>
        <h2>Info: {site.info}</h2>
        <Link to='/sites'>Back</Link>
      </div>
    )
}

const Sites = () => (
    <div>
        <h2>This is a site page!</h2>
        <Switch>
            <Route exact path='/sites' component={ListSites}/>
            <Route path='/sites/:id' component={SiteItem}/>
        </Switch>
    </div>    
)

const Home = () => (
    <div>
        <h1>Welcome to Home!</h1>
        <h1>С кем мы работаем</h1>
        <div class="row row-wrap">
            <div class="b-content__work-item col sm-4 xs-12">
                <h2>Рекламные сети</h2>
                <p class="lead">Увеличьте охват сети на 25-30%, показывая рекламу тем, кто сейчас ее блокирует.</p>
                <p class="text">Эта аудитория демонстрирует высокие показатели конверсии, так как большую часть рекламы в сети она не видит. Дайте возможность Вашим партнерам повысить монетизацию сайтов за счет дополнительного рекламного трафика.</p>
            </div>
            <div class="b-content__work-item col sm-4 xs-12">
                <h2>Системы управления рекламой</h2>
                <p class="lead">Позвольте вашим клиентам монетизировать больше рекламного инвентяря.</p>
                <p class="text">Потеря трети аудитории является большой проблемой для сайтов. Иммунитет к блокировщикам — неплохое конкурентное преимущество для системы управляения рекламой!</p>
            </div>
            <div class="b-content__work-item col sm-4 xs-12">
                <h2>Крупные сайты</h2>
                <p class="lead">Индивидуальные решения для конкретного сайта позволяют лучше справиться с нестандартными форматами.</p>
                <p class="text">Брендирование подложки, видеореклама в собственном плеере сайта или другие нестандартные форматы тоже можно сделать не восприимчивыми к блокировщикам. Если эти форматы приносят вам больше 5000$ в месяц, то смысл в индивидуальной работе против блокировщиков есть.</p>
            </div>
        </div>
    </div>
)


const My404Component = () => (
    <div>
        <h1>Welcome to 404!</h1>
        <h1>Page not found</h1>
    </div>
)


const SiteForm = () => (
<div className="site">
    <h2>Технические данные</h2>
    <Provider store={store}>
        <div>
            <ConnectedSiteForm />
        </div>
    </Provider>
</div>
)


const fakeAuth = {
    isAuthenticated: false,
    authenticate(cb) {
        this.isAuthenticated = true;
        setTimeout(cb, 1000);
    },
    signout(cb) {
        this.isAuthenticated = false;
        setTimeout(cb, 1000);
    }
};


const PrivateRoute = ({component: Component, ...rest }) => (
    <Route
        {...rest}
        render={props =>
          fakeAuth.isAuthenticated ? (
            <Component {...props} />
          ) : (
            <Redirect
              to={{
                pathname: "/login",
                state: { from: props.location }
              }}
            />
          )
        }
    />
);


class Login extends React.Component {
    state = {
        redirectToReferrer: false
    };
    login = () => {
        fakeAuth.authenticate(() => {
            this.setState({ redirectToReferrer: true });
        });
    };
    rendLoginRedirectLink = (page) => {
        return (
            <div>
                <p>You must log in to view the page at {page}</p>
                <button onClick={this.login}>Log in</button>
            </div>
        );
    };
    rendLogin = () => {
        return (
            <div>
                <button onClick={this.login}>Log in</button>
            </div>
        );
    };
    render() {
        const { from } = this.props.location.state || { from: { pathname: "/" } };
        const { redirectToReferrer } = this.state;

        if (redirectToReferrer) {
            return <Redirect to={from} />;
        }

        if (this.props.location.state) {
            return this.rendLoginRedirectLink(from.pathname);
        } else {
            return this.rendLogin();
        }
        
    }
}




const Main = () => (
    <main class="l-content">
        <section class="b-content__counter">
            <div class="row row-wrap wrapp">
                <div class="b-content__counter-title">
                    <h1>Повышайте количество показов рекламы</h1>
                    <p class="lead">Обходите блокировщики рекламы с помощью простой веб технологии</p>
                </div>
            </div>
        </section>
        <section class="b-content__work">
            <div class="wrapp">
                <Switch>
                    <Route exact path='/' component={Home}/>
                    <PrivateRoute path='/sites' component={Sites}/>
                    <PrivateRoute path='/site-form' component={SiteForm}/>
                    <Route path="/login" component={Login} />
                    
                    <Route path='/404' component={My404Component} />
                    <Redirect from='*' to='/404' />
                </Switch>
            </div>
        </section>
    </main>
)

const AuthButton = withRouter(
    ({ history }) =>
        fakeAuth.isAuthenticated ? (
            <a href="#" onClick={() => {fakeAuth.signout(() => history.push("/"));}} title="Выход" class="text bold login-button button-open">Выход</a>                                
        ) : (
            <Link to='/login'><a href="#" title="Вход" class="text bold login-button button-open">Вход</a></Link>
        )
);

const Header = () => (
    <header className="l-header">
        <nav className="wrapp row xs-no-row row-center">
            <a href="/" title="Main" className="header-logo col sm-2 xs-1"></a>
            <ul class="header-nav col order-xs-3 sm-6 xs-5">
                <li><Link to='/'>Home</Link></li>
                <li><Link to='/sites'>Sites</Link></li>
                <li><Link to='/site-form'>SiteForm</Link></li>
                <li><Link to='/login'>Login</Link></li>
            </ul>
            <p className="header-register col sm-3 order-xs-4 xs-2">
                <AuthButton />
            </p>
        </nav>
    </header>
)

const Footer = () => (
    <footer class="l-footer">
        <div class="wrapp">
            <div class="b-footer__column row row-wrap">
                <div class="b-footer__column-note col order-xs-5 sm-2 xs-12">
                </div>

                <div class="b-footer__column-item col order-xs-2 sm-2 xs-6">
                </div>
                <div class="b-footer__column-item col order-xs-3 sm-2 xs-6">

                </div>
                <div class="b-footer__column-item col order-xs-4 sm-2 xs-6">
                </div>

                <div class="b-footer__column-item col order-xs-5 sm-2 xs-6">
                </div>
            </div>
        </div>
    </footer>

)

const App = () => (
    <div className="body-inner">
        <Header />
        <Main />
        <Footer />
    </div>
)


ReactDOM.render((
    <BrowserRouter basename={rootPath}>
        <App />
    </BrowserRouter>
),document.getElementsByTagName('body')[0])