$(document).ready(function () {
    "use strict";
    
    String.prototype.replaceAll = function(search, replacement) {
        var target = this;
        if (replacement != '') {
            while(target.indexOf(search)+1>0) {
                target = target.replace(search, replacement);
            }
        }
        return target;
    };
    
    // Обработка выбора картинки:
    (function(){
    
        // Клик на картинку:
        $('.adds-column .img-wrap').on('click', function(){
           $('input', $(this).parent()).click();
        });

        // Выбор картинки:
        $('.form-control#img').on('change', function() {
            var file = $(this)[0].files[0];
            if (!file) {
                return false;
            }
            if (file.type.match('image.*')) {
                var fileReader = new FileReader();
                fileReader.onload = function(f) {
                    /*
                    $('.img-wrap img ').attr('src', f.target.result);
                    $('.img-wrap img ').show();
                    CreatePreview();
                    */
                    RequestImageResize(function(imgPath){
                        console.log('AAA ', imgPath);
                        var d = new Date();
                        $('.img-wrap img ').attr('src', imgPath + '?' + d.getTime());
                        $('.img-wrap img ').show();
                        CreatePreview();
                    });
                };
                fileReader.readAsDataURL(file);
            } else {
                console.log('ошибка, не изображение');
            }
       });
        
    })();
    
    // Запрос для ресайза картинки при её загрузке:
    function RequestImageResize(callback)
    {
        var
            $form = $('#img-resize-form'),
            action = $form.attr('action'),
            method = $form.attr('method'),
            formData = new FormData();
       
        // Данные картинки:
        var $inputImage = $("input#img");
        if ($inputImage.length>0) {
            formData.append('img', $inputImage.prop('files')[0]);
        }
        
        formData.append('offer_id', $('input.form-control#offer_id').val());
        //console.log('AAA RequestImageResize = ', formData);
        
        $.ajax(action, {
            type: method,
            data: formData,
            cache:false,
            contentType: false,
            processData: false,
            success: function(data) {
                if(data) {
                    if(data.result === true && data.img_path) {
                        if (callback && $.isFunction(callback)) {
                            callback(data.img_path);
                        }
                    }
                } 
            },
            error: function(rew, status, err) {
                console.log(status, err);                    
            }
        });
        
        return false;
    }
    
    // Переменные шаблонов
    (function(){
        
        var templatesVariables = [];
        
        CheckTemplatesVariables();
        MarkAllInputTplFields();
        
        // Изменения в полях формы и таблицы:
        $('input.form-control').not('#img').on('change', function(){
            CheckTemplatesVariables();
            SendDraftDataRequest();
        });
        
        // Ввод в поля проверяемые на валидность:
        $('input.form-control.tpl').on('keyup', function(){
            MarkInputTplField($(this));
        });
        
        // Ввод в поля таблицы:
        $('table.add-templates').on('keyup', 'input.form-control',  function(){
            MarkAllInputTplFields();
        });
        
        // Изменение полей таблицы:
        $('table.add-templates').on('change', 'input.form-control', function(){
            CreatePreview();
        });

        function CheckTemplatesVariables()
        {
            templatesVariables = [];
            $('input.form-control').each(function(){
                ChangeInputValue($(this).val());
            });
            TableVariablesEdit(templatesVariables);
            CreatePreview();
        }

        function MarkAllInputTplFields()
        {
            $('input.form-control.tpl').each(function(){
                MarkInputTplField($(this));
            });
        }

        function MarkInputTplField($input)
        {
            
            var
                val = $input.val(),
                re = /\$\[\w+\]/g,
                found = val.match(re),
                inputText,
                invalidClass = 'not-valid';
                
            $input.removeClass(invalidClass);
        
            if (found) {

                if ($.inArray($input.attr('id'), ['title','desc','price'])>=0) {
                    
                    var
                        $table = $('table.add-templates'),
                        $tableHeaders = $('thead th:not(.del)', $table),
                        $tableBodyRows = $('tbody tr', $table);

                    inputText = val; // Оригинальный шаблон

                    found.forEach(function(item, i){
                        found[i]=item.replace('$[', '').replace(']', '');
                    });
                    
                    $tableBodyRows.each(function(){
                        
                        var
                            textVar = inputText,
                            $row = $(this),
                            $inputVars = [];
                        
                        found.forEach(function(item){

                            var
                                varIndex,   // индекс переменной шаблона
                                $inputVar,  // input переменной
                                valueVar;   // значение переменной
                            
                            $tableHeaders.each(function(){
                               var $this = $(this);
                               if ($this.text() == item) {
                                   varIndex = $tableHeaders.index($this);
                               } 
                            });
                            
                            $inputVar = $('input', $('td', $row).eq(varIndex)), // input переменной
                            valueVar = $.trim($inputVar.val()); // значение переменной
                            $inputVars.push($inputVar);
                            
                            textVar = textVar.replace('$[' + item + ']', valueVar);
                        });    
                        
                        
                        // Подсвечиваем невалидные шаблоны и их переменные
                        $.each($inputVars, function(i, $item){
                            $item.removeClass(invalidClass);
                        });
                        
                        
                        var maxValueLength = ($input.attr('id') == 'price') ? 8 : 48;
                        if (textVar.length>maxValueLength) {
                            $input.addClass(invalidClass);
                            $.each($inputVars, function(i, $item){
                                $item.addClass(invalidClass);
                            });
                        }
                    });

                }
                
            } else {
                if ($.inArray($input.attr('id'), ['title','desc','price'])>=0) {
                    var maxValueLength = ($input.attr('id') == 'price') ? 8 : 50;
                    if (val.length>maxValueLength) {
                        $input.addClass(invalidClass);
                    }
                }
            }

        }

        function ChangeInputValue(val)
        {
            var
                re = /\$\[\w+\]/g,
                found = val.match(re);
        
            if (found) {
                found.forEach(function(item, i){
                    found[i]=item.replace('$[', '').replace(']', ''); 
                });
                AddToInputVariables(found);
            }
        }
        
        function AddToInputVariables(values)
        {
            values.forEach(function(value){
                if (templatesVariables.indexOf(value)<0) {
                    templatesVariables.push(value);
                }
            })
        }

        function TableVariablesEdit(variables)
        {
            var
                $tableWrap = $('.form-group.templates'),
                $table = $('table.add-templates'),
                $tableHeader = $('thead', $table),
                $tableHeadersAll = $('thead th', $table),
                $tableHeaders = $('thead th:not(.templ-id):not(.del)', $table),
                $tableHeaderRow = $('thead tr', $table),
                $tableBodyRow = $('tbody tr', $table),
                $tableBodyCells = $('tbody td:not(.templ-id):not(.del)', $table);

            if (!variables.length) {
                $tableWrap.hide();
                // Удаление оставшейся колонок, т.к. переменных нет:
                $tableHeaders.remove();
                $tableBodyCells.remove();
                $('tbody td.templ-id input', $table).val('');
            } else {
                $tableWrap.show();
                
                // Удаление колонки, если её нет в данных:
                $tableHeaders.each(function(){
                    if (variables.indexOf($(this).text())<0) {
                        // Колонку id не удаляем:
                        if ($(this).text() == 'id') {
                            /*
                            $tableBodyRow.each(function(){
                                $('input', $('td:first', $(this))).val('');
                            });
                            */
                        } else {
                            var indexColumn = $tableHeadersAll.index($(this));
                            $tableHeadersAll.eq(indexColumn).remove();
                            $tableBodyRow.each(function(){
                                $('td', $(this)).eq(indexColumn).remove();
                            });
                        }
                    }
                });
                
                // Добавление колонки, если её нет в таблице:
                
                variables.forEach(function(variable){

                    var newVariable = true;
                    $tableHeaders.each(function(){
                        if ($(this).text() == variable) {
                            newVariable = false;
                        }
                    });
                    if (newVariable) {
                        if (variable != 'id') {
                            $('th.del', $tableHeader).before('<th>' + variable + '</th>');
                            $tableBodyRow.each(function(){
                                $('td.del', $(this)).before('<td><input type="text" class="form-control template-value" value=""</td>');
                            });
                        }
                    }
                });            
            }
            
        }

        // Удаление строки в таблице шаблонов (не последней):
        $('table.add-templates').on('click', 'b.del', function(){
            if ($('table.add-templates tbody tr').length>1) {
                $(this).parents('tr').remove();
            }
        });
        
        // Добавление строки в таблице шаблонов:
        $('.form-group.templates .add-row').on('click', function(){
            var
                varCount = $('table.add-templates thead th').length - 1,
                $tr = $(document.createElement('tr'));
                
            for (var i = 0; i < varCount; i++) {
                $tr.append('<td><input type="text" class="form-control template-value" value=""></td>');
            }
            $tr.append('<td class="del"><b class="del">&times;</b></td>');
            $('table.add-templates').append($tr);
        });
        
    })();
    
    // Превью объявлений:
    function CreatePreview()
    {
        var
            $table = $('table.add-templates'),
            $tableHeaders = $('thead th:not(.del)', $table),
            $tableBodyRows = $('tbody tr', $table),
            $tableBodyRow = $('tbody tr:first', $table),
            dataVars = {},
            dataTemplates = [],
            dataTemplate = {};

        $tableBodyRows.each(function(){
            
            $tableBodyRow = $(this);

            // Формируем список переменных для шаблонов:
            $tableHeaders.each(function(){
                dataVars[$(this).text()] = $.trim($('input', $('td', $tableBodyRow).eq($tableHeaders.index($(this)))).val());
            });
        
            dataTemplate = {
                title: $('.form-control#title').val(),
                text: $('.form-control#desc').val(),
                link: $('.form-control#link').val(),
                price: $('.form-control#price').val(),
                img: $('.img-wrap img').attr('src'),
            };

            $.each(dataTemplate, function(index, item){
                var templateValue = item;
                if (templateValue) {
                    $.each(dataVars, function(name, value){
                        templateValue = templateValue.replaceAll('$['+ name +']', value);
                    });
                }
                dataTemplate[index] = templateValue;
            });
        
            dataTemplates.push(dataTemplate);
        });
        //console.log('AAA dataTemplates = ', dataTemplates);
        
        // Формируем данные для шаблонов тизерок:
        var
            adsTemplates = [],
            templCount = dataTemplates.length;
    
        for (var i = 0; i < 4; i++) {
            adsTemplates.push(dataTemplates[i % templCount]);
        }
        //console.log('AAA adsTemplates = ', adsTemplates);
        
        // Рендер шаблонов тизеров:
        var
            $teasersWrap = $('.form-group.preview .content'),
            $staticTeasers = $('.static', $teasersWrap),
            $lightTeasers = $('.light', $teasersWrap),
            $adaptiveTeasers = $('.adaptive', $teasersWrap);
            
        $('div', $teasersWrap).empty();
        $staticTeasers.append($.TeasersTemplates.static({ads: adsTemplates}));
        $lightTeasers.append($.TeasersTemplates.light({ads: adsTemplates}));
        $adaptiveTeasers.append($.TeasersTemplates.adaptive({ads: adsTemplates}));
    }
    
    var
        canSave = true,
        currentTimeout;
    
    function SendDraftDataRequest()
    {
        return false;
        var
            currentStateCanSave = canSave,
            timeOutValue = 5000;
        
        if (canSave) {
            SaveDataTemp();
        }
        
        clearTimeout(currentTimeout);
        canSave = false;
        currentTimeout = setTimeout(function(){
            canSave = true;
            if (!currentStateCanSave) {
                SaveDataTemp();
            }
        }, timeOutValue);
    }
    
    function SaveDataTemp()
    {        
        var
            $form = $('#add-create-form'),
            action = $form.attr('action'),
            method = $form.attr('method'),
            formData = new FormData();
        
        if(action.indexOf('create') + 1) {
            return false;
        }
        
        /*
        // Данные картинки:
        var $inputImage = $("input#img");
        if ($inputImage.length>0) {
            formData.append('img', $inputImage.prop('files')[0]);
        }
        */
       
        // Данные значений переменных из шаблонов:
        var
            dataTemplateValues = {},
            $table = $('table.add-templates'),
            $tableHeaders = $('thead th:not(.del)', $table),
            $tableBodyRow = $('tbody tr', $table),
            isNotEmptyTable = false;
        
        $tableBodyRow.each(function(){
            var
                valuesItem = {},
                $cellId = $('td:first', $(this)),
                $allCells = $('td', $(this)),
                $cells = $('td:not(:last):not(:first)', $(this)),
                id_name, val, ind,
                isNotEmptyCell = false;
            
            id_name = $.trim($('input', $cellId).val());
            
            $cells.each(function(){
                val = $.trim($('input', $(this)).val());
                ind = $allCells.index($(this));
                valuesItem[$tableHeaders.eq(ind).text()] = val;
                if (val != "") {
                    isNotEmptyCell = true;
                }
            });
            if (isNotEmptyCell) {
                dataTemplateValues[id_name] = valuesItem;
                isNotEmptyTable = true;
            }
        });
        
        if (isNotEmptyTable) {
            formData.append('template_values', JSON.stringify(dataTemplateValues));
        }
        
        var vals = $form.serializeArray();
        if(vals.length) {
            for(var i in vals) {
                if ($.trim(vals[i].value) != '') {
                    formData.append(vals[i].name, $.trim(vals[i].value));
                }
            }
        }
        
        // Черновик данных:
        formData.append('temp', true);
        
        $.ajax(action, {
            type: method,
            data: formData,
            cache:false,
            contentType: false,
            processData: false,
            success: function(data) {
                if(data) {
                    if(data.result === true && data.redirect) {
                        document.location.href = data.redirect;
                    }
                    if(data.result === false && data.msg) {
                        $.showMessage('error', data.msg);
                    }
                } 
            },
            error: function(rew, status, err) {
                console.log(status, err);                    
            }
        });
        
        return false;
    }
    
    // Клик на "Сохранить" для объявления:
    $('.btn.btn-primary.submit-action').on('click', function(){
        
        if ($('input.form-control.tpl').hasClass('not-valid')) {
            alert('Проверьте данные в полях ввода!');
            return false;
        }
        
        var
            $form = $('#add-create-form'),
            action = $form.attr('action'),
            method = $form.attr('method'),
            formData = new FormData();
       
        // Данные картинки:
        var $inputImage = $("input#img");
        if ($inputImage.length>0) {
            formData.append('img', $inputImage.prop('files')[0]);
        }
        
        // Данные значений переменных из шаблонов:
        var
            dataTemplateValues = {},
            $table = $('table.add-templates'),
            $tableHeaders = $('thead th:not(.del)', $table),
            $tableBodyRow = $('tbody tr', $table),
            isNotEmptyTable = false,
            validateInfo;
        
        $tableBodyRow.each(function(){
            var
                valuesItem = {},
                $cellId = $('td:first', $(this)),
                $allCells = $('td', $(this)),
                $cells = $('td:not(:last):not(:first)', $(this)),
                id_name, val, ind,
                isNotEmptyCell = false;
            
            id_name = $.trim($('input', $cellId).val());
            
            if (id_name != '') {

                $cells.each(function(){
                    val = $.trim($('input', $(this)).val());
                    ind = $allCells.index($(this));
                    valuesItem[$tableHeaders.eq(ind).text()] = val;
                    if (val != "") {
                        isNotEmptyCell = true;
                    } else {
                        validateInfo = 'Не установлено значение ' + $tableHeaders.eq(ind).text();
                    }
                });
                
                if (isNotEmptyCell) {
                    dataTemplateValues[id_name] = valuesItem;
                } else {
                    dataTemplateValues[id_name] = {};
                }
                
                isNotEmptyTable = true;
                
            } else {
                validateInfo = 'Не установлено значение id';
            }
            
        });
        
        if (validateInfo) {
            alert(validateInfo);
            return false;
        }
        
        //console.log('AAA dataTemplateValues = ', dataTemplateValues);
        //return false;
        
        if (isNotEmptyTable) {
            formData.append('template_values', JSON.stringify(dataTemplateValues));
        }
        
        var vals = $form.serializeArray();
        if(vals.length) {
            for(var i in vals) {
                if ($.trim(vals[i].value) != '') {
                    formData.append(vals[i].name, $.trim(vals[i].value));
                }
            }
        }
       
        //console.log('AAA dataTemplateValues = ', dataTemplateValues);
        //return false;
        
        $.ajax(action, {
            type: method,
            data: formData,
            cache:false,
            contentType: false,
            processData: false,
            success: function(data) {
                if(data) {
                    if(data.result === true && data.redirect) {
                        document.location.href = data.redirect;
                    }
                    if(data.result === false && data.msg) {
                        $.showMessage('error', data.msg);
                    }
                } 
            },
            error: function(rew, status, err) {
                console.log(status, err);                    
            }
        });
        
        return false;
    });        
    
});