<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Action\User;


use App\Action\Common;
use App\Authentication\UserService;
use App\Model\Users;
use App\Model\Statistics;
use App\Model\Providers;
use App\Model\Feeds\Feeds;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Zend\Diactoros\Response\HtmlResponse;
use Zend\Diactoros\Response\JsonResponse;
use Zend\Diactoros\Response\RedirectResponse;


/**
 * Class ViewId
 * @package App\Action\User
 */
class ViewId extends Common
{
    const ACTION_STAT = 'stat';
    const ACTION_STAT_ORDER = 'stat_order';
    const STAT_CATS = array(
        'StartTime' => 'StartTime',
        'EndTime' => 'EndTime',
        'IP' => 'IP',
        'Basket' => 'Состав корзины',
        'Pages' => 'Pages',
        'ForeignID' => 'ForeignID',
        'OrderSum' => 'OrderSum',
    );
    const STAT_CATS_ORDER = array(
        'Timestamp' => 'DateTime',
        'IP' => 'IP',
        'VisitorID' => 'UserID',
        'ViewID' => 'ViewID',
        'OrderIP' => 'OrderIP',
        'URL' => 'URL',
    );

    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param callable|null $next
     * @return HtmlResponse
     */
    function __invoke(ServerRequestInterface $request, ResponseInterface $response, callable $next = null)
    {  
        
        /** @var \App\Model\Statistics $stats */
        $stats = $this->container->get(Statistics::class);
        
        if($request->getMethod() == 'POST') {
            
            try {
                $data = [
                    'result' => false,
                ];
                $response = new JsonResponse($data);
            } catch(\Exception $e) {
                $data = [
                    'result' => false,
                    'msg' => $e->getMessage(),
                ];
                $response = new JsonResponse($data);
            }
            return $response;
        }
        elseif($request->getAttribute('action') == self::ACTION_STAT_ORDER) {
            
           try {
                
                $feed_id = $request->getAttribute('feedid');
                $order_id = $request->getAttribute('id');
                
                /** @var UserService $auth */
                $auth = $this->container->get(UserService::class);
                $userId = $auth->getIdentity()->getId();

                /** @var \App\Model\Feeds $feedsModel */
                $feedsModel = $this->container->get(Feeds::class);
                $feed_item = $feedsModel->findById($feed_id);
                
                if ($feed_item) {
                    
                    if ($feed_item->getClientid() == $userId){
                        
                        // Статистика-история по клику:
                        $orderIdStats = $stats->getOrderIdStatData($feed_id, $order_id);
                        $data['viewIdStats'] = $orderIdStats;
                        $data['cats'] = self::STAT_CATS_ORDER;
                        
                    } else {
                        $data['error'] = _t('Извините, данный фид закреплен за другим пользователем');
                    }
                    
                } else {
                    $data['error'] = _t('Извините, фид не найден');
                }
                
            } catch(\Exception $e) {
                $data['error'] = _t('Извините, история визитов по заказу временно не работает');
            }

            $data = array_merge($data, [
                'lang' => $request->getAttribute('layoutInfo')->getLang(),
                'layoutInfo' => $request->getAttribute('layoutInfo'),
            ]);     

            return new HtmlResponse($this->template->render('app::user/cabinet-feed-click-history', $data));
            
        } else {
            
            try {
                
                $feed_id = $request->getAttribute('feedid');
                $view_id = $request->getAttribute('id');
                
                /** @var UserService $auth */
                $auth = $this->container->get(UserService::class);
                $userId = $auth->getIdentity()->getId();

                /** @var \App\Model\Feeds $feedsModel */
                $feedsModel = $this->container->get(Feeds::class);
                $feed_item = $feedsModel->findById($feed_id);
                
                if ($feed_item) {
                    
                    if ($feed_item->getClientid() == $userId){
                        
                        // Статистика-история по клику:
                        $viewIdStats = $stats->getViewIdStatData($feed_id, $view_id);
                        $data['viewIdStats'] = $viewIdStats;
                        $data['cats'] = self::STAT_CATS;
                        
                    } else {
                        $data['error'] = _t('Извините, данный фид закреплен за другим пользователем');
                    }
                    
                } else {
                    $data['error'] = _t('Извините, фид не найден');
                }
                
            } catch(\Exception $e) {
                $data['error'] = _t('Извините, история визитов по клику временно не работает');
            }

            $data = array_merge($data, [
                'lang' => $request->getAttribute('layoutInfo')->getLang(),
                'layoutInfo' => $request->getAttribute('layoutInfo'),
            ]);     

            return new HtmlResponse($this->template->render('app::user/cabinet-feed-click-history', $data));
        }
    }
    
}