<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Entity\Statistic;


class Blockers
{

    const PROP_FIRST = 0;
    const PROP_SECOND = 1;
    const PROP_THIRD = 2;
    const PROP_FORTH = 3;

    /**
     * @var Data
     */
    protected $first;
    /**
     * @var Data
     */
    protected $second;
    /**
     * @var Data
     */
    protected $third;
    /**
     * @var Data
     */
    protected $forth;

    /**
     * @return Data
     */
    public function getFirst(): Data
    {
        return $this->first;
    }

    /**
     * @param Data $first
     * @return Blockers
     */
    public function setFirst(Data $first): Blockers
    {
        $this->first = $first;
        return $this;
    }

    /**
     * @return Data
     */
    public function getSecond(): Data
    {
        return $this->second;
    }

    /**
     * @param Data $second
     * @return Blockers
     */
    public function setSecond(Data $second): Blockers
    {
        $this->second = $second;
        return $this;
    }

    /**
     * @return Data
     */
    public function getThird(): Data
    {
        return $this->third;
    }

    /**
     * @param Data $third
     * @return Blockers
     */
    public function setThird(Data $third): Blockers
    {
        $this->third = $third;
        return $this;
    }

    /**
     * @return Data
     */
    public function getForth(): Data
    {
        return $this->forth;
    }

    /**
     * @param Data $forth
     * @return Blockers
     */
    public function setForth(Data $forth): Blockers
    {
        $this->forth = $forth;
        return $this;
    }


}