<?php
use Interop\Container\ContainerInterface;
use Slim\Flash\Messages;
use Zend\Expressive\Container\ApplicationFactory;
use Zend\Expressive\Helper;

return [
    'dependencies' => [
        'factories' => [
            Helper\ServerUrlMiddleware::class => Helper\ServerUrlMiddlewareFactory::class,
            Helper\UrlHelperMiddleware::class => Helper\UrlHelperMiddlewareFactory::class,
            App\Middleware\LayoutInfo::class => function (ContainerInterface $container) {
                return new App\Middleware\LayoutInfo(
                    $container->get('layout'),
                    $container->get(\App\Model\Locales::class),
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Permissions\Acl\AclInterface::class),
                    $container->get('config')['contacts'][\App\Entity\Contacts::PHONES_KEY],
                    $container->get('config')['contacts'][\App\Entity\Contacts::MAILS_KEY],
                    $container->get('config')['contacts'][\App\Entity\Contacts::SKYPES_KEY]
                    );
            },
            'translationsMiddleware' => function (ContainerInterface $container) {
                $translations = $container->get(\App\Model\Translations::class);
                return function (\Psr\Http\Message\ServerRequestInterface $request, $response, $next) use ($translations) {
                    $translations->register($request->getAttribute('layoutInfo')->getLang());
                    return $next($request, $response);
                };
            },
            'flash' => function (ContainerInterface $container) {

                return function (\Psr\Http\Message\ServerRequestInterface $request, $response, $next) {
                    // Start the session whenever we use this!
                    session_start();

                    return $next(
                        $request->withAttribute('flash', new Messages()),
                        $response
                    );
                };
            },
        ],
    ],
    // This can be used to seed pre- and/or post-routing middleware
    'middleware_pipeline' => [
        // An array of middleware to register. Each item is of the following
        // specification:
        //
        // [
        //  Required:
        //     'middleware' => 'Name or array of names of middleware services and/or callables',
        //  Optional:
        //     'path'     => '/path/to/match', // string; literal path prefix to match
        //                                     // middleware will not execute
        //                                     // if path does not match!
        //     'error'    => true, // boolean; true for error middleware
        //     'priority' => 1, // int; higher values == register early;
        //                      // lower/negative == register last;
        //                      // default is 1, if none is provided.
        // ],
        //
        // While the ApplicationFactory ignores the keys associated with
        // specifications, they can be used to allow merging related values
        // defined in multiple configuration files/locations. This file defines
        // some conventional keys for middleware to execute early, routing
        // middleware, and error middleware.
        'always' => [
            'middleware' => [
                // Add more middleware here that you want to execute on
                // every request:
                // - bootstrapping
                // - pre-conditions
                // - modifications to outgoing responses
                Helper\ServerUrlMiddleware::class,
                'flash',
            ],
            'priority' => 10000,
        ],
        'routing' => [
            'middleware' => [
                ApplicationFactory::ROUTING_MIDDLEWARE,
                Helper\UrlHelperMiddleware::class,
                // Add more middleware here that needs to introspect the routing
                // results; this might include:
                // - route-based authentication
                // - route-based validation
                // - etc.
                App\Middleware\LayoutInfo::class, // init required info for layout
                'translationsMiddleware',
                App\Middleware\Authentication::class,
                App\Middleware\Authorization::class,
                ApplicationFactory::DISPATCH_MIDDLEWARE,
            ],
            'priority' => 1,
        ],

        'error' => [
            'middleware' => [
                // Add error middleware here.
            ],
            'error'    => true,
            'priority' => -10000,
        ],
    ],
];
