$(document).ready(function () {
    "use strict";

    // Клик на редактируемый элемент:
    $('.panel-heading.offer-category').on('click', '.edited', function(){
        var
            $field = $(this),
            fieldName = $field.data('field'),
            $input = $('input.'+fieldName, $field.parent()),
            oldVal = $input.val(),
            oldText = $field.html();

        $field.hide();
        $input.off('blur').off('keyup').show().focus();

        $input.on('keyup', function(e) {

            if (e.keyCode == 13) {
                $input.blur();
            }

            if (e.keyCode == 27) {
                $input.off('blur');
                $input.val(oldVal);
                $field.html(oldText);
                $input.hide();
                $field.show();
            }

        });
        $input.on('blur', function() {

            var
                textInput = $input.val(),
                textField = textInput;

            $input.hide();
            $field.html(textField);

            if (textInput != oldVal) {
                $field.addClass('was-edited');
            }

            $field.show();
        });
    });

    // Фокус на название категории оффера при создании новой:
    var isCreateOferCategory = !$('#offerscategory-create-form').data('cat');
    if (isCreateOferCategory) {
        $('.offer-title.edited').click();
        $('#offerscategory-create-form').on('submit', function(){
            return false;
        });
    }

    // Клик на "Сохранить" категорию:
    $('#offerscategory-create-form').on('submit', function(e) {

        var
            formData = {},
            action = $(this).attr('action'),
            method = $(this).attr('method');

        var vals = $(this).serializeArray();
        if(vals.length) {
            for(var i in vals) {
                formData[vals[i].name] = vals[i].value;
            }
        }

        $.ajax(action, {
            type: method,
            data: formData,
            success: function(data) {
                if(data) {
                    if(data.result === true && data.redirect) {
                        document.location.href = data.redirect;
                    }
                    if(data.result === false && data.msg) {
                        $.showMessage('error', data.msg);
                    }
                } 
            },
            error: function(rew, status, err) {
                console.log(status, err);                    
            }
        });
        return false;
    });
    
    // Удаление категории (подкатегории):
    $('table.cats').on('click', '.btn.btn-danger', function(){

        if (confirm("Удалить категорию?")) {
        
            $.ajax(
                $(this).data('link'),
                {
                    type: 'POST',
                    success: function(data) {
                        if(data) {

                            if(data.result === true && data.redirect) {
                                document.location.href = data.redirect;
                            }
                            if(data.result === false && data.msg) {
                                $.showMessage('error', data.msg);
                            }
                        } 
                    },
                    error: function(rew, status, err) {
                        console.log(status, err);                    
                    }
                }
            );

        } else {
            return false;
        }
        
    });
    
});