<?php
/**
 * Copyright (c) 2017 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Action\Admin;


use App\Model\Contacts as ContactsModel;
use Monolog\Logger;
use Psr\Http\Message\ResponseInterface;
use Psr\Http\Message\ServerRequestInterface;
use Slim\Flash\Messages;
use Zend\Diactoros\Response\HtmlResponse;
use Zend\Diactoros\Response\JsonResponse;
use Zend\Diactoros\Response\RedirectResponse;
use Zend\Hydrator\DelegatingHydrator;

/**
 * Class Contacts
 * @package App\Action\Admin
 */
class Contacts extends Common
{

    /**
     * @param ServerRequestInterface $request
     * @param ResponseInterface $response
     * @param callable|null $next
     * @return ResponseInterface|HtmlResponse|JsonResponse
     */
    function __invoke(ServerRequestInterface $request, ResponseInterface $response, callable $next = null)
    {
        /** @var ContactsModel $contacts */
        $contacts = $this->container->get(ContactsModel::class);
        if ($request->getMethod() == 'POST') {
            $data = $request->getParsedBody();
            foreach ($data as $key => &$datum) {
                $datum = explode(PHP_EOL, $datum);
            }

            /** @var DelegatingHydrator $hydrator */
            $hydrator = $this->container->get(DelegatingHydrator::class);
            /** @var \App\Entity\Contacts $contacts */
            $entity = $hydrator->hydrate($data, new \App\Entity\Contacts());
            try {
                $contacts->save($entity);
                $response = new RedirectResponse($this->router->generateUri('adm.contacts', [
                    'lang' => $request->getAttribute('layoutInfo')->getLang(),
                ]));
            } catch (\Exception $e) {
                /** @var Logger $log */
                $log = $this->container->get(Logger::class);
                $log->error($e->getMessage(), [
                    'trace' => $e->getTraceAsString()
                ]);

                /** @var Messages $flash */
                $flash = $request->getAttribute('flash');
                $flash->addMessage('error', $e->getMessage());

            }
        } else {
            $response = new HtmlResponse($this->template->render('adm::contacts', [
                'lang' => $request->getAttribute('layoutInfo')->getLang(),
                'contacts' => $contacts->get(),
            ]));
        }
        return $response;
    }
}