$(document).ready(function () {
    
    $('#user-date-create').datepicker({
        format: 'yyyy-mm-dd',
        language: $('#user-date-create').data('language')
    });
    
    // Добавление названия сайта в список сайтов пользователя:
    /*
    var siteStatusUrl = $('#user-site').data('status-url');
    $('#user-site').tokenfield()
            .on('tokenfield:createdtoken', function(e){
                var tokenClass = '';
                $.ajax(siteStatusUrl, {
                   method: 'POST',
                   async: false,
                   data: {
                       domain: e.attrs.value
                   },                   
                   success: function(data) {
                       console.log(data);
                       if(data && !data.isUnique) {
                            tokenClass = 'bg-danger';
                       }                       
                   }
                });                              
                
                if(tokenClass !== '') {
                    console.log(e.relatedTarget);                    
                    $(e.relatedTarget).addClass(tokenClass);
                    
                    $.showMessage('info', 'Домен уже зарегистрирован');
                }
                
                return true;
            })
    ;
    */
    
    
    // Обработка списка "Провайдеры, к кодам которых у пользователя есть доступ"
    (function(){

        // Клик на "Редактировать" для показа списка значений вместо строки:
        $('.form-group').on('click', '.edit-item', function(){
            var
                $this = $(this),
                $wrap = $this.parents('.form-group')[0],
                $valuesString = $('.values-string', $wrap),
                $valuesEdit = $('.values-edit', $wrap),
                $valuesItems = $('.values-items', $wrap),
                $tempState = $('.temp-state', $wrap);

            $tempState.empty();
            $tempState.html($valuesItems.html());

            CheckNoValues($this);
            $this.hide();
            $valuesString.hide();
            $valuesEdit.show();
            return false;
        });

        // Клик на "Добавить" значение в список:
        $('.form-group').on('click', '.add-item', function(){
            var
                $wrap = $(this).parents('.form-group').first(),
                $valuesItems = $('.values-items', $wrap),
                $tplInput;

            if ($wrap.hasClass('code-provider')) {
                $tplInput = $('.code-provider-pattern .input-item').clone();
            }

            $valuesItems.append($tplInput);
            CheckNoValues($(this));
            return false;
        });

        // Клик на "Удалить" значение из списка:
        $('.form-group').on('click', '.delete-input', function(){
            var
                $wrap = $(this).parents('.input-item'),
                $items = $(this).parents('.values-items');
            
            $wrap.remove();
            CheckNoValues($items);
            return false;
        });

        // Клик на "Отмена" показа списка:
        $('.form-group').on('click', '.cancel-item', function(){
            var
                $wrap = $(this).parents('.form-group').first(),
                $edit = $('.edit-item', $wrap),
                $valuesString = $('.values-string', $wrap),
                $valuesEdit = $('.values-edit', $wrap),
                $valuesItems = $('.values-items', $wrap),
                $tempState = $('.temp-state', $wrap);

            $valuesItems.html($tempState.html());

            $tempState.empty();
            $edit.show();
            $valuesString.show();
            $valuesEdit.hide();
            return false;
        });

        // Клик на "Сохранить" список значений:
        $('.form-group').on('click', '.save-item', function(){
            var
                $wrap = $(this).parents('.form-group').first(),
                $edit = $('.edit-item', $wrap),
                $valuesString = $('.values-string', $wrap),
                $valuesEdit = $('.values-edit', $wrap),
                $valuesItems = $('.values-items .input-item', $wrap),
                $tempState = $('.temp-state', $wrap),
                dataItems = [];

            $valuesItems.each(function(){
                var
                    $this = $(this),
                    itemValue = $('select', $this).val(),
                    itemText = $("select option:selected", $this).text();
                
                if (itemValue) {
                    dataItems.push(itemText);
                }
            });

            $valuesString.empty();
            dataItems.forEach(function(item){
                $valuesString.append('<span>' + item + '</span> ');
            });

            $tempState.empty();
            $edit.show();
            $valuesString.show();
            $valuesEdit.hide();
            return false;
        });

        function CheckNoValues($this)
        {
            var
                $wrap = $('.values-edit', $this.parents('.form-group')[0]),
                $inputItems = $('.values-items .input-item', $wrap),
                $noValues = $('.no-values', $wrap);
            
            if ($inputItems.length) {
                $noValues.hide();
            } else {
                $noValues.show();
            }
        }

    })();
    
    
    // Поле "Доступные сайты"
    var
        $inputAccessSite = $('#user-access-site'),
        delimiterAccessSite = ';';
    
    $inputAccessSite.tokenfield({delimiter: delimiterAccessSite, beautify: false});
    $('.add-access-site').click(function(){
        var
            addSite = $('select.access-site').val(),
            listAddSites = $inputAccessSite.tokenfield('getTokensList'),
            dataAddSites = listAddSites.split(delimiterAccessSite);
        
        if (dataAddSites.indexOf(addSite) == -1)
        {
            $inputAccessSite.tokenfield('setTokens', listAddSites + delimiterAccessSite + addSite);
        }
        
        return false;
    });
    
    
    var busy = false;
    $('#user-form').on('submit', function(){
        
        if(busy) {
            return false;
        }
        
        var action = $(this).attr('action');
        var method = $(this).attr('method');
        
        // Формируем массив сайтов, для которых есть доступ:
        var listAccessUsers = $('input#user-access-site').val();
        if (!!listAccessUsers)
        {
            var dataAccessUsers = listAccessUsers.split(delimiterAccessSite);
            $('input#user-access-site').val(JSON.stringify(dataAccessUsers));
        }
        
        // Формируем данные providers:
        var
            dataCodeProvider = [],
            $codeProviderItems = $('.form-group.code-provider .form-control.code-provider');

        $codeProviderItems.each(function(){
            if ($(this).val()) {
                dataCodeProvider.push(parseInt($(this).val()));
            }
        });
        if (dataCodeProvider.length == 0) {
            $('input#code-provider').val("");
        } else {
            $('input#code-provider').val(JSON.stringify(dataCodeProvider));
        }
        
        
        var data = {};
        $(this).find('.form-control:not(.access-site)').each(function(){
            data[$(this).attr('name')] = $(this).val();
        });       
        $(this).find('input[type=checkbox]').filter(':checked').each(function(){
            if(!data[$(this).attr('name')]) {
                data[$(this).attr('name')] = [];
            }                
            data[$(this).attr('name')].push($(this).val());
        });
        
        //console.log('AAA data = ', data);
        //return false;
        
        busy = true;
        $.ajax(action, {
           type: method,           
           data: data,           
           success: function(data) {

               busy = false;
               
               if(data) {
                   if(data.result == true && data.redirect) {
                       window.location.href = data.redirect; 
                   }
                   if(data.result == false && data.msg) {
                       console.log('AAA error ', data.msg);
                       $.showMessage('error', data.msg);
                   }
               }                            
           },
           error: function(ajaxObj, textStatus, textError) {
               busy = false;
           }
        });              
        
        return false;
    });
});


