$(document).ready(function () {
    "use strict";
    Array.prototype.forEach.call(document.querySelectorAll("button[data-toggle]"), function (el) {
        $(el).on("click", function (e) {
            e.stopPropagation();

            $.ajax(this.getAttribute(this.getAttribute("data-value")), {
                type: "POST",
                item: this,
                success: function (data) {
                    if (data.result) {
                        var currentValue = this.item.getAttribute(this.item.getAttribute("data-value"));
                        if (currentValue === this.item.getAttribute("data-hide")) {
                            this.item.setAttribute("data-value", "data-activate");
                            $(this.item)
                                .text(this.item.getAttribute("data-activate-caption"))
                                .removeClass("btn-danger");

                        } else {
                            this.item.setAttribute("data-value", "data-hide");
                            $(this.item)
                                .text(this.item.getAttribute("data-hide-caption"))
                                .addClass("btn-danger");
                        }
                    }
                    console.log(data);
                },
                error: function(req, status, err) {
                    console.log(status, err);
                }
            });
        });
    });
});