<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Hydrator\Strategy;


use App\Entity\Statistic\Data as DataEntity;
use App\Hydrator\Data as DataHydrator;
use Zend\Hydrator\Strategy\DefaultStrategy;

/**
 * Class Data
 * @package App\Hydrator\Strategy
 */
class Data extends DefaultStrategy
{

    const EXTRACT_ALL = 1;
    const EXTRACT_VALUES = 2;
    const EXTRACT_PERCENT = 3;
    const EXTRACT_TITLE = 4;

    protected $mode;

    /**
     * Data constructor.
     */
    public function __construct($mode = Data::EXTRACT_ALL)
    {
        $this->mode = $mode;
    }


    /**
     * @param \App\Entity\Statistic\Data $value
     * @return mixed
     */
    public function extract($value)
    {
        //$value = parent::extract($value);
        switch ($this->mode) {
            case Data::EXTRACT_VALUES:
                $result = $value->getValue();
                break;
            case Data::EXTRACT_PERCENT:
                $result = $value->getPercent();
                break;
            case Data::EXTRACT_TITLE:
                $result = $value->getTitle();
                break;
            case Data::EXTRACT_ALL:
            default:
                $result =  (new DataHydrator())->extract($value);
                break;
        }
        return $result;
    }

    /**
     * @param mixed $value
     * @return mixed
     */
    public function hydrate($value)
    {
        if (!$value instanceof DataEntity) {
            $value = (new DataHydrator())->hydrate($value, new DataEntity());
        }
        parent::hydrate($value);

        return $value;
    }

}