<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

use Interop\Container\ContainerInterface;

return [
    'dependencies' => [
        'factories' => [
            App\Action\Admin\Login::class => function (ContainerInterface $container) {
                return new \App\Action\Admin\Login(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Admin\Logout::class => function (ContainerInterface $container) {
                return new \App\Action\Admin\Logout(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Admin\Profile::class => function (ContainerInterface $container) {
                return new \App\Action\Admin\Profile(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Admin\Index::class => function (ContainerInterface $container) {
                return new \App\Action\Admin\Index(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Admin\Init::class => function (ContainerInterface $container) {
                return new \App\Action\Admin\Init(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Admin\Users::class => function (ContainerInterface $container) {
                return new \App\Action\Admin\Users(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Admin\Supports::class => function (ContainerInterface $container) {
                return new \App\Action\Admin\Supports(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Admin\FAQ::class => function(ContainerInterface $container) {
                return new \App\Action\Admin\FAQ(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Admin\Vacancies::class => function(ContainerInterface $container) {
                return new \App\Action\Admin\Vacancies(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Admin\Contacts::class => function(ContainerInterface $container) {
                return new \App\Action\Admin\Contacts(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            
            App\Action\Admin\SystemAction::class => function (ContainerInterface $container) {
                return new \App\Action\Admin\SystemAction(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            App\Action\Admin\Feeds::class => function (ContainerInterface $container) {
                return new \App\Action\Admin\Feeds(
                    $container->get(\Zend\Expressive\Router\RouterInterface::class),
                    $container->get(\Zend\Expressive\Template\TemplateRendererInterface::class),
                    $container
                );
            },
            
        ],
    ],

    'routes' => [
        [
            'name' => 'adm.index',
            'path' => '/[:lang/]support/',
            'middleware' => App\Action\Admin\Index::class,
            'allowed_methods' => ['GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                ]
            ],
        ],
        [
            'name' => 'adm.init',
            'path' => '/[:lang/]support/init/',
            'middleware' => App\Action\Admin\Init::class,
            'allowed_methods' => ['GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                ]
            ],
        ],
        [
            'name' => 'adm.login',
            'path' => '/[:lang/]support/login/',
            'middleware' => App\Action\Admin\Login::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                ]
            ],
        ],
        [
            'name' => 'adm.logout',
            'path' => '/[:lang/]support/logout/',
            'middleware' => App\Action\Admin\Logout::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                ]
            ],
        ],        
        [
            'name' => 'adm.supports',
            'path' => '/[:lang/]support/supports/',
            'middleware' => App\Action\Admin\Supports::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                ]
            ],
        ],
        [
            'name' => 'adm.supports.create',
            'path' => '/[:lang/]support/supports/create/',
            'middleware' => App\Action\Admin\Supports::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                    'action' => App\Action\Admin\Supports::ACTION_CREATE,
                ]
            ],
        ],
        [
            'name' => 'adm.supports.edit',
            'path' => '/[:lang/]support/supports/edit/:id',
            'middleware' => App\Action\Admin\Supports::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                    'id' => '\d+',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                    'action' => App\Action\Admin\Supports::ACTION_EDIT,
                ]
            ],
        ],
        [
            'name' => 'adm.supports.delete',
            'path' => '/[:lang/]support/supports/delete/:id',
            'middleware' => App\Action\Admin\Supports::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                    'action' => App\Action\Admin\Supports::ACTION_DELETE,
                ]
            ],
        ],
        [
            'name' => 'adm.system.actions',
            'path' => '/system-actions/',
            'middleware' => App\Action\Admin\SystemAction::class,
            'allowed_methods' => ['POST'],
            'options' => [
                'constraints' => [
                ],
                'defaults' => [
                    'action' => App\Action\Admin\SystemAction::ACTION_SYSTEM,
                ]
            ],
        ],
        
        /* Feed-system */
        [
            'name' => 'adm.feeds',
            'path' => '/[:lang/]feed-system/',
            'middleware' => App\Action\Admin\Feeds::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'page_group' => 'feeds',
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                    'action' => App\Action\Admin\Feeds::ACTION_LIST,
                ]
            ],
        ],
        [
            'name' => 'adm.feed.create',
            'path' => '/[:lang/]feed-system/create/',
            'middleware' => App\Action\Admin\Feeds::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                    'action' => App\Action\Admin\Feeds::ACTION_CREATE,
                ]
            ],
        ],
        [
            'name' => 'adm.feed.edit',
            'path' => '/[:lang/]feed-system/feed/:id/',
            'middleware' => App\Action\Admin\Feeds::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                    'action' => App\Action\Admin\Feeds::ACTION_EDIT,
                ]
            ],
        ],
        
        [
            'name' => 'adm.faq',
            'path' => '/[:lang/]support/faq/',
            'middleware' => App\Action\Admin\FAQ::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                ]
            ],
        ],
        [
            'name' => 'adm.profile',
            'path' => '/[:lang/]support/profile/',
            'middleware' => App\Action\Admin\Profile::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                ]
            ],
        ],
        
        [
            'name' => 'adm.contacts',
            'path' => '/[:lang/]support/contacts/',
            'middleware' => App\Action\Admin\Contacts::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                ]
            ],
        ],
        [
            'name' => 'adm.faq.category.edit',
            'path' => '/[:lang/]support/faq/category/edit/:id',
            'middleware' => App\Action\Admin\FAQ::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                    'id' => '\d+',
                ],
                'defaults' => [
                    'action' => \App\Action\Admin\FAQ::ACTION_CATEGORY_EDIT,
                ],
            ],
        ],
        [
            'name' => 'adm.faq.category.activate',
            'path' => '/[:lang/]support/faq/category/activate/:id',
            'middleware' => App\Action\Admin\FAQ::class,
            'allowed_methods' => ['POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                    'id' => '\d+',
                ],
                'defaults' => [
                    'action' => \App\Action\Admin\FAQ::ACTION_CATEGORY_ACTIVATE,
                ],
            ],
        ],
        [
            'name' => 'adm.faq.category.hide',
            'path' => '/[:lang/]support/faq/category/hide/:id',
            'middleware' => App\Action\Admin\FAQ::class,
            'allowed_methods' => ['POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                    'id' => '\d+',
                ],
                'defaults' => [
                    'action' => \App\Action\Admin\FAQ::ACTION_CATEGORY_HIDE,
                ],
            ],
        ],
        [
            'name' => 'adm.faq.item.activate',
            'path' => '/[:lang/]support/faq/item/activate/:id',
            'middleware' => App\Action\Admin\FAQ::class,
            'allowed_methods' => ['POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                    'id' => '\d+',
                ],
                'defaults' => [
                    'action' => \App\Action\Admin\FAQ::ACTION_ITEM_ACTIVATE,
                ],
            ],
        ],
        [
            'name' => 'adm.faq.item.hide',
            'path' => '/[:lang/]support/faq/item/hide/:id',
            'middleware' => App\Action\Admin\FAQ::class,
            'allowed_methods' => ['POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                    'id' => '\d+',
                ],
                'defaults' => [
                    'action' => \App\Action\Admin\FAQ::ACTION_ITEM_HIDE,
                ],
            ],
        ],
        [
            'name' => 'adm.faq.item.edit',
            'path' => '/[:lang/]support/faq/item/edit/:id',
            'middleware' => App\Action\Admin\FAQ::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                    'id' => '\d+',
                ],
                'defaults' => [
                    'action' => \App\Action\Admin\FAQ::ACTION_ITEM_EDIT,
                ],
            ],
        ],
        [
            'name' => 'adm.faq.item.create',
            'path' => '/[:lang/]support/faq/item/create/:categoriesId',
            'middleware' => App\Action\Admin\FAQ::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                    'categoriesId' => '\d+',
                ],
                'defaults' => [
                    'action' => \App\Action\Admin\FAQ::ACTION_ITEM_CREATE,
                ],
            ],
        ],
        
        
        
        /* Manage users */
        [
            'name' => 'adm.users',
            'path' => '/[:lang/]support/users/',
            'middleware' => App\Action\Admin\Users::class,
            'allowed_methods' => ['POST', 'GET'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                ],                
                'defaults' => [
                    'lang' => \App\Model\Locales::DEFAULT_LANG_ADMIN,
                    'page' => 'list',
                ]
            ],
        ],
        [
            'name' => 'adm.users.create',
            'path' => '/[:lang/]support/users/new/',
            'middleware' => App\Action\Admin\Users::class,
            'allowed_methods' => ['GET', 'POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',                    
                ],                
                'defaults' => [
                    'page' => 'create',
                    'action' => App\Action\Admin\Users::STATUS_CREATE,
                ],
            ],
        ],
        [
            'name' => 'adm.users.edit',
            'path' => '/[:lang/]support/users/edit/:id',
            'middleware' => App\Action\Admin\Users::class,
            'allowed_methods' => ['GET', 'POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',           
                    'id' => '\d+',
                ],                
                'defaults' => [
                    'page' => 'edit',
                    'action' => App\Action\Admin\Users::STATUS_EDIT,
                ],
            ],
        ],
        [
            'name' => 'adm.users.statistic',
            'path' => '/[:lang/]support/users/statistic/:id',
            'middleware' => App\Action\Admin\Users::class,
            'allowed_methods' => ['GET', 'POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',           
                    'id' => '\d+',
                ],                
                'defaults' => [
                    'page' => 'statistic'
                ],
            ],
        ],
        
        [
            'name' => 'adm.users.status.site',
            'path' => '/[:lang/]support/users/site/[:id/]',
            'middleware' => App\Action\Admin\Users::class,
            'allowed_methods' => ['POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',           
                    'id' => '\d+',
                ],                
                'defaults' => [                    
                    'action' => App\Action\Admin\Users::STATUS_SITE,
                ],
            ],            
        ],
        [
            'name' => 'adm.users.status.block',
            'path' => '/[:lang/]support/users/block/:id',
            'middleware' => App\Action\Admin\Users::class,
            'allowed_methods' => ['POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                    'id' => '\d+',
                ],
                'defaults' => [
                    'action' => \App\Action\Admin\Users::STATUS_BLOCK,
                ],
            ],
        ],
        [
            'name' => 'adm.users.status.unblock',
            'path' => '/[:lang/]support/users/unblock/:id',
            'middleware' => App\Action\Admin\Users::class,
            'allowed_methods' => ['POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                    'id' => '\d+',
                ],
                'defaults' => [
                    'action' => \App\Action\Admin\Users::STATUS_UNBLOCK,
                ],
            ],
        ],
        [
            'name' => 'adm.users.status.activate',
            'path' => '/[:lang/]support/users/activate/:id',
            'middleware' => App\Action\Admin\Users::class,
            'allowed_methods' => ['POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                    'id' => '\d+',
                ],
                'defaults' => [
                    'action' => \App\Action\Admin\Users::STATUS_ACTIVATE,
                ],
            ],
        ],
        [
            'name' => 'adm.users.status.deactivate',
            'path' => '/[:lang/]support/users/deactivate/:id',
            'middleware' => App\Action\Admin\Users::class,
            'allowed_methods' => ['POST'],
            'options' => [
                'constraints' => [
                    'lang' => '[a-z]{2,3}',
                    'id' => '\d+',
                ],
                'defaults' => [
                    'action' => \App\Action\Admin\Users::STATUS_DEACTIVATE,
                ],
            ],
        ],        
    ],
];
