<?php
use App\Acl\Roles;
use Interop\Container\ContainerInterface;

return [
    'dependencies' => [
        'factories' => [
            \Zend\Permissions\Acl\AclInterface::class => function (ContainerInterface $container) {
                $acl = new \Zend\Permissions\Acl\Acl();
                foreach ($container->get('aclRoles') as $value) {
                    if (is_array($value)) {
                        $acl->addRole($value['role'], $value['parent']);
                    } else {
                        $acl->addRole($value);
                    }
                }
                foreach ($container->get('aclResources') as $resource) {
                    $acl->addResource($resource);
                }

                $acl->deny(null, null)
                    ->allow(Roles::ROLE_GUEST, 'home');

                $acl->allow(Roles::ROLE_GUEST, 'login')
                    ->allow(Roles::ROLE_GUEST, 'register')
                    ->allow(Roles::ROLE_GUEST, 'faq')
                    ->allow(Roles::ROLE_GUEST, 'contacts')
                    ->allow(Roles::ROLE_GUEST, 'statistics')
                    ->allow(Roles::ROLE_USER, 'logout')
                    ->allow(Roles::ROLE_GUEST, 'user.password.reset')
                    ->allow(Roles::ROLE_USER, 'user.activate')
                    ->allow(Roles::ROLE_USER, 'user.mail.send.activation')
                    ->allow(Roles::ROLE_USER, 'user.mail.request.activate.protection')
                    ->allow(Roles::ROLE_GUEST, 'user.mail.sent.password')
                    ->allow(Roles::ROLE_USER, 'user.cabinet', null, new \App\Acl\Assertion\UserActive())
                    ->allow(Roles::ROLE_USER, 'user.cabinet.cats', null, new \App\Acl\Assertion\UserActive())
                    ->allow(Roles::ROLE_USER, 'user.cabinet.profile', null, new \App\Acl\Assertion\UserActive())
                    ->allow(Roles::ROLE_USER, 'user.cabinet.viewid', null, new \App\Acl\Assertion\UserActive())
                    ->allow(Roles::ROLE_USER, 'user.cabinet.orderid', null, new \App\Acl\Assertion\UserActive())
                    ->allow(Roles::ROLE_USER, 'user.cabinet.amsystem', null, new \App\Acl\Assertion\UserActive())
                    ->allow(Roles::ROLE_USER, 'install.counter', null, new \App\Acl\Assertion\UserActive())
                    ->allow(Roles::ROLE_USER, 'download.counter', null, new \App\Acl\Assertion\UserActive())
                    ->allow(Roles::ROLE_GUEST, 'email.counter')
                    ->allow(Roles::ROLE_GUEST, 'adm.system.actions')
                    
                    
                    // Supports area
                    ->allow(Roles::ROLE_GUEST, 'adm.login')
                    ->allow(Roles::ROLE_GUEST, 'adm.logout')
                    ->allow(Roles::ROLE_GUEST, 'adm.init')
                    
                    // Admin                        
                    ->allow(Roles::ROLE_ADMIN, 'adm.supports')
                    ->allow(Roles::ROLE_ADMIN, 'adm.supports.create')
                    ->allow(Roles::ROLE_ADMIN, 'adm.supports.delete')     
                    ->allow(Roles::ROLE_ADMIN, 'adm.supports.edit')
                    ->allow(Roles::ROLE_ADMIN, 'adm.index')
                    
                    ->allow(Roles::ROLE_ADMIN, 'adm.feeds')
                    ->allow(Roles::ROLE_ADMIN, 'adm.feed.create')
                    ->allow(Roles::ROLE_ADMIN, 'adm.feed.edit')
                    
                     
                    ->allow(Roles::ROLE_MANAGER, 'adm.index')
                    
                    ->allow(Roles::ROLE_MANAGER, 'adm.contacts')
                    ->allow(Roles::ROLE_MANAGER, 'adm.faq')
                    ->allow(Roles::ROLE_MANAGER, 'adm.faq.item.hide')
                    ->allow(Roles::ROLE_MANAGER, 'adm.faq.item.activate')
                    ->allow(Roles::ROLE_MANAGER, 'adm.faq.item.edit')
                    ->allow(Roles::ROLE_MANAGER, 'adm.faq.item.create')
                    ->allow(Roles::ROLE_MANAGER, 'adm.faq.category.hide')
                    ->allow(Roles::ROLE_MANAGER, 'adm.faq.category.activate')
                    ->allow(Roles::ROLE_MANAGER, 'adm.faq.category.edit')
                        
                    ->allow(Roles::ROLE_MANAGER, 'adm.users')
                    ->allow(Roles::ROLE_MANAGER, 'adm.users.create')
                    ->allow(Roles::ROLE_MANAGER, 'adm.users.edit')
                    ->allow(Roles::ROLE_MANAGER, 'adm.users.statistic')
                    ->allow(Roles::ROLE_MANAGER, 'adm.users.status.site')
                    ->allow(Roles::ROLE_MANAGER, 'adm.users.status.block')
                    ->allow(Roles::ROLE_MANAGER, 'adm.users.status.unblock')
                    ->allow(Roles::ROLE_MANAGER, 'adm.users.status.activate')
                    ->allow(Roles::ROLE_MANAGER, 'adm.users.status.deactivate')
                        
                    ->allow(Roles::ROLE_SUPPORT, 'logout')
                    ->allow(Roles::ROLE_SUPPORT, 'adm.profile')

                ;

                return $acl;
            },
            'aclResources' => function (ContainerInterface $container) {
                $result = [];
                $routes = $container->get('config')['routes'];
                foreach ($routes as $route) {
                    $result[] = $route['name'];
                }
                return $result;
            },
            'aclRoles' => function () {
                return (new Roles())->getRoles();
            },
        ],
    ],
];
