$(document).ready(function(){

    Number.prototype.formatMoney = function(c, d, t){
        var n = this, 
            c = isNaN(c = Math.abs(c)) ? 2 : c, 
            d = d == undefined ? "." : d, 
            t = t == undefined ? "," : t, 
            s = n < 0 ? "-" : "", 
            i = String(parseInt(n = Math.abs(Number(n) || 0).toFixed(c))), 
            j = (j = i.length) > 3 ? j % 3 : 0;
        return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
    };
    
    // Добавление впереди 0 у однозначных значений
    function pad(number) {
        var r = String(number);
        if ( r.length === 1 ) {
          r = '0' + r;
        }
        return r;
    }
    
    // Форматирование даты
    function formatDate(date)
    {
        return date.getUTCFullYear() +'-'+ pad(date.getMonth()+1) +'-'+ pad(date.getDate());
    }
    
    //function createDropDown($element, onselect=null, oncreate=null) {
    function createDropDown($element, onselect, oncreate) {
        var $current = $element.find('.droplist-current');
        $current.on('click focus', function(e, t){
            
            var $this = $(this);
            var $thisList = $this.siblings().filter('.droplist-block');
            var $dropList = $thisList;
        
            var sumListEl = $thisList.children().length;
            var heightList = $thisList[0].clientHeight;
      
            if($dropList.hasClass('m-open-droplist')) {
                $('.m-open-droplist').removeClass('m-open-droplist');
            } else {
                $('.m-open-droplist').removeClass('m-open-droplist');
                $dropList.addClass('m-open-droplist');
                $this.addClass('m-open-droplist');
            }
            e.stopPropagation();
            return false;
        });                     
        
        var $list = $element.find('.droplist-item');
        if($list.length > 0) {           
            $current.html($list.first().html());        
            
            if(typeof oncreate == 'function') {
                oncreate($list.first(), $current);
            }
        }
        
        $list.on('click', function() {
            var $this = $(this);
            var selectStr = $(this).html();
            
            $(this).parent().siblings().filter('.droplist-current').html(selectStr);
            $('.m-open-droplist').removeClass('m-open-droplist');                                  
            if(typeof onselect == 'function') {                               
                onselect($this, $current);                              
            }           
            
            return false;
        });
    }  
    
    var domainsListSelector = '#domains-list';
    var domainClassSelected = 'domain-selected';
    var subDomainClassSelected = 'sub-domain-selected';
    var subDomainStateSelected = 'state-selected';
   
    function selectedDomainsAll() {
        
        var
            $domainsList = $(domainsListSelector),
            selectedDomains = [],
            subdomains = 1,
            count = $domainsList.find('.main-domain').length,
            $mainDomains = $domainsList.find('.main-domain' + '.' + domainClassSelected);
        
        // Выбрано несколько основных доменов
        if ($mainDomains.length > 1)
        {
            $mainDomains.each(function(){
                selectedDomains.push($(this).data('domain'));
            });
        }
        // Выбран один основной домен
        else
        {
            var mainDomainTitle = $mainDomains.data('domain'); 
            
            // Выбираем субдомены
            $mainDomains.each(function(){
                $(this).parent().find('.sub-domain'+'.'+subDomainClassSelected).each(function(){
                    selectedDomains.push($(this).data('domain'));            
                });
            });

            // субдомен совпадает с  основным доменом
            //if (selectedDomains.length == 1 && selectedDomains[0] == mainDomainTitle)
            if (selectedDomains.length == 1)
            {
                subdomains = 0;
            }
            
            // Выбран основной домен
            if (selectedDomains.length == 0)
            {
                selectedDomains.push(mainDomainTitle);
            }
        }
        
        return {'domains': selectedDomains, 'subdomains': subdomains, 'count': count};
    }
    
    
    // Создание дров дауны и список сайтов
    $('.b-filter__switch').each(function(index,el){
      if(!$(el).find('.b-filter__switch-item').hasClass('m-filter__switch-item_active')) {
        $(el).find('.b-filter__switch-item').eq(0).trigger('click');
      }
    });

    $('.b-content__site-droplist .droplist-item').each(function(index, el){
      if($(el).attr('data-src-icon-site')){
        var srcIcon = $(el).attr('data-src-icon-site');
        $(this).css({
            'background-image': 'url(' + srcIcon + ')'
          });
      }
    });
    
    // Список доменов
    var $domainsList = $(domainsListSelector);
    
    $domainsList.find('.main-domain').each(function(){
        $(this).addClass(domainClassSelected);
    });
    
    // Клик по основному домену
    $domainsList.find('.main-domain').click(function() {
        
        var $this = $(this);
        //console.log('AAA Клик по основному домену ', $this.data('id'));
        
        var type = $('#sites-dropdown').find('.droplist-current').data('id');
        
        if(type == 'all')  {    // Отрображался список всех доменов
            var domainId = $(this).data('id');            
            $('#sites-dropdown .droplist-item').each(function(){               
                if($(this).data('id') == domainId) {
                    $(this).click();
                }
                return;
            });
            return false;          
        } else {    // Отрображался список поддоменов одного домена
            $(this).parent().find('.sub-domain').removeClass(subDomainClassSelected);
            $(this).parent().find('.sub-domain').removeClass(subDomainStateSelected);
        }
        
        $domainsList.trigger('select-domain');
        return false;
    });
    
    // Клик по названию субдомена
    $domainsList.on('click', '.sub-domain', function() {
        //console.log('AAA Клик по названию субдомена');
        var $this = $(this);
        var $allSubdomainsTitle = $this.parents('.sub-list').find('.sub-domain');
        
        $allSubdomainsTitle.removeClass(subDomainStateSelected);
        $allSubdomainsTitle.removeClass(subDomainClassSelected);
        $this.addClass(subDomainStateSelected);
        $this.addClass(subDomainClassSelected);
        
        $domainsList.trigger('select-domain');
        return false;
    });
    
    // Закрыть дропдаун по клику на странице
    $(document).on('click', function() {
        $('.m-open-droplist').removeClass('m-open-droplist');
    });
    
    // Дропдаун списка доменов:
    createDropDown($('#sites-dropdown'), function($element, $current) {
        //console.log('AAA Клик по домену из выпадающего списка');
        
        var attrSrcIcon = $element.attr('data-src-icon-site'); // иконка выбранного сайта
        var attrSiteId = $element.attr('data-id'); // id выбранного сайта
        
        $current.data('id', attrSiteId);
        $current.css({'background-image': 'url(' + attrSrcIcon + ')'}).attr('data-id', attrSiteId);                             
        
        // Инициируем запрос по соответствующему домену в списке:
        var $currentDomain = $(domainsListSelector + ' .main-domain[data-id="' + attrSiteId + '"]');
        var $listSubdomains = $currentDomain.siblings('.b-subdomains-list');
        var $leftItem = $('.b-content__losses-left-item');
        var $allDomains = $('.all-domains');
        
        // Логика запроса для списка поддоменов:
        getSubdomainsList($listSubdomains, $currentDomain.data('id'));
        
        // Снимаем подсветку у поддоменов:
        $domainsList.find('.sub-domain').removeClass(subDomainClassSelected);
        $domainsList.find('.sub-domain').removeClass(subDomainStateSelected);
        
        
        // Перебираем домены в списке:
        $domainsList.find('.main-domain').each(function() {
            var relDomain = $(this).data('domain');
            
            if(attrSiteId == 'all') {
                $(this).addClass('domain-selected').removeClass('font-bold');
                $(this).parent().show();
                $(this).parent().find('.sub-list').hide();
                $leftItem.removeClass('state-subdomains');
                //$(this).parent().find('.sub-domain').addClass(subDomainClassSelected);
            } else if(relDomain != attrSiteId) {
                $(this).removeClass('domain-selected').removeClass('font-bold');
                $(this).parent().hide();
                $(this).parent().find('.sub-domain').removeClass(subDomainClassSelected);
            } else if(relDomain == attrSiteId) {
                $(this).addClass('domain-selected').addClass('font-bold');
                $(this).parent().show();         
                $(this).parent().find('.sub-list').show();
                $leftItem.addClass('state-subdomains');
                //$(this).parent().find('.sub-domain').addClass(subDomainClassSelected);
            }
            
        });
        
        // Отображение ссылки "Все сайты":
        if(attrSiteId == 'all') {
            $allDomains.hide();
            selectActiveFilters();
        } else {
            $allDomains.show();
        }
        
        
        $domainsList.trigger('select-domain');                
    }, function($element, $current) {
        $current.data('id', $element.data('id'));
    });  

   
    // График    
    
    // Создание отчета и графика
    // Загрузка данных через 15 мин
    // var linkMainData = 
    var timeOut = 1000*60*5;        
    var loadData = setTimeout(function runLoad() {
         loadDataSummuryReport();
         loadDataLineChart();
         
         setTimeout(runLoad, timeOut);
    }, timeOut);


    // Массив данных по суммарному таблице
    var linkSummaryReport = '/statistics/';
    
    var selectorSummaryReport = '#summary-report-table';
    var dataSummaryReport = false;
    if($('#summary-report-stats').val()) {
        dataSummaryReport = JSON.parse($('#summary-report-stats').val());        
    }
    
    // Массив данных по линейным диаграммам
    var selectorGraphChart = '#chart-graph';
    var dataLineChart = false;
    if($('#period-stats').val()) {
        dataLineChart = JSON.parse($('#period-stats').val());
        addDataFields(dataLineChart);
    }
    
    // Данные для статистики по сайтам (для админа)
    if($('#sites-stats').val()) {
        var dataSitesStat = false;
        dataSitesStat = JSON.parse($('#sites-stats').val());
        addDataSitesStatFields(dataSitesStat);
    }
    
    
    
    // Подсвечиваем нужный график
    var
        fullSwitchSelector = '.b-filter__switch.display.full .b-filter__switch-item',
        shortSwitchSelector = '.b-filter__switch.display.short .b-filter__switch-item',
        classActive = 'm-filter__switch-item_active',
        cookieName = 'active_graph';
        
    if ($.cookie(cookieName))
    {
        var activeSwitch = $.cookie(cookieName);
        
        // Подсвечиваем полный список
        if ($(fullSwitchSelector + '[data-filter-category=' + activeSwitch + ']').length > 0)
        {
            $(fullSwitchSelector + '[data-filter-category=' + activeSwitch + ']').addClass(classActive);
        }
        else
        {
            /*
            $(fullSwitchSelector + '[data-filter-category=common_total]').addClass(classActive);
            $(fullSwitchSelector + '[data-filter-category=total]').addClass(classActive);
            */
            $(fullSwitchSelector + ':first').addClass(classActive);
        }
        
        // Подсвечиваем краткий список
        if ($(shortSwitchSelector + '[data-filter-category=' + activeSwitch + ']').length > 0)
        {
            $(shortSwitchSelector + '[data-filter-category=' + activeSwitch + ']').addClass(classActive);
        }
        else
        {
            /*
            $(shortSwitchSelector + '[data-filter-category=rtb]').addClass(classActive);
            $(shortSwitchSelector + '[data-filter-category=money]').addClass(classActive);
            */
            $(shortSwitchSelector + ':first').addClass(classActive);
        }
    }
    else
    {
        /*
        $(fullSwitchSelector + '[data-filter-category=common_total]').addClass(classActive);
        $(fullSwitchSelector + '[data-filter-category=total]').addClass(classActive);
        $(shortSwitchSelector + '[data-filter-category=money]').addClass(classActive);
        $(shortSwitchSelector + '[data-filter-category=rtb]').addClass(classActive);
        */
        $(shortSwitchSelector + ':first').addClass(classActive);
        $(fullSwitchSelector + ':first').addClass(classActive);
        
        var activeSwitch = $('.b-filter__switch.current .m-filter__switch-item_active').data('filter-category');
        $.cookie(cookieName, activeSwitch);
    }
    
    // Переключение между графиками
    $('.b-filter__switch-item').click(function(){
        $(this).siblings().removeClass(classActive);
        $(this).addClass(classActive);
        
        // Переключение таблиц для админа
        if ($(this).parent().hasClass('time-table'))
        {
            if ($(this).data('filter-category') == 'sites') {
                $('#table-line').hide();
                $('#table-sites').show();
                $('.time-table-sort').show();
            } else {
                $('#table-sites').hide();
                $('#table-line').show();
                $('.time-table-sort').hide();
            }
        }
        else if($(this).parent().hasClass('time-table-sort'))
        {
            renderSitesTable();
        }
        else
        {
            activeLine = $(this).data('filter-category'); 
            $.cookie(cookieName, activeLine);

            $(selectorGraphChart).trigger('render-chart');
        }
        
        return false;
    });
    
    var activeLine = $('.b-filter__switch.current .m-filter__switch-item_active').data('filter-category');
    
    var chartDateSelector = '#daterange-dropdown';    
    createDropDown($(chartDateSelector), function($element, $current) {      
        $current.data('date-value', $element.data('date-value'));
        $(selectorGraphChart).trigger('reload-chart');
    }, function($element, $current){        
        $current.data('date-value', $element.data('date-value'));
    });    

    // Ссылка на .json файлы данных категории для отображения данных в линейном графике
    var linkLinerChart          = '/statistics/';
    
    // Стартовая загрузка графиков / перерисовка при изменении размера экрана
    $(window).on('resize orientationchange', function() {      
        loadDataLineChart();      
    });    
    
    
    var
        $loadingAll = $('.b-content__loading'),
        $loadingSummary = $('.b-content__loading.summary'),
        $loadingChart = $('.b-content__loading.chart'),
        $loadingTable = $('.b-content__loading.table');
    
    // Загрузка данных сводной таблицы
    var loadDataSummuryReportBusy = false;
    function loadDataSummuryReport() {
        
        if(loadDataSummuryReportBusy) {
            return;
        }      
        
        var
            selectedSites = selectedDomainsAll().domains,
            userId = ($('.userid-current')) ? $('.userid-current').data('userid') : null,
            isSiteStat = ($('#site-stat').length>0) ? true : false,
            group = ((selectedSites.length == selectedDomainsAll().count) && !userId && !isSiteStat) ? 'all' : false,
            dataDomains = (group == 'all') ? null : selectedSites.join(',');
            
        loadDataSummuryReportBusy = true;
        $loadingSummary.show();
        $.ajax(linkSummaryReport, {
            method: 'POST',
            data: {
                action: 'summary',
                subdomains: selectedDomainsAll().subdomains,
                domains: dataDomains,
                group: group,
                userid: userId
            },
            success: function(res){
                //console.log("AAA loadDataSummuryReport success res: ", res);
                dataSummaryReport = res;
                renderSummaryReport();
                loadDataSummuryReportBusy = false;
                $loadingSummary.hide();
            },
            error: function(req,status,err) {
                console.log("Error " + req,status,err);
                loadDataSummuryReportBusy = false;
                $loadingSummary.hide();
            }
        });
    }

    // Отрисовка и загрузка данных линейного графика
    var loadDataLineChartBusy = false;
    function loadDataLineChart() {
        //console.log('AAA loadDataLineChart');
        
        if(loadDataLineChartBusy) {
            return;
        }
        
        var
            chartDate = $(chartDateSelector).find('.droplist-current').data('date-value'),
            selectedSites = selectedDomainsAll().domains,
            userId = ($('.userid-current')) ? $('.userid-current').data('userid') : null,
            isSiteStat = ($('#site-stat').length>0) ? true : false,
            group = ((selectedSites.length == selectedDomainsAll().count) && !userId && !isSiteStat) ? 'all' : false,
            dataDomains = (group == 'all') ? null : selectedSites.join(',');
        
        var reqData = {
            action: 'linechart',
            subdomains: selectedDomainsAll().subdomains,
            month: chartDate,
            domains: dataDomains,
            group: group,
            userid: userId
        };
        
        loadDataLineChartBusy = true;
        $loadingChart.show();
        $loadingTable.show();
        $.ajax(linkLinerChart, {
            type: 'POST',
            dataType: 'json',
            data: reqData,
            success: function(res) {
                loadDataLineChartBusy = false;
                
                dataLineChart = res;
                addDataFields(dataLineChart);
                
                renderLineChart();                
                renderLineTable();
                $loadingChart.hide();
                $loadingTable.hide();
            },
            error: function(req,status,err) {
                console.log("Error " + req,status,err);
                
                loadDataLineChartBusy = false;
                $loadingChart.hide();
                $loadingTable.hide();
            }
        });
    };
    
    // Загрузка и отрисовка данных таблицы по сайтам
    function loadDataSitesStat()
    {
        return false;
        
        if (!$('#sites-stats').length) {
            return;
        }
        
        var
            chartDate = $(chartDateSelector).find('.droplist-current').data('date-value'),
            selectedSites = selectedDomainsAll().domains,
            group = (selectedSites.length == selectedDomainsAll().count) ? 'subdomain' : false,
            dataDomains = (group == 'subdomain') ? null : selectedSites.join(',');
        
        var reqData = {
            action: 'sitesstat',
            subdomains: selectedDomainsAll().subdomains,
            month: chartDate,
            domains: dataDomains,
            userid: null,
            group: group
        };
        
        //console.log('AAA reqData = ', reqData);
        
        $loadingTable.show();
        $.ajax(linkLinerChart, {
            type: 'POST',
            dataType: 'json',
            data: reqData,
            success: function(res) {
                dataSitesStat = res;
                //console.log('AAA dataSitesStat: ', dataSitesStat);
                addDataSitesStatFields(dataSitesStat);
                renderSitesTable();
                $loadingTable.hide();
            },
            error: function(req,status,err) {
                console.log("Error " + req,status,err);
                $loadingTable.hide();
            }
        });

    }
    
    // Отрисовка сводной таблицы
    function renderSummaryReport() {
        //console.log('AAA renderSummaryReport = ', dataSummaryReport);
        
        if (!dataSummaryReport || dataSummaryReport.length==0)
        {
            $('.b-content__no-data').show();
            $('#summary-report-table').hide();
        }
        else
        {
            $('.b-content__no-data').hide();
            $('#summary-report-table').show();
        }
        
        var domains = selectedDomainsAll().domains;
        var reportData = {
            hits: {
                today: 0,
                yesterday: 0,
                '30days': 0,
                cur_month: 0,
                prev_month: 0                
            },
            money: {
                today: 0.00,
                yesterday: 0.00,
                '30days': 0.00,
                cur_month: 0.00,
                prev_month: 0.00
            },
            return: {
                today: 0.00,
                yesterday: 0.00,
                '30days': 0.00,
                cur_month: 0.00,
                prev_month: 0.00
            },
            income: {
                today: 0.00,
                yesterday: 0.00,
                '30days': 0.00,
                cur_month: 0.00,
                prev_month: 0.00
            }
        };                             
        
        // Проверяем наличие ненулевых block_hits:
        //console.log('AAA renderSummaryReport data = ', dataSummaryReport);
        var isBlockHits = false;
        _.each(dataSummaryReport, function(range){
            if (parseInt(range['block_hits']) > 0)
            {
                isBlockHits = true;
            }
        });
        var $summaryTable = $(selectorSummaryReport);
        var currencySymbol = ' ' + $('.b-content__site-currency .droplist-current').data('symbol');
        
        if (isBlockHits)
        {
            reportData.block_hits = {
                today: 0.00,
                yesterday: 0.00,
                '30days': 0.00,
                cur_month: 0.00,
                prev_month: 0.00
            };
            reportData.block_money = {
                today: 0.00,
                yesterday: 0.00,
                '30days': 0.00,
                cur_month: 0.00,
                prev_month: 0.00
            };
            reportData.total = {
                today: 0.00,
                yesterday: 0.00,
                '30days': 0.00,
                cur_month: 0.00,
                prev_month: 0.00
            };
            
            $summaryTable.removeClass('short').addClass('full');
        }
        else
        {
            $summaryTable.removeClass('full').addClass('short');
        }
        
        
        if(domains && dataSummaryReport) {
            for(var periodKey in dataSummaryReport) {               
                if(!reportData.hits[periodKey]) {
                    reportData.hits[periodKey] = 0;
                }
                if(!reportData.money[periodKey]) {
                    reportData.money[periodKey] = 0;
                }
                
                            
                if(dataSummaryReport[periodKey].hits) {
                    reportData.hits[periodKey] = dataSummaryReport[periodKey].hits;
                }
                if(dataSummaryReport[periodKey].money) {
                    reportData.money[periodKey] = dataSummaryReport[periodKey].money;
                }


                if (isBlockHits)
                {
                    if(!reportData.block_hits[periodKey]) {
                        reportData.block_hits[periodKey] = 0;
                    }
                    if(!reportData.block_money[periodKey]) {
                        reportData.block_money[periodKey] = 0;
                    }
                    if(!reportData.total[periodKey]) {
                        reportData.total[periodKey] = 0;
                    }
                    
                    if(dataSummaryReport[periodKey].block_hits) {
                        reportData.block_hits[periodKey] = dataSummaryReport[periodKey].block_hits;
                    }
                    if(dataSummaryReport[periodKey].block_money) {
                        reportData.block_money[periodKey] = dataSummaryReport[periodKey].block_money;
                        if (dataSummaryReport[periodKey].income)
                        {
                            reportData.total[periodKey] = dataSummaryReport[periodKey].income + dataSummaryReport[periodKey].block_money;
                        }
                        else
                        {
                            // Временно скрываем
                            //reportData.total[periodKey] = dataSummaryReport[periodKey].money - dataSummaryReport[periodKey].block_money;
                            reportData.total[periodKey] = dataSummaryReport[periodKey].money;
                        }
                        
                    }
                }
                
                
                if (dataSummaryReport[periodKey].income)
                {
                    if(!reportData.income[periodKey]) {
                        reportData.income[periodKey] = 0;
                    }
                    if(!reportData.return[periodKey]) {
                        reportData.return[periodKey] = 0;
                    }
                    reportData.income[periodKey] = dataSummaryReport[periodKey].income;
                    if (isBlockHits) {
                        reportData.return[periodKey] = dataSummaryReport[periodKey].income + dataSummaryReport[periodKey].block_money;
                    } else {
                        reportData.return[periodKey] = dataSummaryReport[periodKey].income;
                    }
                    
                }
                
            }
        }     
        
        var $tableData = $('<table>').html($(selectorSummaryReport).html());
        for(var type in reportData) {
            for(var period in reportData[type]) {
                var key = '#summary-' + period + '-' + type;
                var value = reportData[type][period];
                if(type == 'hits') {
                    value = value.formatMoney(0);                                    
                }
                if(type == 'block_hits') {
                    value = value.formatMoney(0);                                    
                }
                if(type == 'money') {
                    value = value.formatMoney(2) + currencySymbol;                                    
                }
                if(type == 'income') {
                    value = value.formatMoney(2) + currencySymbol;
                }
                if(type == 'block_money') {
                    if ($(selectorSummaryReport).hasClass('user'))
                    {
                        value = -value;
                    }
                    value = value.formatMoney(2) + currencySymbol;
                }
                if(type == 'total') {
                    value = value.formatMoney(2) + currencySymbol;
                }
                if(type == 'return') {
                    value = value.formatMoney(2) + currencySymbol;
                }
                $tableData.find(key).html(value);
            }
        }

        $(selectorSummaryReport).html($tableData.html());        
    }
    
    // Отрисовка графика
    function renderLineChart() {
        //console.log('AAA dataLineChart: ', dataLineChart);
        if(dataLineChart) {
            
            // Выбираем набор переключалок графиков для отображения
            // Проверяем наличие ненулевых block_hits:
            var isBlockHits = false;
            var $fullSwitchBlock = $('.b-filter__switch.display.full');
            var $shortSwitchBlock = $('.b-filter__switch.display.short');
            
            _.each(dataLineChart.block_hits, function(item){
                if (parseInt(item) > 0) {
                    isBlockHits = true;
                }
            });
            
            // Показываем список переключалок
            if (isBlockHits)
            {
                $fullSwitchBlock.addClass('current');
                $shortSwitchBlock.removeClass('current');
                $fullSwitchBlock.show();
                $shortSwitchBlock.hide();
            }
            else
            {
                $fullSwitchBlock.removeClass('current');
                $shortSwitchBlock.addClass('current');
                $fullSwitchBlock.hide();
                $shortSwitchBlock.show();
            }
            
            // Отрисовываем график библиотекой c3.js
            var dataName = $('.b-filter__switch.display.current .b-filter__switch-item.m-filter__switch-item_active').html();
            var activeLine = $('.b-filter__switch.display.current .b-filter__switch-item.m-filter__switch-item_active').data('filter-category');
            var currencySymbol = ' ' + $('.b-content__site-currency .droplist-current').data('symbol');
            //console.log('AAA activeLine: ', activeLine);
            
            var dataColumns = [
                ['x'].concat(dataLineChart['period']),
                ['data1'].concat(dataLineChart[activeLine]),
            ];
            var dataNames = {
                data1: dataName
            }
            var colors = {
                data1: '#2ca02c',
                data2: '#ff0000'
            };
            
            var valueFormat = function (value, ratio, id) {
                var currencyFields = ['money', 'block_money', 'total', 'return'];
                var isCurrencyValue = currencyFields.indexOf(activeLine) >=0;
                var format = (isCurrencyValue) ? d3.format(',.2f') : d3.format(',');
                return (isCurrencyValue) ? format(value) + currencySymbol : format(value);
            };
            axisY1format = function (d) {
                var currencyFields = ['money', 'block_money', 'total', 'return'];
                var isCurrencyValue = currencyFields.indexOf(activeLine) >=0;
                var format = (isCurrencyValue) ? d3.format(',.0f') : d3.format(',');
                return (isCurrencyValue) ? format(d) + currencySymbol : format(d);
            }
            var axisY2format = function (d) {
                return d;
            }
            var paddingAxisX = {left: 0};
            
            /*
            var onShow = function(){};
            var labelY = '';
            var labelY2 = '';
            */
            var showLegend = false;
            var y2Show = false;
            
            if (activeLine == 'common_hits') {
                dataColumns = [
                    ['x'].concat(dataLineChart['period']),
                    ['data1'].concat(dataLineChart['hits']),
                    ['data2'].concat(dataLineChart['block_hits'])
                ];
                dataNames = {
                    data1: 'Показы RTB',
                    data2: 'Показы блоков'
                };
                showLegend = true;
            } else if (activeLine == 'common_money') {
                dataColumns = [
                    ['x'].concat(dataLineChart['period']),
                    ['data1'].concat(dataLineChart['money']),
                    ['data2'].concat(dataLineChart['block_money'])
                ];
                dataNames = {
                    data1: 'Доход RTB',
                    data2: 'Сумма за блоки'
                }
                showLegend = true;
            } else if (activeLine == 'blocks') {
                dataColumns = [
                    ['x'].concat(dataLineChart['period']),
                    ['data1'].concat(dataLineChart['block_hits']),
                    ['data2'].concat(dataLineChart['block_money'])
                ];
                dataNames = {
                    data1: 'Показы блоков',
                    data2: 'Сумма за блоки'
                };
                colors = {
                    data1: '#2ca02c',
                    data2: '#ff0000'
                };
                y2Show = true;
                paddingAxisX = {left: 0, right: 0};
                axisY1format = function (d) {
                    var format = d3.format(',');
                    return format(d);
                }
                axisY2format = function (d) { return d + currencySymbol; }
                showLegend = true;
                /*
                labelY = 'Показы блоков';
                labelY2 = 'Сумма за блоки';
                */
                valueFormat = function (value, ratio, id) {
                    if (id == 'data1')
                    {
                        var format = d3.format(',');
                        return format(value);
                    }
                    else
                    {
                        var format = d3.format(',.2f');
                        return format(value) + currencySymbol;
                    }
                };
                /*
                onShow = function () {
                    $('.c3-axis-y-label').attr('stroke', '#2ca02c');
                    $('.c3-axis-y2-label').attr('stroke', '#ff0000');
                    $('.c3-axis-y-label, .c3-axis-y2-label').attr('font-size', '12px');
                };
                */
            } else if (activeLine == 'rtb') {
                dataColumns = [
                    ['x'].concat(dataLineChart['period']),
                    ['data1'].concat(dataLineChart['hits']),
                    ['data2'].concat(dataLineChart['money']),
                    ['data3'].concat(dataLineChart['income'])
                ];
                dataNames = {
                    data1: 'Показы RTB',
                    data2: 'Сайт',
                    data3: 'Система'
                };
                colors = {
                    data1: '#1F77B4',
                    data2: '#ff0000',
                    data3: '#2ca02c'
                };
                showLegend = true;
                paddingAxisX = {left: 0, right: 0};
                y2Show = true;
                axisY1format = function (d) {
                    var format = d3.format(',');
                    return format(d);
                }
                axisY2format = function (d) { return d + currencySymbol; }
                /*
                labelY = 'Показы RTB';
                labelY2 = 'Доход RTB';
                */
                valueFormat = function (value, ratio, id) {
                    if (id == 'data1')
                    {
                        var format = d3.format(',');
                        return format(value);
                    }
                    else
                    {
                        var format = d3.format(',.2f');
                        return format(value) + currencySymbol;
                    }
                };
                /*
                onShow = function () {
                    $('.c3-axis-y-label').attr('stroke', '#ff0000');
                    $('.c3-axis-y2-label').attr('stroke', '#2ca02c');
                    $('.c3-axis-y-label, .c3-axis-y2-label').attr('font-size', '12px');
                };
                */
            } else if (activeLine == 'common_total') {
                
                var dataHits = [];
                dataLineChart['hits'].forEach(function(item, i) {
                    dataHits.push(dataLineChart['hits'][i] + dataLineChart['block_hits'][i])
                });
                
                dataColumns = [
                    ['x'].concat(dataLineChart['period']),
                    ['data1'].concat(dataLineChart['total']),
                    ['data2'].concat(dataHits)
                ];
                dataNames = {
                    data1: 'Итого',
                    data2: 'Показы'
                };
                colors = {
                    data1: '#2ca02c',
                    data2: '#ff0000'
                };
                y2Show = true;
                paddingAxisX = {left: 0, right: 0};
                axisY1format = function (d) { return d + currencySymbol; }
                axisY2format = function (d) {
                    var format = d3.format(',');
                    return format(d);
                }
                showLegend = true;
                valueFormat = function (value, ratio, id) {
                    if (id == 'data1')
                    {
                        var format = d3.format(',.2f');
                        return format(value) + currencySymbol;
                    }
                    else
                    {
                        var format = d3.format(',');
                        return format(value);
                    }
                };
            } else {
                dataColumns = [
                    ['x'].concat(dataLineChart['period']),
                    ['data1'].concat(dataLineChart[activeLine]),
                ];
                dataNames = {
                    data1: dataName
                };
            }
            
            
            var chart = c3.generate({
                bindto: '#chart-graph',
                data: {
                    x: 'x',
                    columns: dataColumns,
                    names: dataNames,
                    types: {
                        data1: 'area-spline',
                        data2: 'area-spline',
                        data3: 'area-spline'
                    },
                    colors: colors,
                    axes: {
                        data1: 'y',
                        data2: 'y2',
                        data3: 'y2'
                    }
                    //type: 'spline',
                    //labels: true
                },
                axis: {
                    x: {
                        type : 'timeseries',
                        padding: paddingAxisX,
                        tick: {
                            culling: {max: 31},
                            //format: function (x) { return x.getDate(); }
                            format: '%d'
                        }
                    },
                    y: {
                        min: 0,
                        padding: {top: 50, bottom: 0},
                        tick: {
                            format: axisY1format
                        },
                        /*
                        label: {
                            text: labelY,
                            position: 'outer-middle'
                        }
                        */
                    },
                    y2: {
                        //min: 0,
                        padding: {top: 150, bottom: 0},
                        tick: {
                            format: axisY2format
                        },
                        /*
                        label: {
                            text: labelY2,
                            position: 'outer-middle',
                        },
                        */
                        show: y2Show
                    }
                },
                grid: {
                    x: {show: true},
                    y: {show: true},
                },
                tooltip: {
                    format: {
                        title: function (d) {
                            return formatDate(d);
                        },
                        value: valueFormat
                    }
                },
                legend: {
                    show: showLegend
                },
                //color: {pattern: ['#2ca02c']}
            });
            
            //onShow();
            
            
            $('#b-content__traffic-chart').show();
        } else {
            $('#b-content__traffic-chart').hide();
        }       
    }   
    
    // Отрисовка месячной таблицы
    function renderLineTable() {
        //console.log('AAA renderLineTable ', dataLineChart);
        if(dataLineChart) {
            
            // Проверяем наличие ненулевых block_hits:
            var isBlockHits = false;
            _.each(dataLineChart.block_hits, function(item){
                if (parseInt(item) > 0)
                {
                    isBlockHits = true;
                }
            });
            
            var $table = $('#table-line');
            var currencySymbol = ' ' + $('.b-content__site-currency .droplist-current').data('symbol');
            
            var $tableContent = $('<tbody>');
            var $tableBody = $table.find('tbody').first();
            var $tableFooter = $table.find('tfoot').first();
            
            var summ_views = 0;
            var summ_income = 0;
            var summ_incomeIncome = 0;
            var summ_blockHits = 0;
            var summ_blockMoney = 0;
            var summ_return = 0;
            var summ_total = 0;
            
            
            for(var i = dataLineChart['period'].length-1; i>=0; i-=1) {
                var date = dataLineChart['period'][i];
                var views = dataLineChart['hits'][i];
                var income = dataLineChart['money'][i];
                
                var blockHits = dataLineChart['block_hits'][i];
                var blockMoney = dataLineChart['block_money'][i];
                                
                summ_views += views;
                summ_income += income;
                
                summ_blockHits += blockHits;
                summ_blockMoney += blockMoney;
                
                if (dataLineChart.income) {
                    var total = dataLineChart['income'][i] + dataLineChart['block_money'][i];
                } else {
                    var total = dataLineChart['money'][i] - dataLineChart['block_money'][i];
                }

                summ_total += total;
                
                if (dataLineChart.income) {
                    var incomeIncome = dataLineChart['income'][i];
                    var incomeReturn = dataLineChart['return'][i];
                    summ_incomeIncome += incomeIncome;
                    summ_return += incomeReturn;
                }
                
                $row = $('<tr>');
                
                $row.append($('<td>').html(date));
                
                $row.append($('<td class="block-info">').html(blockHits.formatMoney(0)));
                
                if (dataLineChart.income) {
                    $row.append($('<td class="block-info block_money">').html(blockMoney.formatMoney(2) + currencySymbol));
                } else {
                    $row.append($('<td class="block-info block_money">').html((-blockMoney).formatMoney(2) + currencySymbol));
                }
                
                $row.append($('<td>').html(views.formatMoney(0)));
                $row.append($('<td class="money">').html(income.formatMoney(2) + currencySymbol));
                
                if (dataLineChart.income) {
                    $row.append($('<td class="income">').html(incomeIncome.formatMoney(2) + currencySymbol));
                    $row.append($('<td>').html(incomeReturn.formatMoney(2) + currencySymbol));
                }
                
                $row.append($('<td class="block-info total">').html(total.formatMoney(2) + currencySymbol));
                
                $row.appendTo($tableContent);
                
            }           
            
            $tableBody.html('').append($tableContent.children());
            $tableFooter.find('.summ-views').html(summ_views.formatMoney(0));
            $tableFooter.find('.summ-income').html(summ_income.formatMoney(2) + currencySymbol);
            $tableFooter.find('.summ-income-income').html(summ_incomeIncome.formatMoney(2) + currencySymbol);

            $tableFooter.find('.summ-block_hits').html(summ_blockHits.formatMoney(0));
            if (dataLineChart.income) {
                $tableFooter.find('.summ-block_money').html(summ_blockMoney.formatMoney(2) + currencySymbol);
            } else {
                $tableFooter.find('.summ-block_money').html((-summ_blockMoney).formatMoney(2) + currencySymbol);
            }
            $tableFooter.find('.summ-return').html(summ_return.formatMoney(2) + currencySymbol);
            $tableFooter.find('.summ-total').html(summ_total.formatMoney(2) + currencySymbol);
            
            var $lineTable = $('#table-line');
            if (isBlockHits)
            {
                $lineTable.removeClass('short').addClass('full');
            }
            else
            {
                $lineTable.removeClass('full').addClass('short');
            }
            
            $('#b-content__traffic-table').show();            
        } else {
            $('#b-content__traffic-table').hide();
        }     
    }
    
    // Отрисовка таблицы по сайтам
    function renderSitesTable() {
        
        return false;
        
        if (dataSitesStat) {
            
            var
                $table = $('#table-sites'),
                $tableContent = $('<tbody>', $table),
                $tableBody = $table.find('tbody').first(),
                currencySymbol = ' ' + $('.b-content__site-currency .droplist-current').data('symbol'),
                activeSort = $('.time-table-sort .m-filter__switch-item_active').data('sort-category');
            
            // Сортируем данные по названию/доходу
            //console.log('AAA activeSort ', activeSort);
            dataSitesStat = _.sortBy(dataSitesStat, function(num){ return (activeSort == 'name') ? num.site : -num.money; });
            
            for(var i = 0; i<dataSitesStat.length; i++) {
                
                var
                    site = dataSitesStat[i]['site'],
                    views = dataSitesStat[i]['hits'],
                    income = dataSitesStat[i]['money'],
                    blockHits =dataSitesStat[i]['block_hits'],
                    blockMoney = dataSitesStat[i]['block_money'],
                    total = dataSitesStat[i]['total'],
                    incomeIncome = (dataSitesStat[i]['income']) ? dataSitesStat[i]['income'] : 0,
                    incomeReturn = dataSitesStat[i]['return'];
                
                $row = $('<tr>');
                $row.append($('<td>').html(site));
                $row.append($('<td class="block-info">').html(blockHits.formatMoney(0)));
                $row.append($('<td class="block-info block_money">').html(blockMoney.formatMoney(2) + currencySymbol));
                $row.append($('<td>').html(views.formatMoney(0)));
                $row.append($('<td class="money">').html(income.formatMoney(2) + currencySymbol));
                $row.append($('<td class="income">').html(incomeIncome.formatMoney(2) + currencySymbol));
                $row.append($('<td>').html(incomeReturn.formatMoney(2) + currencySymbol));
                $row.append($('<td class="block-info total">').html(total.formatMoney(2) + currencySymbol));
                $row.appendTo($tableContent);
            }           
            
            $tableBody.html('').append($tableContent.children());
        }
    }
    
    // Добавление информационных полей в данных
    function addDataFields(data)
    {
        // Добавляем в данных поля для админа:
        if (data && data.income) {
            // total (Итого)
            if (data.block_hits)
            {
                data.total = [];
                data.block_hits.forEach(function(item, i) {
                    data.total.push(data.income[i] + data.block_money[i])
                });
            }
            
            // return (Оборот)
            data.return = [];
            data.income.forEach(function(item, i) {
                data.return.push(data.income[i] + data.money[i] + data.block_money[i])
            });
        // Добавляем в данных поля для user:    
        } else {
            // total (Итого)
            
            // Временно скрываем
            data.block_hits.forEach(function(item, i) {
                data.block_hits[i] = 0;
            });
            data.block_money.forEach(function(item, i) {
                data.block_money[i] = 0;
            });
            
            if (data && data.block_hits)
            {
                data.total = [];
                data.block_hits.forEach(function(item, i) {
                    data.total.push(data.money[i] - data.block_money[i])
                });
            }
            
        }
    }

    // Добавление информационных полей в данных для  статистики сайтов
    function addDataSitesStatFields(data)
    {
        data.forEach(function(item) {
            item.total = item.income + item.block_money;
            item.return = item.income + item.money + item.block_money;
        });
    }

    
    //renderSummaryReport();
    renderLineChart();
    
    $(selectorSummaryReport).on('render-summary-report', function(){
        loadDataSummuryReport();        
    });
    $domainsList.on('select-domain', function(){
        loadDataSummuryReport();        
        loadDataLineChart();
        loadDataSitesStat();
    });       
    
    $(selectorGraphChart).on('render-chart', function(){
        renderLineChart();
    });
    
    $(selectorGraphChart).on('reload-chart', function(){
        //console.log('AAA выбор периода:');
        loadDataLineChart();        
        loadDataSitesStat();
    });
    
    
    // Клик на "Все сайты":
    $('.all-domains').click(function(){
        var $all = $('li.droplist-item[data-id="all"]');
        $all.click();
        return false;
    });
    
    
    
    // Запрос списка поддоменов:
    var linkGetSubdomainsList = '/statistics/';
    
    function getSubdomainsList($sub, id)
    {
        if( $.trim($sub.text()) == "" ) { // Проверка был ли ранее запрошен домен
            //$loadingAll.show();
            $.ajax(linkGetSubdomainsList, {
                method: 'POST',
                data: {
                    action: 'subdomains',
                    domain: id
                },
                success: function(res){
                    if (res && res.length > 0) {
                        $sub.append(templateSubdomainsItems({data: res}));
                    } else {
                        //$sub.append('<div>Данных по этому домену в системе нет</div>');
                    }
                    //$loadingAll.hide();
                },
                error: function(req,status,err) {
                    console.log("Error ");
                    //$loadingAll.hide();
                }
            });
        }
    }
    
    
    /*
        Фильтры сайтов
    */
    var $filtersWrapp = $('.wrapp.filters');
    
    // Инициируем запрос статистики по всем сайтам:
    $('.all-domains').click();
    $('#b-content__traffic-chart').show();
    
    // Выбор фильтра (страна, сегмент, менеджер)
    if ($filtersWrapp.length)
    {
        // Формируем список фильтров
        var filters = [];
        $('.user-filter option', $filtersWrapp).each(function(){
            var $this = $(this);
            if ($this.attr('value') != '')
            {
                filters.push($this.attr('value'));
            }
        });
        
        var $patternsBlock = $('.wrapp.filters .patterns');
        
        // Кнопка "Добавить фильтр"
        $('.add-filter').on('click', function(){
            var $activeFilters = $('.wrapp.filters > .filter');
            $activeFilters.each(function(){
                var nameFilter = $('.user-filter', $(this)).val();
                // Удаляем фильтр, если для него не выставлено значение
                if (nameFilter == '') {
                    $(this).remove();
                }
                // Отсеиваем установленный фильтр из массива
                var ind = filters.indexOf(nameFilter)
                if (ind >=0) {
                    filters.splice(ind,1);
                }
            });

            // Если все фильры использованы, то новые не добавляем
            if (filters.length == 0) {
                return false;
            }

            // Добавляем новый фильтр
            var $filtersBlock = $('.filter', $patternsBlock).clone();
            $patternsBlock.after($filtersBlock);

            // Скрываем уже включенные фильтры
            $('option', $filtersBlock).each(function(){
               var valueFilter = $(this).val();
               if (valueFilter != '' && filters.indexOf(valueFilter)<0) {
                   $(this).hide();
               }
            });
            return false;
        });
        
        // Выбор названия фильтра
        $filtersWrapp.on('change', '.user-filter', function() {
            var
                $this = $(this),
                $wrap = $this.parents('.filter'),
                filterName = $this.val(),
                $filterValues,
                $deleteFilter;
            
            function removeAllFilters()
            {
                $('.form-group.country', $wrap).remove();
                $('.form-group.segment', $wrap).remove();
                $('.form-group.manager', $wrap).remove();
                $('.delete-filter', $wrap).remove();
            }
            
            if (filterName == '')
            {
                removeAllFilters();
            }
            else
            {
                removeAllFilters();
                $filterValues = $('.form-group.' + filterName, $patternsBlock).clone(),
                $deleteFilter = $('.delete-filter', $patternsBlock).clone();
                $wrap.append($filterValues);
                $wrap.append($deleteFilter);
            }
              
        });
        
        // Выбор значения фильтра
        $filtersWrapp.on('change', '.form-control:not(.user-filter)', function() {
            var $wrap = $(this).parents('.filter');
            $('.delete-filter', $wrap).show();
            selectActiveFilters();
            $domainsList.trigger('select-domain');
        });
        
        // Удаление фильтра
        $filtersWrapp.on('click', '.delete-filter', function() {
            var $wrap = $(this).parents('.filter');
            $wrap.remove();
            filters.push($('.user-filter', $wrap).val());
            selectActiveFilters();
            $domainsList.trigger('select-domain');
        });
        
        
        // Устанавливаем фильтр менеджера:
        if(window.location.hash) {
           
            var
                managerId = getHashValue('manager'),
                siteId = getHashValue('site');
            
            function getHashValue(key) {
                var matches = location.hash.match(new RegExp(key+'=([^&]*)'));
                return matches ? matches[1] : null;
            }
            
            history.replaceState(null, null, window.location.origin + window.location.pathname);

            if (managerId)
            {
                // Добавляем новый фильтр
                $('.add-filter').click();
                $(".form-control.user-filter").val("manager");
                var $wrapper = $('.wrapp.filters > .filter');
                var $filterValues = $('.form-group.manager', $patternsBlock).clone();
                var $deleteFilter = $('.delete-filter', $patternsBlock).clone();
                $wrapper.append($filterValues);
                $wrapper.append($deleteFilter);
                $('.form-control.user-manager').val(managerId);
                $('.delete-filter', $wrapper).show();
                selectActiveFilters();
                $domainsList.trigger('select-domain');
            }
            
            if (siteId)
            {
                // Выбираем сайт
                $('.b-subdomains-list li .main-domain[data-id="' + siteId + '"]').click();
            }
        }
    }
    
    // Определение сайтов по фильтрам
    function selectActiveFilters()
    {
        if ($filtersWrapp.length == 0) {
            return false;
        }
        
        // Формируем список фильтров по установленным значениям
        var activeFilters = [];
        $('.filter', $filtersWrapp).each(function(){
            var
                $this = $(this),
                name = $('.user-filter', $this).val();    
            
            if (name != '') {
                var value = $('.user-' + name, $this).val();
                activeFilters[name] = value;
            }
        });
        //console.log('AAA activeFilters = ', activeFilters);
        
        // Соответствие с установленными фильтрами
        function isEqualFilters($this, activeFilters)
        {
            var
                isEqualSegment = true,
                isEqualCountry = true,
                isEqualManager = true;
        
            if (activeFilters['segment'] && activeFilters['segment'] != '') {
                isEqualSegment = ($this.data('segment') == activeFilters['segment']) ? true : false;
            }
            
            if (activeFilters['country'] && activeFilters['country'] != '') {
                isEqualCountry = ($this.data('country') == activeFilters['country']) ? true : false;
            }
            
            if (activeFilters['manager'] && activeFilters['manager'] != '') {
                isEqualManager = ($this.data('manager') == activeFilters['manager']) ? true : false;
            }
            
            return isEqualSegment && isEqualCountry && isEqualManager;
        }
        
        // Скрываем показ сайтов в списках в соответствии с установленными фильтрами activeFilters
        // Выпадающий список
        $('.b-content__site-droplits li').each(function(){
            
            var
                $this = $(this),
                isCorrespondFilters = isEqualFilters($this, activeFilters);
            
            if (isCorrespondFilters) {
                $this.show();
            } else {
                $this.hide();
            }
            
            // Показываем пункт "Все"
            if ($this.data('id') == 'all') {
                $this.show();
            }
        });
        
        // Основной список
        $('ul#domains-list').children('li').each(function(){
            var
                $this = $('a', $(this)),
                $li = $this.parent(),
                isCorrespondFilters = isEqualFilters($this, activeFilters);
            
            if (isCorrespondFilters) {
                $li.show();
                $this.addClass('domain-selected')
            } else {
                $li.hide();
                $this.removeClass('domain-selected')
            }
        });
        
    }
    
    
    /*
        Валюта отображения
    */
    var
        $currentMoney = $('.input.currency').find('.droplist-current'),
        $currentMoneyInput = $('.input.currency').find('.input__field'),
        $dropMoneyList = $('.input.currency').find('.droplist-block'),
        $listItems = $dropMoneyList.find('.droplist-item');
    
    // Открытие-закрытие списка валют
    $currentMoney.on('click', function(e, t){
        var $this = $(this);
        if($dropMoneyList.hasClass('m-open-droplist')) {
            $this.removeClass('m-open-droplist');
            $dropMoneyList.removeClass('m-open-droplist');
        } else {
            $this.addClass('m-open-droplist');
            $dropMoneyList.addClass('m-open-droplist');
        }
        e.stopPropagation();
        return false;
    });
    
    // Выбор валюты в списке
    $listItems.on('click', function(e, t){
        var
            $this = $(this),
            selectId = $(this).data('id'),
            selectStr = $(this).html();

        $currentMoney.html(selectStr);
        $currentMoneyInput.val(selectId);
        $currentMoney.removeClass('m-open-droplist');
        $dropMoneyList.removeClass('m-open-droplist');
        
        var form = $(this).parents('form')[0];
        var formData = new FormData(form);
        
        $loadingAll.show();
        
        $.ajax({
            url: $(form).attr("data-url"),
            type: "POST",
            contentType: false,
            processData: false,
            data: formData,
            successUrl: form.getAttribute("data-url-success"),
            fadePanel: $this,
            success: function(data) {
                if (data.result) {
                    console.log(data);
                    setTimeout(function(){
                        document.location.reload();
                    }, 1000);                        
                } else {
                    console.log(data);
                }
            },
            error: function (e) {
                console.log('error: ', e);
            }
        });
        
        return false;
    });                     
    
    
    
    // Шаблон списка поддоменов
    var templateSubdomainsItems = _.template('\n'+
    '    <% _.each(data, function(item) { %>   \n' +
    '       <li><a class="sub-domain" data-domain="<%=item %>" href="#"><%=item %></a></li>\n' +
    '    <% }) %>  \n' +
    '');
    
});