<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Entity\Feeds;

use App\Entity\Common;


/**
 * Class Category
 * @package App\Entity
 */
class Category extends Common
{
    
    /**
     * @return mixed
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * @param mixed $title
     * @return Category
     */
    
    public function setTitle($title)
    {
        $this->title = $title;
        return $this;
    }
    
    /**
     * @return mixed
     */
    public function getParentid(): int
    {
        return $this->parentid;
    }

    /**
     * @param mixed $parent_id
     * @return Category
     */
    
    public function setParentid($parent_id)
    {
        $this->parentid = $parent_id;
        return $this;
    }
    
    /**
     * @return mixed
     */
    public function getForeignid(): int
    {
        //return $this->foreignid;
        return ($this->foreignid) ? $this->foreignid : 0; // временно для обработки случая ForeignID = ""
    }

    /**
     * @param mixed $foreign_id
     * @return Category
     */
    
    public function setForeignid($foreign_id)
    {
        $this->foreignid = $foreign_id;
        return $this;
    }
    
    /**
     * @return mixed
     */
    public function getOrderpercent(): int
    {
        return $this->orderpercent;
    }

    /**
     * @param mixed $order_percent
     * @return Category
     */
    
    public function setOrderpercent($order_percent)
    {
        $this->orderpercent = $order_percent;
        return $this;
    }

}