<?php
/**
 * Copyright (c) 2017 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Entity;


/**
 * Class Contacts
 * @package App\Entity
 */
class Contacts extends Common
{

    const MAILS_KEY = 'mails';
    const PHONES_KEY = 'phones';
    const SKYPES_KEY = 'skypes';

    /**
     * @var array
     */
    protected $phones;
    /**
     * @var array
     */
    protected $mails;
    /**
     * @var array
     */
    protected $skypes;

    /**
     * @return array
     */
    public function getPhones()
    {
        return $this->phones;
    }

    /**
     * @param array $phones
     * @return Contacts
     */
    public function setPhones(array $phones)
    {
        $this->phones = $phones;
        return $this;
    }

    /**
     * @return array
     */
    public function getMails()
    {
        return $this->mails;
    }

    /**
     * @param array $mails
     * @return Contacts
     */
    public function setMails(array $mails)
    {
        $this->mails = $mails;
        return $this;
    }

    /**
     * @return array
     */
    public function getSkypes()
    {
        return $this->skypes;
    }

    /**
     * @param array $skypes
     * @return Contacts
     */
    public function setSkypes(array $skypes)
    {
        $this->skypes = $skypes;
        return $this;
    }

    /**
     * @return array
     */
    public function toArray()
    {
        return [
            self::PHONES_KEY => $this->getPhones(),
            self::MAILS_KEY => $this->getMails(),
            self::SKYPES_KEY => $this->getSkypes()
        ];
    }

    /**
     * @return array
     */
    public function toArrayForConfig()
    {
        return [
            '\\' . self::class . '::PHONES_KEY' => $this->getPhones(),
            '\\' . self::class . '::MAILS_KEY' => $this->getMails(),
            '\\' . self::class . '::SKYPES_KEY' => $this->getSkypes()
        ];
    }
}