class ValuesItem extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            value: this.props.data,
            options:  this.props.options
        };
        this.onInputChange = this.onInputChange.bind(this);
    };
    onInputChange(e){
        this.setState({value: e.target.value});
        this.props.editValue(this.props.index, e.target.value);
    };
    remove = () => {
        this.props.deleteValue(this.props.index);
    };
    renderInput() {
        const {value} = this.state;
        return (
            <input type="text" className="form-control" onChange={this.onInputChange} value={value} />
        );
    };
    eachOption = (item, i) => {
        if (item == '__rtb__') {
            return (
                <option key={i} value={item} style={{fontWeight: 'bold'}}>RTB</option>
            );
        }
        
        return (
            <option key={i} value={item}>{item}</option>
        );
    };
    renderSelect() {
        
        if (this.props.name_temp == 'zones') {
            console.log('AAA ------------ renderSelect ValuesItem ', this.props.options);
        }
        
        const {value, options} = this.state;
        return (
            <select className="form-control" value={value} name="main" onChange={this.onInputChange}>
                <option value="null">Выберите значение</option>
                {options.map(this.eachOption)}
            </select>
        );
    };
    componentWillReceiveProps = (newProps) => {
        this.state.options = newProps.options;
    };
    render() {
        return (
            <div className="input-item">
                {(this.state.options) ? this.renderSelect() : this.renderInput()}
                &nbsp;
                <div className="delete-input" onClick={this.remove}>&#215;</div>
            </div>
        );
    }
}


class Values extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            data: (this.props.data) ? this.props.data : [],
            options: this.props.options,
            currentData: null,
            edit: false,
        }
    };
    deleteValue = (i) => {
        var valuesList = this.state.data;
        valuesList.splice (i, 1);
        this.setState({data: valuesList});
    };
    editValue = (i, val) => {
        this.state.data[i] = val;
    };
    eachDataStringItem = (val, i) => {
        var title = (val == '__rtb__') ? 'RTB' : val;
        return (
            <span key={i} >{title}</span>
        );
    };
    eachDataInputItem = (val, i) => {
        return (
            <ValuesItem key={val + i} data={val} index={i} name_temp={this.props.name} deleteValue={this.deleteValue} editValue={this.editValue} options={this.state.options} />
        );
    };
    onEdit = (e) => {
        e.preventDefault();
        var currentValues = [];
        for (var i = 0; i < this.state.data.length; i++) {
            currentValues[i] = this.state.data[i];
        }
        this.state.currentData = currentValues;
        this.setState({edit: true});
    };
    onCancel = (e) => {
        e.preventDefault();
        this.state.data = this.state.currentData;
        this.state.currentData = null;
        this.setState({edit: false});
    };
    onSave = (e) => {
        e.preventDefault();
        this.setState({edit: false, currentData: null});
        this.props.onEditValues(this.state.data);
    };
    onAdd = (e) => {
        e.preventDefault();
        var values = this.state.data;
        values.push('');
        this.setState({data: values});
    };
    rendNorm = () => {
        return (
            <div>
                <label htmlFor={this.props.name}>{(this.props.title) ? this.props.title : this.props.name}</label>&nbsp;
                <a className="btn btn-primary edit-item" href="#" onClick={this.onEdit} >Редактировать</a>
                <input className="form-control" type="hidden" id={this.props.name} name={this.props.name} value="" />
                <div className="values-string">
                    {this.state.data.map(this.eachDataStringItem)}
                </div>
            </div>
        );
    };
    rendEdit = () => {
        return (
            <div>
                <label htmlFor={this.props.name}>{(this.props.title) ? this.props.title : this.props.name}</label>&nbsp;
                <input className="form-control" type="hidden" id={this.props.name} name={this.props.name} value="" />
                <div className="values-edit">
                    <div className="values-items">
                        {this.state.data.map(this.eachDataInputItem)}
                    </div>
                    <div className="controls">
                        <div className="temp-state"></div>
                        <a className="btn btn-primary add-item" href="#" onClick={this.onAdd} >Добавить</a>
                        <a className="btn btn-primary cancel-item" href="#" onClick={this.onCancel} >Отмена</a>
                        <a className="btn btn-primary save-item" href="#" onClick={this.onSave} >Сохранить</a>
                    </div>
                </div>
            </div>
        );
    };
    rendEditEmpty = () => {
        return (
            <div>
                <label htmlFor={this.props.name}>{(this.props.title) ? this.props.title : this.props.name}</label>&nbsp;
                <input className="form-control" type="hidden" id={this.props.name} name={this.props.name} value="" />
                <div className="values-edit">
                    <div className="no-values">Нет значений в списке</div>
                    <div className="controls">
                        <div className="temp-state"></div>
                        <a className="btn btn-primary add-item" href="#" onClick={this.onAdd} >Добавить</a>
                        <a className="btn btn-primary cancel-item" href="#" onClick={this.onCancel} >Отмена</a>
                        <a className="btn btn-primary save-item" href="#" onClick={this.onSave} >Сохранить</a>
                    </div>
                </div>
            </div>
        );
    };
    componentWillReceiveProps = (newProps) => {
        this.state.options = newProps.options;
    }
    render() {
        if (this.state.edit) {
            if (this.state.data.length>0) {
                return this.rendEdit ();
            } else {
                return this.rendEditEmpty ();
            }
        } else {
            return this.rendNorm ();
        }
    }
}