$(document).ready(function () {
    "use strict";
    
    var
        $contentWrap = $('.b-content__work'),
        $categoriesWrap = $('.b-categories'),
        $controls = $('.b-controls'),
        $addsWrap = $('.b-data-item.adds'),
        $landingsWrap = $('.b-data-item.landings'),
        $addsLandingsWrap = $('.b-data-item.adds, .b-data-item.landings'),
        $inputImage = $('input#img', $addsWrap),
        addItemSelector = '.ads-list-item',
        landingItemSelector = '.landing-item',
        $actions = $('.b-data-item_action select'),
        $selectItems = $('.b-data-item .items-select'),
        isCreatePage = $('.offer-id').data('id') == 0;

    
    // Покидание страницы:
    window.onbeforeunload = function(e) {
        if (!$controls.hasClass('disabled')) {
            return "Данные не сохранены. Точно перейти?";
        }
    };
    
    // Обработка вкладок Лендинги/Объявления/Заказы/Связки:
    (function(){
        
        var
            $switchItems = $('.b-switch_header li'),
            $switchContentItems = $('.b-switch_item'),
            activeClass = 'active',
            $filtersShow = $('.b-filters__show'),
            $applyFilters = $('.btn.btn-primary.apply'),
            nowDate = new Date(),
            $periodSelect = $('.order-period'),
            datepicker1 = $('#date-value-1').datepicker({
                dateFormat: "yyyy-mm-dd",
                autoClose: true,
                maxDate: nowDate,
                onSelect: function(data){
                    $periodSelect.val('');
                }
            }).data('datepicker'),
            datepicker2 = $('#date-value-2').datepicker({
                dateFormat: "yyyy-mm-dd",
                autoClose: true,
                maxDate: nowDate,
                onSelect: function(data){
                    $periodSelect.val('');
                }
            }).data('datepicker');

        // Переключение вкладок:    
        $switchItems.on('click', function(){
            var
                $this = $(this),
                itemName = $this.data('id');

            if (!$this.hasClass(activeClass)) {
                $switchItems.removeClass(activeClass);
                $this.addClass(activeClass);
                $switchContentItems.hide();
                $('.b-switch_item[data-id="' + itemName + '"]').show();
            }
        });

        // Сортировка в таблицах во вкладках:
        $('.b-data-item.orders .table.orders').sortTable();
        $('.b-data-item.keys .table.adds').sortTable();
        
        // Выбор периода во вкладке заказов:
        $periodSelect.on('change', function(){
            var
                $this = $(this),
                period = $this.val(),
                todayDate = new Date();

            // Установка значений периода в дате:
            switch(period) {
                case 'today':
                    datepicker1.selectDate(todayDate);
                    datepicker2.selectDate(todayDate);
                break;
                case 'yesterday':
                    var yesterdayDate = new Date();
                    yesterdayDate.setDate(yesterdayDate.getDate()-1);
                    datepicker1.selectDate(yesterdayDate);
                    datepicker2.selectDate(yesterdayDate);
                break;
                case '7days':
                    var prev7day = new Date();
                    prev7day.setDate(prev7day.getDate()-7);
                    datepicker1.selectDate(prev7day);
                    datepicker2.selectDate(todayDate);
                break;
                case '30days':
                    var prev30day = new Date();
                    prev30day.setDate(prev30day.getDate()-30);
                    datepicker1.selectDate(prev30day);
                    datepicker2.selectDate(todayDate);
                break;
                case 'current_month':
                    var firstDay = new Date(todayDate.getFullYear(), todayDate.getMonth(), 1);
                    datepicker1.selectDate(firstDay);
                    datepicker2.selectDate(todayDate);
                break;
                case 'prev_month':
                    var firstDay = new Date(todayDate.getFullYear(), todayDate.getMonth()-1, 1);
                    var lastDay = new Date(todayDate.getFullYear(), todayDate.getMonth(), 0);
                    datepicker1.selectDate(firstDay);
                    datepicker2.selectDate(lastDay);
                break;
                case 'year':
                    var firstDay = new Date(todayDate.getFullYear(), 0, 1);
                    datepicker1.selectDate(firstDay);
                    datepicker2.selectDate(todayDate);
                break;
                default:
                    datepicker1.clear();
                    datepicker2.clear();
                break;
            }

            $this.val(period);
            
        });
        
        // Показать фильтры:
        $filtersShow.on('click', function(){
            $('.b-filters__items', $(this).parents('.b-switch_item')).toggle();
        });
        
        // Применить фильтры:
        $applyFilters.on('click', function(){
            console.log('AAA applyFilters');
            var
                $wrap = $(this).parents('.b-switch_item'),
                filters = [],
                $table = $('table.table-striped', $wrap);
                
            // Формируем список фильтров:
            $('.b-filters__list-item', $wrap).each(function(){
                var $select = $('select', $(this));
                if ($select.val()) {
                    filters[$select.attr('name')] = $select.val();
                }
            });
            // Для заказов добавляем фильтр периода если не "все":
            if ($periodSelect.length>0) {
                if (filters['period']) {
                    if (filters['period'] == 'all') {
                        delete filters['period'];
                    } else {
                        var
                            from = new Date(datepicker1.selectedDates[0]),
                            to = new Date(datepicker2.selectedDates[0]);
                    
                        from.setHours(0,0,0,0);
                        to.setHours(23,59,59,0);
                       
                        filters['period'] = [from, to];
                    }
                }
            }
            
            // Выполняем фильтрацию в таблице:
            if (Object.keys(filters).length > 0) {
                $('tbody tr', $table).each(function(){
                    var $tr = $(this),
                        isFiltered = false; // элемент отсеяли
                    
                    $tr.show();
                    
                    Object.keys(filters).forEach(function(item) {
                        if ($tr.data(item)) {
                            if (['geo', 'partner'].indexOf(item) > -1) {
                                if ($tr.data(item) != filters[item]) isFiltered = true;
                            }
                            if (['clicks', 'orders'].indexOf(item) > -1) {
                                if ($tr.data(item) < filters[item]) isFiltered = true;
                            }
                            if (item == 'status') {
                                if (filters[item] == 'leadOrSale') {
                                    if (['lead', 'sale'].indexOf($tr.data(item)) < 0) isFiltered = true;
                                } else if (filters[item] == 'leadOrSaleOrNew') {
                                    if (['lead', 'sale', 'new'].indexOf($tr.data(item)) < 0) isFiltered = true;
                                } else {
                                    if ($tr.data(item) != filters[item]) isFiltered = true;
                                }
                            }
                            if (item == 'period') {
                                var
                                    //todayDate = new Date(),
                                    tdPeriod = new Date($tr.data(item)),
                                    date0, date1;
                                
                                date0 = filters[item][0];
                                date1 = filters[item][1];
                                
                                /*
                                switch(filters[item]) {
                                    case 'today':
                                       date0 = new Date();
                                       date0.setHours(0,0,0,0);
                                       date1 = new Date(); 
                                    break;
                                    case 'yesterday':
                                        date0 = new Date();
                                        date0.setDate(date0.getDate()-1);
                                        date0.setHours(0,0,0,0);
                                        date1 = new Date(); 
                                        date1.setHours(0,0,0,0);
                                    break;
                                    case '7days':
                                        date0 = new Date();
                                        date0.setDate(date0.getDate()-7);
                                        date0.setHours(0,0,0,0);
                                        date1 = new Date(); 
                                    break;
                                    case '30days':
                                        date0 = new Date();
                                        date0.setDate(date0.getDate()-30);
                                        date0.setHours(0,0,0,0);
                                        date1 = new Date(); 
                                    break;
                                    case 'current_month':
                                        date0 = new Date(todayDate.getFullYear(), todayDate.getMonth(), 1);
                                        date1 = new Date(); 
                                    break;
                                    case 'prev_month':
                                        date0 = new Date(todayDate.getFullYear(), todayDate.getMonth()-1, 1);
                                        date1 = new Date(todayDate.getFullYear(), todayDate.getMonth(), 0); 
                                    break;
                                    case 'year':
                                        date0 = new Date(todayDate.getFullYear(), 0, 1);
                                        date1 = new Date(todayDate.getFullYear(), todayDate.getMonth(), 0); 
                                    break;
                                }
                                */
                                
                                if (!(tdPeriod > date0 && tdPeriod < date1)) {
                                    isFiltered = true;
                                }
                                
                            }
                            
                        } else {
                            isFiltered = true;
                        }
                    });
                    
                    if (isFiltered) {
                        $tr.hide();
                    }

                });
            } else {
                $('tbody tr', $table).show();
            }
            
        });

    })();
    
    
    // В данных оффера произвели изменения:
    function MarkOfferAsEdited()
    {
        $controls.removeClass('disabled');
    }
    
    // Обработка списка категорий:
    (function(){
    
        // Добавление категории-подкатегории:
        $categoriesWrap.on('click', '.add-row', function(){
            var
                $addButton = $(this),
                $tplItem = $('.b-pattern.categories .category-item').clone();

            $tplItem.insertBefore($addButton);
            MarkOfferAsEdited();
            return false;
        });

        // Удаление категории-подкатегории:
        $categoriesWrap.on('click', '.delete-category-item', function(){
            $(this).parent().remove();
            MarkOfferAsEdited();
        });
        
        // Изменение значений:
        $categoriesWrap.on('change', 'select', function(){
            
            var $this = $(this);
            
            if ($this.hasClass('offer-category')) {
                var
                    catId = $this.val(),
                    $subcategory = $('.offer-subcategory', $this.parent()),
                    $options = $('option', $subcategory);
                    
                $options.addClass('hidden').prop('selected', false);
                $options.filter('[data-parent="'+ catId +'"]').removeClass('hidden');
            }
            
            MarkOfferAsEdited();
        });

    })();
    
    // Изменение настроек оффера:
    $('.b-data-item.settings').on('change', 'input, select', function(){
       MarkOfferAsEdited();
    });
    
    // Клик на редактируемый элемент:
    $contentWrap.on('click', '.edited', function(){
        var
            $field = $(this),
            fieldName = $field.data('field'),
            $input = $('input.'+fieldName, $field.parent()),
            oldVal = $input.val(),
            oldText = $field.html();
        
        $field.hide();
        $input.off('blur').off('keyup').show().focus();
        
        $input.on('keyup', function(e) {
            
            if (e.keyCode == 13) {
                $input.blur();
            }
            
            if (e.keyCode == 27) {
                $input.off('blur');
                $input.val(oldVal);
                $field.html(oldText);
                $input.hide();
                $field.show();
            }
           
        });
        $input.on('blur', function() {
            
            var
                textInput = $input.val(),
                textField = textInput,
                match, regex;
                
            // подсвечиваем ${text}
            regex = /\$\{([a-zA-Z0-9\-\_]*)\}/g;
            while (match = regex.exec(textInput)){
                textField = textField.replace(match[0], '<b>' + match[0] + '</b>');
            }
            // подсвечиваем $[text]
            regex = /\$\[([a-zA-Z0-9\-\_]*)\]/g;
            while (match = regex.exec(textInput)){
                textField = textField.replace(match[0], '<span>' + match[0] + '</span>');
            }
            
            $input.hide();
            $field.html(textField);
            
            if (textInput != oldVal) {
                $field.parents(addItemSelector).addClass('was-edited');
                $field.parents(landingItemSelector).addClass('was-edited');
                $field.addClass('was-edited');
                MarkOfferAsEdited();
            }
            
            $field.show();
        });
    });
    
    // Фокус на название оффера при создании нового:
    if (isCreatePage) {
        $('.offer-title.edited').click();
        
        $('#offer-create-form').on('submit', function(){
            return false;
        });
    }

    // Обработка выбора и действий с выбранными элементами списков:
    (function(){
    
        // Показ списка действий при клике на галочку-выбор объявления или лендинга:
        $addsLandingsWrap.on('change', 'input.is-active', function(){
            var
                $wrapItem = $(this).parents('.b-data-item'),
                $action = $('.b-data-item_action', $wrapItem);
            $action.show();
        });

        // Отображение элементов списков:
        $selectItems.on('change', function(){
            var
                $this = $(this),
                actionType = $(this).val(),
                $wrapItems = $this.parents('.b-data-item'),
                itemSelector = ($wrapItems.hasClass('adds')) ? '.ads-list-item' : '.landing-item';

            $wrapItems.removeClass('all').removeClass('active').removeClass('disabled');
            $wrapItems.addClass(actionType);
            
            
            if ($wrapItems.hasClass('adds')) {
                $.cookie("list_ads", actionType, { expires : 365 });
            } else {
                $.cookie("list_lands", actionType, { expires : 365 });
            }
            
        });

        // Выбор действия с выделенными элементами:
        $actions.on('change', function(){
            var
                $this = $(this),
                actionType = $(this).val(),
                $wrapItems,
                itemSelector;

            if (actionType) {
                $wrapItems = $this.parents('.b-data-item');
                itemSelector = ($wrapItems.hasClass('adds')) ? '.ads-list-item' : '.landing-item';
                $(itemSelector, $wrapItems).each(function() {
                    var $item = $(this);
                    if ($('input.is-active', $item).is(':checked')) {
                        switch(actionType) {
                            case 'active':
                                $item.removeClass('disabled');
                            break;
                            case 'disable':
                                $item.addClass('disabled');
                            break;
                        }
                        $item.addClass('was-edited');
                    }
                });
                MarkOfferAsEdited();
            }   
        });
        
        // Выставляем списки по кукису:
        var
            startListAdsType = ($.cookie("list_ads")) ? $.cookie("list_ads") : 'active',
            startListLandsType = ($.cookie("list_lands")) ? $.cookie("list_lands") : 'active',
            $adsTypeSelect = $('.b-data-item.adds .items-select'),
            $landsTypeSelect = $('.b-data-item.landings .items-select');
        
        $adsTypeSelect.val(startListAdsType);
        $adsTypeSelect.change();
        $landsTypeSelect.val(startListLandsType);
        $landsTypeSelect.change();

    })();
    
    // Изменения контролов device и partner внутри лендинга
    $landingsWrap.on('change', '.landingdata-item.device input, .landingdata-item.partner select', function(){
        // Не учитываем редактируемые:
        if ($(this).parents('.b-data-item_add-list-place').length==0) {
            $(this).parents(landingItemSelector).addClass('was-edited');
            MarkOfferAsEdited();
        }
    });
    
    // Обработка списков значений для стран у лендингов:
    (function(){

        // Клик на чекбокс добавления страны в выпадающем списке:
        $landingsWrap.on('change', '.dropdown-menu input', function(){
            
            var
                $this = $(this),
                $wrap = $this.parents('.landingdata-item.geo'),
                $valuesString = $('.values-string', $wrap);
            
            if ($this.prop('checked')) {
                $valuesString.append('<span data-id="' + $this.data('code') + '">' + $this.data('title') + '&nbsp;<a href="#" class="close">×</a></span> ');
            } else {
                $('span[data-id="' + $this.data('code') + '"]', $valuesString).remove();
            }
            $this.parents(landingItemSelector).addClass('was-edited');
            MarkOfferAsEdited();
        });
        
        // Клик на X удаления страны из строки:
        $landingsWrap.on('click', '.values-string span .close', function(){
            var
                $this = $(this),
                geoId = $this.parent().data('id'),
                $wrap = $this.parents('.landingdata-item.geo'),
                $geoSelect = $('.dropdown-menu .geo-selected[data-code="' + geoId + '"]', $wrap);
            
            $geoSelect.prop('disabled', false).prop('checked', false);
            $this.parents(landingItemSelector).addClass('was-edited');
            MarkOfferAsEdited();
            $this.parent().remove();
            return false;
        });
        
    })();
    
    // Обработка выбора картинки:
    (function(){
    
        var $currentTarget;
        var downloadCount = 0;
    
        // Клик на картинку:
        $addsWrap.on('click', '.ads-list-item img', function(){
            $currentTarget = $(this);
            $inputImage.click();
        });

        // Выбор картинки:
        $inputImage.on('change', function() {
            var file = $(this)[0].files[0];
            if (!file) {
                return false;
            }
            
            var $imageWrap = $currentTarget.parents('.image-wrap');
            
            $imageWrap.addClass('is-loading');
            if (file.type.match('image.*')) {
                var fileReader = new FileReader();
                fileReader.onload = function(f) {
                    RequestImageResize(
                        function(imgPath){
                            var d = new Date();
                            $currentTarget.attr('src', imgPath + '?' + d.getTime());
                            $currentTarget.show();
                            $imageWrap.removeClass('is-loading').addClass('was-edited');
                            $currentTarget.parents(addItemSelector).addClass('was-edited');
                            MarkOfferAsEdited();
                        },
                        function(dataMsg){
                            $.showMessage('error', dataMsg);
                            $imageWrap.removeClass('is-loading');
                        },
                    );
                };
                fileReader.readAsDataURL(file);
            } else {
                $.showMessage('error', 'Выбранный файл не является изображением!');
                $imageWrap.removeClass('is-loading');
            }
       });
       
        // Запрос для ресайза картинки при её загрузке:
        function RequestImageResize(callback, callbackError)
        {
            var
                $form = $('form#img-resize-form'),
                action = $form.attr('action'),
                method = $form.attr('method'),
                formData = new FormData();

            // Данные картинки:
            var $inputImage = $("input#img");
            if ($inputImage.length>0) {
                formData.append('img', $inputImage.prop('files')[0]);
            }

            if ($currentTarget.parents(addItemSelector).data('id')) {
                formData.append('offer_id', $('.offer-id').data('id') + '_' + $currentTarget.parents(addItemSelector).data('id'));
            } else {
                downloadCount++;
                formData.append('offer_id', $('.offer-id').data('id') + '_n' + downloadCount);
            }
            
            //console.log('AAA RequestImageResize = ', formData);
            $.ajax(action, {
                type: method,
                data: formData,
                cache:false,
                contentType: false,
                processData: false,
                success: function(data) {
                    if(data) {
                        if(data.result === true && data.img_path) {
                            if (callback && $.isFunction(callback)) {
                                callback(data.img_path);
                            }
                        }
                        if(data.result === false && data.msg) {
                            if (callbackError && $.isFunction(callbackError)) {
                                callbackError(data.msg);
                            }
                        }
                    } 
                },
                error: function(rew, status, err) {
                    console.log(status, err);
                    if (callbackError && $.isFunction(callbackError)) {
                        callbackError('Ошибка: ' + rew.responseText);
                    }
                }
            });

            return false;
        }
        
    })();
    
    // Добавление элементов в список объявлений или лендинга:
    (function(){
        
        var $WrapLandingsAdds = $('.b-data-item.landings, .b-data-item.adds');

        // Клик на  "+ Добавить":
        $WrapLandingsAdds.on('click', '.b-data-item_list .add-row.item', function(){
            var
                $addButton = $(this),
                $wrap = $addButton.parents('.b-data-item'),
                $addBlock = $('.b-data-item_add-list', $wrap),
                $addBlockPlace = $('.b-data-item_add-list-place', $wrap),
                isAdds = $wrap.hasClass('adds'),
                $tplItem;
            
            if (isAdds) {
                $tplItem = $('.b-pattern.add .ads-list-item').clone();
            } else {
                $tplItem = $('.b-pattern.landing .landing-item').clone();
                
                // При добавлении лендинга geo и device устанавливаем по предыдущему:
                if ($('.landing-item', $landingsWrap).length > 0) {
                    var
                        $lastLand = $('.landing-item', $landingsWrap).last(),
                        $lastGeo = $('.landingdata-item.geo', $lastLand).clone(),
                        $lastDevice = $('.landingdata-item.device', $lastLand).clone();
                        
                    $('.landingdata-item.geo', $tplItem).empty().append($lastGeo);
                    $('.landingdata-item.device', $tplItem).empty().append($lastDevice);
                }
            }
            
            $addBlockPlace.append($tplItem);
            $addButton.hide();
            $addBlock.show();
            return false;
        });
        
        // Клик на  "Отмена":
        $WrapLandingsAdds.on('click', '.btn.cancel', function(){
            var
                $this = $(this),
                $wrap = $this.parents('.b-data-item'),
                $addButton = $('.add-row.item', $wrap),
                $addBlock = $('.b-data-item_add-list', $wrap),
                $addBlockPlace = $('.b-data-item_add-list-place', $wrap);
            
            $addButton.show();
            $addBlock.hide();
            $addBlockPlace.empty();
            return false;
        });
        
        // Клик на  "Сохранить":
        $WrapLandingsAdds.on('click', '.btn.save-item', function(){
            
            var
                $this = $(this),
                $wrap = $this.parents('.b-data-item'),
                $addBlockPlace = $('.b-data-item_add-list-place', $wrap),
                $addButton = $('.add-row.item', $wrap),
                $addBlock = $('.b-data-item_add-list', $wrap),
                isAdds = $wrap.hasClass('adds'),
                itemSelector = (isAdds) ? '.ads-list-item' : '.landing-item',
                $tplItem,
                isNotValid = false;
            
            $tplItem = $(itemSelector, $addBlockPlace).clone();
            
            if (isAdds) {
                // Проверяем обязательные для загрузки картинку:
                /*
                $('img', $tplItem).error(function() {
                    console.log('AAA Картинка не загружена');
                });
                $('img', $tplItem).load(function() {
                    console.log('AAA Картинка загружена');
                });
                */
                if (!$('img', $tplItem).attr('src')) {
                    isNotValid = 'Картинка не загружена';
                }
            } else {
                var
                    partnerVal = $('.form-control.landing-partner', $addBlockPlace).val(),
                    mobileChecked = $('input[name="MOBILE"]', $addBlockPlace).prop('checked'),
                    desktopChecked = $('input[name="DESKTOP"]', $addBlockPlace).prop('checked');
                
                $('.form-control.landing-partner', $tplItem).val(partnerVal);
                $('input[name="MOBILE"]', $tplItem).prop('checked', mobileChecked);
                $('input[name="DESKTOP"]', $tplItem).prop('checked', desktopChecked);
            }
            
            // Проверяем обязательные для заполнения текстовые input-поля:
            $('input[type="text"], select', $tplItem).each(function(){
                var $this = $(this);
                
                if ($this.data('field') != 'price') {
                    if ($this.parents('table.tpl-stat').length == 0) {
                        if ($.trim($this.val()) == '') {
                            isNotValid = 'Введите значение поля ' + $this.data('field');
                        }
                    }
                }
            });
            
            if (isNotValid) {
                alert(isNotValid);
                return false;
            }
            
            $tplItem.addClass('new');
            $tplItem.insertBefore($addButton);

            $addButton.show();
            $addBlock.hide();
            $addBlockPlace.empty();
            
            MarkOfferAsEdited();
            
            return false;
        });
        
        // Обработка ввода значений в input-поля:
        $WrapLandingsAdds.on('change', 'input', function() {
            
            var
                $input = $(this),
                textInput = $input.val(),
                fieldName = $input.data('field'),
                $field = $('.edited.'+fieldName, $input.parent()),
                textField = textInput,
                match, regex;
            
            // подсвечиваем ${text}
            regex = /\$\{([a-zA-Z0-9\-\_]*)\}/g;
            while (match = regex.exec(textInput)){
                textField = textField.replace(match[0], '<b>' + match[0] + '</b>');
            }
            // подсвечиваем $[text]
            regex = /\$\[([a-zA-Z0-9\-\_]*)\]/g;
            while (match = regex.exec(textInput)){
                textField = textField.replace(match[0], '<span>' + match[0] + '</span>');
            }
            
            $field.html(textField);
        });
        
    })();
    
    // Переменные шаблонов
    (function(){
        
        //var templatesVariables = [];
        
        //CheckTemplatesVariables();
        MarkAllInputTplFields();
        
        // Ввод в поля проверяемые на валидность:
        $addsLandingsWrap.on('keyup', 'input.editing[type="text"]', function(){
            //console.log('AAA Ввод в поля проверяемые на валидность:');
            MarkInputTplField($(this));
        });
        
        // Ввод в поля таблицы:
        $landingsWrap.on('keyup', 'table.tpl-stat input.form-control',  function(){
            //console.log('AAA Ввод в поля таблицы:');
            MarkAsEdited($(this));
            MarkAllInputTplFields();
        });
        
        // Выбор checked в таблице шаблонов:
        $landingsWrap.on('change', 'table.tpl-stat td.check input', function(){

            var
                $tplWrap = $(this).parents('.b-data-item_list-tpl-stat'),
                $actionControl = $('.b-data-item_list-tpl-action', $tplWrap),
                showActionControl = false;
            
            $('table.tpl-stat td.check input', $tplWrap).each(function(){
                if ($(this).prop('checked')) {
                    showActionControl = true;
                }
            });
            
            if (showActionControl) {
                $actionControl.show();
            } else {
                $actionControl.hide();
            }
            
        });
        
        $landingsWrap.on('click', '.btn.btn-primary.save-tpl-action', function(){
            
            var
                $landWrap = $(this).parents('.landing-item'),
                $form = $('#offer-tpl-edit-form'),
                action = $form.attr('action'),
                method = $form.attr('method'),
                formData = new FormData(),
                tplData = [],
                $tplWrap = $(this).parents('.b-data-item_list-tpl-stat'),
                $actionControl = $('.b-data-item_list-tpl-action', $landWrap),
                actionType = $('.form-control.tpls-action', $landWrap).val(),
                $trTpl = $('table.tpl-stat tbody tr', $landWrap),
                warningInfo;
            
            if (!actionType) {
                warningInfo = 'Выберите действие';
            }
            
            $trTpl.each(function(){
                var
                    $tr = $(this),
                    ad_data_id = $('td.templ-id input', $tr).val(),
                    isChecked = $('td.check input', $tr).prop('checked') ? 1 : 0;
                
                if (isChecked) {
                    tplData.push(ad_data_id);
                }
            });
            
            formData.append('landing_id', $landWrap.data('id'));
            formData.append('action', actionType);
            formData.append('tpls', tplData);
            
            if (warningInfo) {
                alert(warningInfo);
                return false;
            }
            
            //console.log('AAA formData = ', tplData);
            //return false;
            
            $tplWrap.addClass('state-loading');

            $.ajax(action, {
                type: method,
                data: formData,
                cache:false,
                contentType: false,
                processData: false,
                success: function(data) {
                    if(data) {
                        if(data.result === true) {
                            //console.log('AAA success ', data);
                            $trTpl.each(function(){
                                var
                                    $tr = $(this),
                                    $checkInput = $('td.check input', $tr),
                                    ad_data_id = $('td.templ-id input', $tr).val();
                                
                                $checkInput.prop('checked', false); 

                                if (data.tpls.indexOf(ad_data_id) > -1) {
                                    if (data.action_type == 'disable') {
                                        $tr.addClass('not-active');
                                    } else {
                                        $tr.removeClass('not-active');
                                    }
                                }
                            });
                            $actionControl.hide();
                            
                        }
                        if(data.result === false && data.msg) {
                            $.showMessage('error', data.msg);
                        }
                    }
                    $tplWrap.removeClass('state-loading');
                },
                error: function(rew, status, err) {
                    console.log(status, err);
                    $.showMessage('error', err);
                    $tplWrap.removeClass('state-loading');
                }
            });

            return false;
            
        });
        
        // Удаление строки в таблице шаблонов (не последней):
        $landingsWrap.on('click', 'table.tpl-stat b.del', function(){
            var $table = $(this).parents('table');
            if ($('tbody tr', $table).length>1) {
                MarkAsEdited($(this));
                
                var $tr = $(this).parents('tr');
                if ($tr.hasClass('new')) {
                    $tr.remove();
                } else {
                    $tr.addClass('not-active');
                }
            }
        });
        
        // Добавление строки в таблице шаблонов:
        $landingsWrap.on('click', '.b-data-item_list-tpl-stat .add-row', function(){
            var
                $table = $('table', $(this).parent()),
                varCount = $('thead:not(.layout) th', $table).length - 1,
                $tr = $(document.createElement('tr'));
                
            $tr.addClass('new');
            //$tr.append('<td class="check"><input type="checkbox"></td>');
            $tr.append('<td class="check"></td>');
            $tr.append('<td class="del"><span class="preview"></span></td>');
            
            // Добавление колонок id, price и статистики
            $tr.append('<td class="templ-id tpl"><input type="text" class="form-control template-value" value=""></td>');
            $tr.append('<td class="tpl"><input type="text" class="form-control template-value" value=""></td>');
            for (var i = 1; i < 8; i++) {
                $tr.append('<td class="stat"></td>');    
            }
            $tr.append('<td class="del" style="text-align: right"><b class="del">&times;</b></td>');
            
            /*
            for (var i = 1; i < varCount; i++) {
                if ($('thead:not(.layout) th', $table).eq(i).hasClass('stat')) {
                    $tr.append('<td class="stat"></td>');
                } else {
                    if ($('thead:not(.layout) th', $table).eq(i).hasClass('templ-id')) {
                        $tr.append('<td class="templ-id tpl"><input type="text" class="form-control template-value" value=""></td>');
                    } else {
                        $tr.append('<td class="tpl"><input type="text" class="form-control template-value" value=""></td>');
                    }
                    
                }
            }
            $tr.append('<td class="del"><b class="del">&times;</b></td>');
            */
            
            $table.append($tr);
            MarkAsEdited($(this));
        });
        
        function MarkAsEdited($this)
        {
            $this.parents(landingItemSelector).addClass('was-edited');
            MarkOfferAsEdited();
        }
        
        // Изменения в полях формы и таблицы:
        /*
        $addsLandingsWrap.on('change', 'input.editing[type="text"]', function(){
            //console.log('AAA Изменения в полях формы и таблицы:');
            CheckTemplatesVariables();
        });
        
        function CheckTemplatesVariables()
        {
            templatesVariables = [];

            $('input.editing[type="text"]', $addsLandingsWrap).each(function(){
                ChangeInputValue($(this).val());
            });
            TableVariablesEdit(templatesVariables);
        }
        
        function ChangeInputValue(val)
        {
            var
                re = /\$\[\w+\]/g,
                found = val.match(re);
        
            if (found) {
                found.forEach(function(item, i){
                    found[i]=item.replace('$[', '').replace(']', ''); 
                });
                AddToInputVariables(found);
            }
        }
        
        function AddToInputVariables(values)
        {
            values.forEach(function(value){
                if (templatesVariables.indexOf(value)<0) {
                    templatesVariables.push(value);
                }
            })
        }
        
        // Редактируем поля переменных в таблицах:
        function TableVariablesEdit(variables)
        {
            var $tables = $('table.tpl-stat');
            
            $tables.each(function(){
                
                var
                    $table = $(this),
                    $tableWrap = $table.parents('.b-data-item_list-tpl-stat'),
                    $tableHeaderLayout = $('thead.layout', $table),
                    $tableHeader = $('thead:not(.layout)', $table),
                    $tableHeadersLayoutAll = $('thead.layout th', $table),
                    $tableHeadersAll = $('thead:not(.layout) th', $table),
                    $tableHeadersLayout = $('thead.layout th:not(.templ-id):not(.del):not(.stat)', $table),
                    $tableHeaders = $('thead:not(.layout) th:not(.templ-id):not(.del):not(.stat)', $table),
                    $tableHeaderRow = $('thead:not(.layout) tr', $table),
                    $tableBodyRow = $('tbody tr', $table),
                    $tableBodyCells = $('tbody td:not(.templ-id):not(.del):not(.stat)', $table);

                if (!variables.length) {
                    //$tableWrap.addClass('hidden');
                    // Удаление оставшейся колонок, т.к. переменных нет:
                    $tableHeadersLayout.remove();
                    $tableHeaders.remove();
                    $tableBodyCells.remove();
                    //$('tbody td.templ-id input', $table).val('');
                } else {
                    $tableWrap.removeClass('hidden');

                    // Удаление колонки, если её нет в данных:
                    $tableHeaders.each(function(){
                        if (variables.indexOf($(this).text())<0) {
                            // Колонку id не удаляем:
                            if ($(this).text() == 'id') {

                            } else {
                                var indexColumn = $tableHeadersAll.index($(this));
                                $tableHeadersLayoutAll.eq(indexColumn).remove();
                                $tableHeadersAll.eq(indexColumn).remove();
                                $tableBodyRow.each(function(){
                                    $('td', $(this)).eq(indexColumn).remove();
                                });
                            }
                        }
                    });

                    // Добавление колонки, если её нет в таблице:
                    variables.forEach(function(variable){

                        var newVariable = true;
                        $tableHeaders.each(function(){
                            if ($(this).text() == variable) {
                                newVariable = false;
                            }
                        });
                        if (newVariable) {
                            if (variable != 'id') {
                                var
                                    thPlaceSelector = ($('th.stat', $tableHeader).length>0) ? 'th.stat:first' : 'th.del',
                                    tdPlaceSelector = ($('th.stat', $tableHeader).length>0) ? 'td.stat:first' : 'td.del';
                                
                                $(thPlaceSelector, $tableHeaderLayout).before('<th></th>');
                                $(thPlaceSelector, $tableHeader).before('<th>' + variable + '</th>');
                                $tableBodyRow.each(function(){
                                    if (!$(this).hasClass('not-active')) {
                                        $(tdPlaceSelector, $(this)).before('<td class="tpl"><input type="text" class="form-control template-value" value=""></td>');
                                    } else {
                                        $(tdPlaceSelector, $(this)).before('<td class="tpl"></td>');
                                    }
                                    
                                });
                            }
                        }
                    });            
                }
            
            });
        }
        
        */
        
        function MarkAllInputTplFields()
        {
            $('input.editing[type="text"]', $addsLandingsWrap).each(function(){
                MarkInputTplField($(this));
            });
        }

        function MarkInputTplField($input)
        {
            var
                val = $input.val(),
                fieldName = $input.data('field'),
                $field = $('.edited.'+fieldName, $input.parent()),
                re = /\$\[\w+\]/g,
                found = val.match(re),
                inputText,
                invalidClass = 'not-valid';
            
            $input.removeClass(invalidClass);
            $field.removeClass(invalidClass);
        
            if ($.inArray($input.attr('data-field'), ['title','desc','price'])>=0) {
                
                if (found)
                {
                    var $landings = $('.landing-item', $landingsWrap);
                    $landings.each(function(){

                        var
                            $land = $(this),
                            $table = $('table.tpl-stat', $land),
                            $tableHeaders = $('thead:not(.layout) th:not(.del):not(.stat)', $table),
                            $tableBodyRows = $('tbody tr', $table);

                        inputText = val; // Оригинальный шаблон

                        found.forEach(function(item, i){
                            found[i]=item.replace('$[', '').replace(']', '');
                        });

                        $tableBodyRows.each(function(){

                            var
                                textVar = inputText,
                                $row = $(this),
                                $inputVars = [];

                            found.forEach(function(item){

                                var
                                    varIndex,   // индекс переменной шаблона
                                    $inputVar,  // input переменной
                                    valueVar;   // значение переменной

                                $tableHeaders.each(function(){
                                   var $this = $(this);
                                   if ($this.text() == item) {
                                       varIndex = $tableHeaders.index($this);
                                   } 
                                });

                                $inputVar = $('input', $('td.tpl', $row).eq(varIndex)), // input переменной
                                valueVar = $.trim($inputVar.val()); // значение переменной
                                $inputVars.push($inputVar);

                                textVar = textVar.replace('$[' + item + ']', valueVar);
                            });    

                            // Подсвечиваем невалидные шаблоны и их переменные
                            $.each($inputVars, function(i, $item){
                                $item.removeClass(invalidClass);
                            });

                            var maxValueLength = ($input.attr('data-field') == 'price') ? 8 : 48;
                            if (textVar.length>maxValueLength) {
                                $input.addClass(invalidClass);
                                $field.addClass(invalidClass);
                                $.each($inputVars, function(i, $item){
                                    $item.addClass(invalidClass);
                                });
                            }
                        });

                    });
                }
                else
                {
                    var maxValueLength = ($input.attr('data-field') == 'price') ? 8 : 50;
                    if (val.length>maxValueLength) {
                        $input.addClass(invalidClass);
                        $field.addClass(invalidClass);
                    }
                }

            }

        }

        
    })();
    
    // Превьюшки:
    (function(){
        
        var
            $popupBg = $('.l-popup'),
            $popup = $('.b-popup__window.preview', $popupBg),
            $popupClose = $('.button-close', $popup),
            $popupInner = $('.b-popup-content', $popup);
        
        // Открываем попап:
        $addsWrap.on('click', '.btn.preview', function(){
            ShowPopup('add', $(this));
            return false;
        });
        $landingsWrap.on('click', 'table.tpl-stat span.preview', function(){
            ShowPopup('tpl', $(this));
        });
        
        // Закрыввем попап по клику на Х:
        $popupClose.on('click', function(){
            ClosePopup();
        });
        // Закрыввем попап по клику извне:
        $popup.on('click', function(event){
            event.stopPropagation();
        });
        $popupBg.on('click', function(){
            ClosePopup();
        });
        
        function ShowPopup(type, $target)
        {
            if (type == 'add') {
                InsertPopupContentAdd($target);
            } else {
                InsertPopupContentTpl($target);
            }
            $popupBg.addClass('open-popup');
            $popup.show();
        }
        
        function ClosePopup()
        {
            $popupBg.removeClass('open-popup');
            $popup.hide();
            $popupInner.empty()
        }
        
        function InsertPopupContentAdd($target)
        {
            var
                $content = $(document.createElement('div')),
                $addTpl = $target.parents('.ads-list-item').clone();
            
            $('input, .btn.preview', $addTpl).remove();
            $('.b-data-item_list-stat', $addTpl).remove();
            $content.append('<h2>Превью объявлений</h2>');
            
            $(landingItemSelector, $landingsWrap).each(function(){
                
                var
                    $land = $(this),
                    landTitle = $('.landing-title.editing', $land).val(),
                    landLink = $('.landing-link.editing', $land).val(),
                    $landTable = $('.table.tpl-stat', $land).clone();
                
                var $link = $(document.createElement('a'));
                $link.addClass('link edited');
                $link.attr('target', '_blank');
                $link.attr('href', landLink);
                $link.html(landLink);
                
                $('.del', $landTable).remove();
                
                $content.append('<h3 class="land-title">' + landTitle + '</h3>');
                
                // Шаблонов нет:
                if ($('.b-data-item_list-tpl-stat', $land).hasClass('hidden')) {
                    var
                        $addTplItem = $addTpl.clone(),
                        $addLink = $link.clone();

                    //$('.price.edited', $addTplItem).after($addLink);
                    $('.add-id', $addTplItem).before($addLink);
                    
                    $content.append('<div style="height: 20px;"></div>');
                    $content.append($addTplItem);
                }
                
                $('.table.tpl-stat tbody tr', $land).each(function(){
                    
                    if (!$(this).hasClass('not-active')) { // не отображаем превью для неактивных данных
                        
                        var
                            $tableItem = $landTable.clone(),
                            $addTplItem = $addTpl.clone(),
                            $addLink = $link.clone(),
                            indTr = $('.table.tpl-stat tbody tr', $land).index(this),
                            dataTpl = [],
                            $adId = $('.add-id', $addTplItem);

                        $('thead.layout', $tableItem).remove();
                        $('tbody tr', $tableItem).not(':eq('+ indTr +')').remove();

                        $('tbody tr td', $tableItem).each(function(){
                            var
                                $td = $(this),
                                $inputTd = $('input', $td),
                                tdVal = $inputTd.val(),
                                indTd = $('tbody tr td', $tableItem).index(this),
                                tdName = $('thead tr th', $tableItem).eq(indTd).text();

                                // Убираем ячейки со стат. данными
                                if ($td.hasClass('stat')) {
                                    $td.remove();
                                    $('thead tr th', $tableItem).eq(indTd).remove();
                                }
                                
                                $inputTd.remove();
                                $td.text(tdVal);
                                dataTpl.push([tdName, tdVal])
                        });
                        
                        var priceValue = '';
                        dataTpl.forEach(function(val){
                            if (val[0] == 'price') priceValue = val[1];
                        });
                        $adId.before($('<div class="price edited">' + priceValue + '</div><br />'));
                        $adId.before($addLink);

                        $('.edited', $addTplItem).each(function(){
                            var textString = $(this).text();
                            dataTpl.forEach(function(val){
                                var regex = new RegExp('\\$\\['+ val[0] +'\\]', "g");
                                textString = textString.replace(regex, val[1]);
                            });

                            $(this).text(textString);
                            if ($(this).hasClass('link')) {
                                $(this).attr('href', textString);
                            }
                        });

                        $content.append($tableItem);
                        $content.append($addTplItem);
                    }
                    
                });
            });
            
            $popupInner.append($content)
        }
        
        function InsertPopupContentTpl($target)
        {
            var
                $content = $(document.createElement('div')),
                $tr = $target.parents('tr'),
                $land = $target.parents('.landing-item'),
                $table = $target.parents('table'),
                landLink = $('.landing-link.editing', $land).val(),
                dataTpl = [];
            
            $('td', $tr).not('.del').each(function(){
                var
                    $td = $(this),
                    $inputTd = $('input', $td),
                    tdVal = $inputTd.val(),
                    indTd = $('td', $tr).index(this),
                    tdName = $('thead:not(.layout) tr th', $table).eq(indTd).text();
                    
                dataTpl.push([tdName, tdVal]);
            });
            
            $content.append('<h2>Превью шаблонов</h2>');
            
            var $link = $(document.createElement('a'));
            $link.addClass('link edited');
            $link.attr('target', '_blank');
            $link.attr('href', landLink);
            $link.html(landLink);
            
            $(addItemSelector, $addsWrap).each(function(){
                
                var
                    $addTplItem = $(this).clone(),
                    $addLink = $link.clone(),
                    $adId = $('.add-id', $addTplItem);
            
                var priceValue = '';
                dataTpl.forEach(function(val){
                    if (val[0] == 'price') priceValue = val[1];
                });
                
                $adId.before($('<div class="price edited">' + priceValue + '</div><br />'));
                $adId.before($addLink);
            
                $('input, .btn.preview', $addTplItem).remove();
                $('.b-data-item_list-stat', $addTplItem).remove();
                
                $('.edited', $addTplItem).each(function(){
                    var textString = $(this).text();
                    dataTpl.forEach(function(val){
                        var regex = new RegExp('\\$\\['+ val[0] +'\\]', "g");
                        textString = textString.replace(regex, val[1]);
                    });
                    $(this).text(textString);
                    if ($(this).hasClass('link')) {
                        $(this).attr('href', textString);
                    }
                });
                
                $content.append($addTplItem);
            });
            
            $popupInner.append($content)
        }
        

    })();
    
    // Клик на "Сохранить":
    $('.btn.btn-primary.submit-action').on('click', function(){
        
        window.onbeforeunload = function() {};
        
        if ($('input.form-control.tpl', $addsLandingsWrap).hasClass('not-valid')) {
            alert('Проверьте данные в полях ввода!');
            return false;
        }
        
        var
            $form = $('#offer-create-form'),
            action = $form.attr('action'),
            method = $form.attr('method'),
            formData = new FormData(),
            warningInfo;
        
        
        // Данные настроек:
        var offerTitle = $('.offer-title.editing').val();
        if (offerTitle == '') {
            warningInfo = 'Введите название оффера';
        }
        
        formData.append('title', offerTitle);
        formData.append('disabled', ($('.form-group.offer-enable input').prop('checked')) ? 0 : 1);
        formData.append('lang', $('.form-control.offer-language').val());
        formData.append('rating', $('.form-control.offer-rating').val());
        
        // Данные категорий:
        var cat = [];
        $('.b-categories .category-item').each(function(){
            var
                $this = $(this),
                id = parseInt($('.offer-category', $this).val()),
                sub = parseInt($('.offer-subcategory', $this).val());
            
            if (id != '' && sub != '') {
               cat.push({'id':id, 'sub':sub}) 
            } else {
                warningInfo = 'Укажите категорию (подкатегорию)';
            }
        });
        formData.append('cat', JSON.stringify(cat));
        
        // Данные лендингов:
        var landings = [];
        $('.landing-item', $landingsWrap).each(function(){
            
            // Не учитываем редактируемые:
            if ($(this).parents('.b-data-item_add-list-place').length>0) {
                return false;
            }
            
            var
                $this = $(this),
                geoValue = [],
                deviceValue = [],
                dataTemplateValues = {},
                $table = $('.b-data-item_list-tpl-stat  table.tpl-stat', $this),
                $tableHeaders = $('thead:not(.layout) th:not(.del):not(.stat)', $table),
                $tableBodyRow = $('tbody tr', $table),
                landingId = $this.data('id'),
                landingIsDisabled = $this.hasClass('disabled'),
                isNotEmptyTable = false;
            
            // link
            var linkValue = $('.landing-link.editing', $this).val();
            if (linkValue.indexOf("${imp}") < 0) {
                warningInfo = 'Отсутствует индентификатор просмотра ${imp} в ссылке лендинга: ' + linkValue;
            }
            // geo
            $('.landingdata-item.geo .values-string span', $this).each(function(){
                geoValue.push($(this).data('id'));
            });
            // device
            $('.landingdata-item.device input[type="checkbox"]', $this).each(function(){
                if ($(this).prop('checked')) {
                    deviceValue.push($(this).attr('name'));
                }
            });
            // tpl
            if (!$('.b-data-item_list-tpl-stat', $this).hasClass('hidden')) {
            
                $tableBodyRow.each(function(){
                    
                    if (!$(this).hasClass('not-active')) {

                        var
                            valuesItem = {},
                            $cellId = $('td.tpl:first', $(this)),
                            $allCells = $('td', $(this)),
                            $cells = $('td:not(:last):not(:first):not(.stat):not(.del):not(.templ-id)', $(this)),
                            id_name, val, ind,
                            isNotEmptyCell = false;

                        id_name = $.trim($('input', $cellId).val());

                        if (id_name != '') {

                            $cells.each(function(){
                                val = $.trim($('input', $(this)).val());
                                ind = $allCells.index($(this));
                                valuesItem[$tableHeaders.eq(ind-1).text()] = val;
                                if (val != "") {
                                    isNotEmptyCell = true;
                                } else {
                                    if (!landingIsDisabled) {
                                        warningInfo = 'Не установлено значение ' + $tableHeaders.eq(ind-1).text() + ' в шаблоне лендинга id=' + landingId;
                                    }
                                }
                            });

                            if (isNotEmptyCell) {
                                dataTemplateValues[id_name] = valuesItem;
                            } else {
                                dataTemplateValues[id_name] = {};
                            }

                            isNotEmptyTable = true;

                        } else {
                            if (!landingIsDisabled) {
                                warningInfo = 'Не установлено значение id' + ' в шаблоне лендинга id=' + landingId;
                            }
                        }

                    }
                    
                });
            }
            
            
            landings.push({
                'id': landingId,
                'disabled': landingIsDisabled,
                'title': $('.landing-title.editing', $this).val(),
                'link': linkValue,
                'source': parseInt($('.landing-partner', $this).val()),
                'geo': geoValue,
                'device': (deviceValue.length == 1) ?  deviceValue[0] : null,
                'tpl': (isNotEmptyTable) ? dataTemplateValues : null,
            });
            
        });
        formData.append('landings', (landings.length>0) ? JSON.stringify(landings) : null);
        
        // Данные объявлений:
        var ads = [];
        $('.ads-list-item', $addsWrap).each(function(){
            
            // Не учитываем редактируемые:
            if ($(this).parents('.b-data-item_add-list-place').length>0) {
                return false;
            }
            
            var
                $this = $(this),
                imgSrc = $('img', $this).attr('src').split('?')[0];
            
            if ($('input.editing').hasClass('not-valid')) {
                warningInfo = 'В объявлениях присутствуют невалидные данные';
            }
            
            ads.push({
                'id': $this.data('id'),
                'disabled': $this.hasClass('disabled'),
                'title': $('.title.editing', $this).val(),
                'desc': $('.desc.editing', $this).val(),
                'price': $('.price.editing', $this).val(),
                'img': imgSrc,
            });
                
        });
        formData.append('ads', (ads.length>0) ? JSON.stringify(ads) : null);
        
        if (warningInfo) {
            alert(warningInfo);
            return false;
        }
        
        //console.log('AAA dataTemplateValues = ', landings);
        //return false;
        
        $.ajax(action, {
            type: method,
            data: formData,
            cache:false,
            contentType: false,
            processData: false,
            success: function(data) {
                if(data) {
                    if(data.result === true && data.redirect) {
                        document.location.href = data.redirect;
                    }
                    if(data.result === false && data.msg) {
                        $.showMessage('error', data.msg);
                    }
                } 
            },
            error: function(rew, status, err) {
                console.log(status, err);
                $.showMessage('error', err);
            }
        });
        
        return false;
    });
    
    // Клик на "Отмена":
    $('.btn.btn-default.cancel-action').on('click', function(){
        window.onbeforeunload = function() {};
        window.open($(this).attr('href'), '_self');
        return false;
    });
    
});