$(document).ready(function(){

    Number.prototype.formatMoney = function(c, d, t){
        var n = this, 
            c = isNaN(c = Math.abs(c)) ? 2 : c, 
            d = d == undefined ? "." : d, 
            t = t == undefined ? "," : t, 
            s = n < 0 ? "-" : "", 
            i = String(parseInt(n = Math.abs(Number(n) || 0).toFixed(c))), 
            j = (j = i.length) > 3 ? j % 3 : 0;
        return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
    };
    
    // Добавление впереди 0 у однозначных значений
    function pad(number) {
        var r = String(number);
        if ( r.length === 1 ) {
          r = '0' + r;
        }
        return r;
    }
    
    // Форматирование даты
    function formatDate(date)
    {
        return date.getUTCFullYear() +'-'+ pad(date.getMonth()+1) +'-'+ pad(date.getDate());
    }
    
    function formatPercent(value)
    {
        return (value*100).toFixed(2);
    }
    
    function createDropDown($element, onselect, oncreate) {
        var $current = $element.find('.droplist-current');
        $current.on('click focus', function(e, t){
            
            var $this = $(this);
            var $thisList = $this.siblings().filter('.droplist-block');
            var $dropList = $thisList;
        
            var sumListEl = $thisList.children().length;
            var heightList = $thisList[0].clientHeight;
      
            if($dropList.hasClass('m-open-droplist')) {
                $('.m-open-droplist').removeClass('m-open-droplist');
            } else {
                $('.m-open-droplist').removeClass('m-open-droplist');
                $dropList.addClass('m-open-droplist');
                $this.addClass('m-open-droplist');
            }
            e.stopPropagation();
            return false;
        });                     
        
        var $list = $element.find('.droplist-item');
        if($list.length > 0) {           
            $current.html($list.first().html());        
            
            if(typeof oncreate == 'function') {
                oncreate($list.first(), $current);
            }
        }
        
        $list.on('click', function() {
            var $this = $(this);
            var selectStr = $(this).html();
            
            $(this).parent().siblings().filter('.droplist-current').html(selectStr);
            $('.m-open-droplist').removeClass('m-open-droplist');                                  
            if(typeof onselect == 'function') {                               
                onselect($this, $current);                              
            }           
            
            return false;
        });
    }  
    
    var domainsListSelector = '#domains-list';
    var domainClassSelected = 'domain-selected';
    var subDomainClassSelected = 'sub-domain-selected';
    var subDomainStateSelected = 'state-selected';
   
    function selectedDomainsAll() {
        
        var
            $domainsList = $(domainsListSelector),
            selectedDomains = [],
            subdomains = 1,
            count = $domainsList.find('.main-domain').length,
            idDomains = [],
            $mainDomains = $domainsList.find('.main-domain' + '.' + domainClassSelected);
        
        // Выбрано несколько основных доменов
        if ($mainDomains.length > 1)
        {
            $mainDomains.each(function(){
                selectedDomains.push($(this).data('domain'));
                idDomains.push($(this).data('siteid'));
            });
        }
        // Выбран один основной домен
        else
        {
            var
                mainDomainTitle = $mainDomains.data('domain'),
                mainDomainId = $mainDomains.data('siteid'); 
            
            // Выбран основной домен
            if (selectedDomains.length == 0)
            {
                selectedDomains.push(mainDomainTitle);
                idDomains.push(mainDomainId);
            }
        }
        
        return {'domains': selectedDomains, 'subdomains': subdomains, 'count': count, 'ids': idDomains};
    }
    
    
    // Создание дров дауны и список сайтов
    $('.b-filter__switch').each(function(index,el){
      if(!$(el).find('.b-filter__switch-item').hasClass('m-filter__switch-item_active')) {
        $(el).find('.b-filter__switch-item').eq(0).trigger('click');
      }
    });

    $('.b-content__site-droplist .droplist-item').each(function(index, el){
      if($(el).attr('data-src-icon-site')){
        var srcIcon = $(el).attr('data-src-icon-site');
        $(this).css({
            'background-image': 'url(' + srcIcon + ')'
          });
      }
    });
    
    // Список доменов
    var $domainsList = $(domainsListSelector);
    
    $domainsList.find('.main-domain').each(function(){
        $(this).addClass(domainClassSelected);
    });
    
    // Клик по основному домену
    $domainsList.find('.main-domain').click(function() {
        
        var $this = $(this);
        console.log('AAA Клик по основному домену ', $this.data('id'));
        
        var type = $('#sites-dropdown').find('.droplist-current').data('id');
        console.log('AAA Клик по основному домену type = ', type);
        
        if(type == 'all')  {    // Отрображался список всех доменов
            var domainId = $(this).data('id');            
            $('#sites-dropdown .droplist-item').each(function(){               
                if($(this).data('id') == domainId) {
                    $(this).click();
                }
                return;
            });
            return false;          
        } else {    // Отрображался список поддоменов одного домена
            $(this).parent().find('.sub-domain').removeClass(subDomainClassSelected);
            $(this).parent().find('.sub-domain').removeClass(subDomainStateSelected);
        }
        
        $domainsList.trigger('select-domain');
        return false;
    });
    
    // Закрыть дропдаун по клику на странице
    $(document).on('click', function() {
        $('.m-open-droplist').removeClass('m-open-droplist');
    });
    
    // Дропдаун списка доменов:
    createDropDown($('#sites-dropdown'), function($element, $current) {
        //console.log('AAA Клик по домену из выпадающего списка');
        
        var attrSrcIcon = $element.attr('data-src-icon-site'); // иконка выбранного сайта
        var attrSiteId = $element.attr('data-id'); // id выбранного сайта
        
        $current.data('id', attrSiteId);
        $current.css({'background-image': 'url(' + attrSrcIcon + ')'}).attr('data-id', attrSiteId);                             
        
        // Инициируем запрос по соответствующему домену в списке:
        var $leftItem = $('.b-content__losses-left-item');
        var $allDomains = $('.all-domains');
        
        // Перебираем домены в списке:
        $domainsList.find('.main-domain').each(function() {
            var relDomain = $(this).data('domain');
            
            if(attrSiteId == 'all') {
                $(this).addClass('domain-selected').removeClass('font-bold');
                $(this).parent().show();
                $(this).parent().find('.sub-list').hide();
                $leftItem.removeClass('state-subdomains');
                //$(this).parent().find('.sub-domain').addClass(subDomainClassSelected);
            } else if(relDomain != attrSiteId) {
                $(this).removeClass('domain-selected').removeClass('font-bold');
                $(this).parent().hide();
                $(this).parent().find('.sub-domain').removeClass(subDomainClassSelected);
            } else if(relDomain == attrSiteId) {
                $(this).addClass('domain-selected').addClass('font-bold');
                $(this).parent().show();         
                $(this).parent().find('.sub-list').show();
                $leftItem.addClass('state-subdomains');
                //$(this).parent().find('.sub-domain').addClass(subDomainClassSelected);
            }
            
        });
        
        // Отображение ссылки "Все сайты":
        if(attrSiteId == 'all') {
            $allDomains.hide();
        } else {
            $allDomains.show();
        }
        
        
        $domainsList.trigger('select-domain');                
    }, function($element, $current) {
        $current.data('id', $element.data('id'));
    });  

    
    // Создание отчета и графика с таблицами
    
    // Загрузка данных через 15 мин
    /*
    var timeOut = 1000*60*5;        
    var loadData = setTimeout(function runLoad() {
        loadDataSummuryReport();
        loadDataLineChart();
        setTimeout(runLoad, timeOut);
    }, timeOut);
    */

    // Массив данных по суммарному таблице
    var linkSummaryReport = '/statistics/';
    
    var selectorSummaryReport = '#summary-report-table';
    var dataSummaryReport = false;
    if($('#summary-report-stats').val()) {
        dataSummaryReport = JSON.parse($('#summary-report-stats').val());        
    }
    
    // Массив данных по линейным диаграммам
    var selectorGraphChart = '#chart-graph';
    var dataLineChart = false;
    if($('#period-stats').val()) {
        dataLineChart = JSON.parse($('#period-stats').val());
        addDataFields(dataLineChart);
    }
    
    
    // Подсвечиваем нужный график
    var
        fullSwitchSelector = '.b-filter__switch.display.full .b-filter__switch-item',
        shortSwitchSelector = '.b-filter__switch.display.short .b-filter__switch-item',
        classActive = 'm-filter__switch-item_active',
        cookieName = 'active_graph';
        
    if ($.cookie(cookieName))
    {
        var activeSwitch = $.cookie(cookieName);
        
        // Подсвечиваем полный список
        if ($(fullSwitchSelector + '[data-filter-category=' + activeSwitch + ']').length > 0)
        {
            $(fullSwitchSelector + '[data-filter-category=' + activeSwitch + ']').addClass(classActive);
        }
        else
        {
            $(fullSwitchSelector + ':first').addClass(classActive);
        }
        
        // Подсвечиваем краткий список
        if ($(shortSwitchSelector + '[data-filter-category=' + activeSwitch + ']').length > 0)
        {
            $(shortSwitchSelector + '[data-filter-category=' + activeSwitch + ']').addClass(classActive);
        }
        else
        {
            $(shortSwitchSelector + ':first').addClass(classActive);
        }
    }
    else
    {
        $(shortSwitchSelector + ':first').addClass(classActive);
        $(fullSwitchSelector + ':first').addClass(classActive);
        
        var activeSwitch = $('.b-filter__switch.current .m-filter__switch-item_active').data('filter-category');
        $.cookie(cookieName, activeSwitch);
    }
    
    // Переключение между графиками
    $('.b-filter__switch-item').click(function(){
        $(this).siblings().removeClass(classActive);
        $(this).addClass(classActive);
        
        // Переключение таблиц для админа
        if ($(this).parent().hasClass('time-table'))
        {
            if ($(this).data('filter-category') == 'sites') {
                $('#table-line').hide();
                $('#table-sites').show();
                $('.time-table-sort').show();
            } else {
                $('#table-sites').hide();
                $('#table-line').show();
                $('.time-table-sort').hide();
            }
        }
        else
        {
            activeLine = $(this).data('filter-category'); 
            $.cookie(cookieName, activeLine);

            $(selectorGraphChart).trigger('render-chart');
        }
        
        return false;
    });
    
    var activeLine = $('.b-filter__switch.current .m-filter__switch-item_active').data('filter-category');
    
    // Выбор периода-месяца
    //console.log('AAA выбор периода:');
    var chartDateSelector = '#daterange-dropdown';    
    createDropDown($(chartDateSelector), function($element, $current) {      
        $current.data('date-value', $element.data('date-value'));
        $(selectorGraphChart).trigger('reload-chart');
    }, function($element, $current){        
        $current.data('date-value', $element.data('date-value'));
    });    

    // Ссылка на .json файлы данных категории для отображения данных в линейном графике
    var linkLinerChart          = '/statistics/';
    
    // Стартовая загрузка графиков / перерисовка при изменении размера экрана
    $(window).on('resize orientationchange', function() {      
        loadDataLineChart();      
    });    
    
    var
        $loadingSummary = $('.b-content__loading.summary'),
        $loadingChart = $('.b-content__loading.chart'),
        $loadingTable = $('.b-content__loading.table');
    
    // Загрузка данных сводной таблицы
    var loadDataSummuryReportBusy = false;
    function loadDataSummuryReport() {
        
        if(loadDataSummuryReportBusy) {
            return;
        }      
        
        var
            selectedSitesId = selectedDomainsAll().ids,
            codes = [$('#period-stats').data('codeprovider')];
            
        loadDataSummuryReportBusy = true;
        $loadingSummary.show();
        $.ajax(linkSummaryReport, {
            method: 'POST',
            data: {
                action: 'codestatglobal',
                sites: selectedSitesId,
                codes: codes,
            },
            success: function(res){
                //console.log("AAA loadDataSummuryReport success res: ", res);
                dataSummaryReport = res;
                renderSummaryReport();
                loadDataSummuryReportBusy = false;
                $loadingSummary.hide();
            },
            error: function(req,status,err) {
                console.log("Error " + req,status,err);
                loadDataSummuryReportBusy = false;
                $loadingSummary.hide();
            }
        });
    }

    // Отрисовка и загрузка данных линейного графика
    var loadDataLineChartBusy = false;
    function loadDataLineChart() {
        //console.log('AAA loadDataLineChart');
        
        if(loadDataLineChartBusy) {
            return;
        }
        
        var
            selectedSitesId = selectedDomainsAll().ids,
            codes = [$('#period-stats').data('codeprovider')],
            chartDate = $(chartDateSelector).find('.droplist-current').data('date-value');
        
        var reqData = {
            action: 'codestat',
            sites: selectedSitesId,
            codes: codes,
            month: chartDate,
        };
        
        loadDataLineChartBusy = true;
        $loadingChart.show();
        $loadingTable.show();
        $.ajax(linkLinerChart, {
            type: 'POST',
            dataType: 'json',
            data: reqData,
            success: function(res) {
                //console.log("success ", res);
                loadDataLineChartBusy = false;
                
                dataLineChart = res;
                addDataFields(dataLineChart);
                
                renderLineChart();                
                renderLineTable();
                $loadingChart.hide();
                $loadingTable.hide();
            },
            error: function(req,status,err) {
                console.log("Error " + req,status,err);
                
                loadDataLineChartBusy = false;
                $loadingChart.hide();
                $loadingTable.hide();
            }
        });
    };
    
    // Отрисовка сводной таблицы
    function renderSummaryReport() {
        
        if (!dataSummaryReport || dataSummaryReport.length==0)
        {
            $('.b-content__no-data').show();
            $('#summary-report-table').hide();
        }
        else
        {
            $('.b-content__no-data').hide();
            $('#summary-report-table').show();
        }
        
        var domains = selectedDomainsAll().domains;
        var reportData = {
            views: {
                today: 0,
                yesterday: 0,
                '30days': 0,
                cur_month: 0,
                prev_month: 0                
            },
            clicks: {
                today: 0,
                yesterday: 0,
                '30days': 0,
                cur_month: 0,
                prev_month: 0                
            },
            ctr: {
                today: 0,
                yesterday: 0,
                '30days': 0,
                cur_month: 0,
                prev_month: 0                
            },
        };                             
        
        var $summaryTable = $(selectorSummaryReport);
        $summaryTable.removeClass('full').addClass('short');
        
        if(domains && dataSummaryReport) {
            for(var periodKey in dataSummaryReport) {               
                if(!reportData.views[periodKey]) {
                    reportData.views[periodKey] = 0;
                }
                if(!reportData.clicks[periodKey]) {
                    reportData.clicks[periodKey] = 0;
                }
                if(!reportData.ctr[periodKey]) {
                    reportData.ctr[periodKey] = 0;
                }
                            
                if(dataSummaryReport[periodKey].views) {
                    reportData.views[periodKey] = dataSummaryReport[periodKey].views;
                }
                if(dataSummaryReport[periodKey].clicks) {
                    reportData.clicks[periodKey] = dataSummaryReport[periodKey].clicks;
                }
                if(dataSummaryReport[periodKey].ctr) {
                    reportData.ctr[periodKey] = dataSummaryReport[periodKey].ctr;
                }
            }
        }     
        
        var $tableData = $('<table>').html($(selectorSummaryReport).html());
        
        for(var type in reportData) {
            for(var period in reportData[type]) {
                var key = '#summary-' + period + '-' + type;
                var value = reportData[type][period];
                if(type == 'views') {
                    value = value.formatMoney(0);                                    
                }
                if(type == 'clicks') {
                    value = value.formatMoney(0);                                    
                }
                if(type == 'ctr') {
                    value = formatPercent(value);
                }
                
                $tableData.find(key).html(value);
            }
        }

        $(selectorSummaryReport).html($tableData.html());        
    }
    
    // Отрисовка графика
    function renderLineChart() {
        //console.log('AAA dataLineChart: ', dataLineChart);
        if(dataLineChart) {
            
            // Выбираем набор переключалок графиков для отображения
            var $fullSwitchBlock = $('.b-filter__switch.display.full');
            var $shortSwitchBlock = $('.b-filter__switch.display.short');

            // Показываем список переключалок
            $fullSwitchBlock.removeClass('current');
            $shortSwitchBlock.addClass('current');
            $fullSwitchBlock.hide();
            $shortSwitchBlock.show();
            
            // Отрисовываем график библиотекой c3.js
            var dataName = $('.b-filter__switch.display.current .b-filter__switch-item.m-filter__switch-item_active').html();
            var activeLine = $('.b-filter__switch.display.current .b-filter__switch-item.m-filter__switch-item_active').data('filter-category');
            var currencySymbol = ' ' + $('.b-content__site-currency .droplist-current').data('symbol');
            //console.log('AAA activeLine: ', activeLine);
            
            var dataColumns = [
                ['x'].concat(dataLineChart['period']),
                ['data1'].concat(dataLineChart[activeLine]),
            ];
            var dataNames = {
                data1: dataName
            }
            var colors = {
                data1: '#2ca02c',
                data2: '#ff0000'
            };
            
            var valueFormat = function (value, ratio, id) {
                var currencyFields = ['money', 'block_money', 'total', 'return'];
                var isCurrencyValue = currencyFields.indexOf(activeLine) >=0;
                var format = (isCurrencyValue) ? d3.format(',.2f') : d3.format(',');
                return (isCurrencyValue) ? format(value) + currencySymbol : format(value);
            };
            axisY1format = function (d) {
                var currencyFields = ['money', 'block_money', 'total', 'return'];
                var isCurrencyValue = currencyFields.indexOf(activeLine) >=0;
                var format = (isCurrencyValue) ? d3.format(',.0f') : d3.format(',');
                return (isCurrencyValue) ? format(d) + currencySymbol : format(d);
            }
            var axisY2format = function (d) {
                return d;
            }
            var paddingAxisX = {left: 0};
            
            var showLegend = false;
            var y2Show = false;
            
            if (activeLine == 'ctr') {
                
                axisY1format = function (d) {
                    var format = d3.format(".2%");
                    return format(d);
                }
                
                valueFormat = function (value, ratio, id) {
                    var format = d3.format(".2%");
                    return format(value);
                };
                
            } else {
                dataColumns = [
                    ['x'].concat(dataLineChart['period']),
                    ['data1'].concat(dataLineChart[activeLine]),
                ];
                dataNames = {
                    data1: dataName
                };
            }
            
            
            var chart = c3.generate({
                bindto: '#chart-graph',
                data: {
                    x: 'x',
                    columns: dataColumns,
                    names: dataNames,
                    types: {
                        data1: 'area-spline',
                        data2: 'area-spline',
                        data3: 'area-spline'
                    },
                    colors: colors,
                    axes: {
                        data1: 'y',
                        data2: 'y2',
                        data3: 'y2'
                    }
                },
                axis: {
                    x: {
                        type : 'timeseries',
                        padding: paddingAxisX,
                        tick: {
                            culling: {max: 31},
                            format: '%d'
                        }
                    },
                    y: {
                        min: 0,
                        padding: {top: 50, bottom: 0},
                        tick: {
                            format: axisY1format
                        },
                    },
                    y2: {
                        padding: {top: 150, bottom: 0},
                        tick: {
                            format: axisY2format
                        },
                        show: y2Show
                    }
                },
                grid: {
                    x: {show: true},
                    y: {show: true},
                },
                tooltip: {
                    format: {
                        title: function (d) {
                            return formatDate(d);
                        },
                        value: valueFormat
                    }
                },
                legend: {
                    show: showLegend
                },
            });
            
            $('#b-content__traffic-chart').show();
        } else {
            $('#b-content__traffic-chart').hide();
        }       
    }   
    
    // Отрисовка месячной таблицы
    function renderLineTable() {
        //console.log('AAA renderLineTable ', dataLineChart);
        if(dataLineChart) {
                        
            var
                $table = $('#table-line'),
                $tableContent = $('<tbody>'),
                $tableBody = $table.find('tbody').first(),
                $tableFooter = $table.find('tfoot').first();
            
            var
                summ_views = 0,
                summ_clicks = 0,
                summ_ctr = 0;
            
            for(var i = dataLineChart['period'].length-1; i>=0; i-=1) {
                var date = dataLineChart['period'][i];
                var views = dataLineChart['views'][i];
                var clicks = dataLineChart['clicks'][i];
                var ctr = dataLineChart['ctr'][i];
                                
                summ_views += views;
                summ_clicks += clicks;
                
                $row = $('<tr>');
                
                $row.append($('<td>').html(date));
                $row.append($('<td>').html(views.formatMoney(0)));
                $row.append($('<td>').html(clicks.formatMoney(0)));
                $row.append($('<td>').html(formatPercent(ctr)));
                
                $row.appendTo($tableContent);
            }           
            
            summ_ctr = (summ_views == 0) ? 0 : summ_clicks/summ_views*1;
            
            $tableBody.html('').append($tableContent.children());
            $tableFooter.find('.summ-views').html(summ_views.formatMoney(0));
            $tableFooter.find('.summ-clicks').html(summ_clicks.formatMoney(0));
            $tableFooter.find('.summ-ctr').html(formatPercent(summ_ctr));
            
            var $lineTable = $('#table-line');
            $lineTable.removeClass('full').addClass('short');
            
            $('#b-content__traffic-table').show();            
        } else {
            $('#b-content__traffic-table').hide();
        }     
    }
    
    // Добавление информационных полей в данных
    function addDataFields(data)
    {
        
    }

    
    //renderSummaryReport();
    renderLineChart();
    
    $(selectorSummaryReport).on('render-summary-report', function(){
        loadDataSummuryReport();        
    });
    $domainsList.on('select-domain', function(){
        loadDataSummuryReport();        
        loadDataLineChart();
    });       
    
    $(selectorGraphChart).on('render-chart', function(){
        renderLineChart();
    });
    
    $(selectorGraphChart).on('reload-chart', function(){
        loadDataLineChart();        
    });
    
    
    // Клик на "Все сайты":
    $('.all-domains').click(function(){
        var $all = $('li.droplist-item[data-id="all"]');
        $all.click();
        return false;
    });
    
});