<?php
/**
 * Copyright (c) 2017 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Model;
use App\Entity\Tag;
use Monolog\Logger;
use Zend\Db\Sql\Select;
use Zend\Db\TableGateway\TableGateway;
use Zend\Hydrator\DelegatingHydrator;


/**
 * Class Articles
 * @package App\Model
 */
class Articles extends Common implements HideableInterface
{

    /**
     * @var Tags
     */
    protected $tagsModel;

    protected $relationTagsModel;

    private $foundRows = null;

    /**
     * Articles constructor.
     * @param TableGateway $tableGateway
     * @param DelegatingHydrator $delegatingHydrator
     * @param Tags $tags
     * @param Logger $logger
     * @param ArticlesHasTags $articlesHasTags
     */
    public function __construct(TableGateway $tableGateway, DelegatingHydrator $delegatingHydrator, Tags $tags, Logger $logger, ArticlesHasTags $articlesHasTags)
    {
        $this->tagsModel = $tags;
        $this->relationTagsModel = $articlesHasTags;

        parent::__construct($tableGateway, $delegatingHydrator, $logger);

    }

    public function findLimitWithTag($limit, $tag, $order = null)
    {

        $tags = $this->relationTagsModel->tableGateway->select(function (Select $select) {
            $select
                ->columns(['articles_id'])
                ->join($this->tagsModel->tableGateway);
            //@fixme incomplete refactoring. we should use correct join
            var_dump($select->getSqlString());
            die();
        });
        /** @var Tag $tag */
        foreach ($tags as $tag) {
            $tagsIds[] = $tag->getId();
        }
    }

    /**
     * Returns number of found rows for previous call of select with limit
     *
     * @return int
     * @throws \Exception
     */
    public function foundRows()
    {
        if ($this->foundRows) {
            $foundRows = $this->foundRows;
            // clear stored value to avoid incorrect result caching
            $this->foundRows = null;
        } else {
            $foundRows = parent::foundRows();
        }
        return $foundRows;
    }

}