<?php
/**
 * Copyright (c) 2017 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Service\Config\Writer;


/**
 * Class PhpArray
 * @package App\Service\Config\Writer
 */
class PhpArray extends \Zend\Config\Writer\PhpArray
{

    protected $detectConstants = true;

    /**
     * @return bool
     */
    public function isDetectConstants()
    {
        return $this->detectConstants;
    }

    /**
     * @param bool $detectConstants
     * @return PhpArray
     */
    public function setDetectConstants(bool $detectConstants)
    {
        $this->detectConstants = $detectConstants;
        return $this;
    }

    /**
     * @param string $key
     * @return string
     */
    protected function processStringKey($key)
    {
        if ($this->isDetectConstants() && defined($key)) {
            $result = $key;
        } else {
            $result = parent::processStringKey($key);

        }
        return $result;
    }

}