$(document).ready(function () {
    "use strict";
    
    // Добавление впереди 0 у однозначных значений
    function pad(number) {
        var r = String(number);
        if ( r.length === 1 ) {
          r = '0' + r;
        }
        return r;
    }
    
    // Форматирование даты
    function formatDate(date)
    {
        return date.getFullYear() +'-'+ pad(date.getMonth()+1) +'-'+ pad(date.getDate());
    }
    
    // Переключение состояния isLoadingStat
    function EnableLoadingState(isLoading)
    {
        if (isLoading) {
            $pager.addClass('state-loading');
            $table.addClass('state-loading');
            $exportExcelButton.hide();
            $tableLoader.show();
        } else {
            $pager.removeClass('state-loading');
            $table.removeClass('state-loading');
            $exportExcelButton.show();
            $tableLoader.hide();
        }
    }
    
    // Выбор даты http://t1m0n.name/air-datepicker/docs/index-ru.html
    var
    nowDate = new Date(),
    isLoadingStat = false,
    $table = $('table.table-striped'),
    $pager = $('.b-pager'),
    $pagerStep = $('.b-pager__step'),
    $pagerInfo = $('.b-pager__info'),
    $pagerItems = $('.b-pager__items'),
    $periodSelect = $('.order-period'),
    datepicker1 = $('#date-value-1').datepicker({
        dateFormat: "yyyy-mm-dd",
        autoClose: true,
        maxDate: nowDate,
        onSelect: function(data){
            $periodSelect.val('');
        }
    }).data('datepicker'),
    datepicker2 = $('#date-value-2').datepicker({
        dateFormat: "yyyy-mm-dd",
        autoClose: true,
        maxDate: nowDate,
        onSelect: function(data){
            $periodSelect.val('');
        }
    }).data('datepicker'),
    $totalOrdersCount = $('.total-orders-count'),
    $totalOrdersMoney = $('.total-orders-money'),
    $tableLoader = $('.table-data-loading'),
    $applyButton = $('.b-filters button.btn'),
    $exportExcelButton = $("#btnExport"),
    currentRequesData,
    currentFiltersUrl,
    currentSort,
    currentAsc,

    $filtersItems = $('.b-filters__items'),
    $filtersCurrent = $('.b-filters__current'),
    $filtersSitesZones = $('.b-filters_sites-zones'),
    
    $siteExclude = $('#site-exclude'),
    $zoneExclude = $('#zone-exclude'),
    
    $country = $('select.data-country', $filtersItems),
    $partner = $('select.data-partner', $filtersItems),
    $status = $('select.data-status', $filtersItems);
    
    // Выбор периода:
    $('.order-period').on('change', function(){
        var
            $this = $(this),
            period = $this.val(),
            todayDate = new Date();
            
        // Установка значений периода в дате:
        switch(period) {
            case 'today':
                datepicker1.selectDate(todayDate);
                datepicker2.selectDate(todayDate);
            break;
            case 'yesterday':
                var yesterdayDate = new Date();
                yesterdayDate.setDate(yesterdayDate.getDate()-1);
                datepicker1.selectDate(yesterdayDate);
                datepicker2.selectDate(yesterdayDate);
            break;
            case '7days':
                var prev7day = new Date();
                prev7day.setDate(prev7day.getDate()-7);
                datepicker1.selectDate(prev7day);
                datepicker2.selectDate(todayDate);
            break;
            case '30days':
                var prev30day = new Date();
                prev30day.setDate(prev30day.getDate()-30);
                datepicker1.selectDate(prev30day);
                datepicker2.selectDate(todayDate);
            break;
            case 'current_month':
                var firstDay = new Date(todayDate.getFullYear(), todayDate.getMonth(), 1);
                datepicker1.selectDate(firstDay);
                datepicker2.selectDate(todayDate);
            break;
            case 'prev_month':
                var firstDay = new Date(todayDate.getFullYear(), todayDate.getMonth()-1, 1);
                var lastDay = new Date(todayDate.getFullYear(), todayDate.getMonth(), 0);
                datepicker1.selectDate(firstDay);
                datepicker2.selectDate(lastDay);
            break;
            case 'year':
                var firstDay = new Date(todayDate.getFullYear(), 0, 1);
                datepicker1.selectDate(firstDay);
                datepicker2.selectDate(todayDate);
            break;
            default:
                datepicker1.clear();
                datepicker2.clear();
            break;
        }
        
        $this.val(period);
    });
    
    function selectOrdersData(isLocationHash)
    {
        var
            country = ($('select.data-country', $filtersCurrent).length>0) ? $('select.data-country', $filtersCurrent).val() : $country.val(),
            partner = ($('select.data-partner', $filtersCurrent).length>0) ? $('select.data-partner', $filtersCurrent).val() : $partner.val(),
            status = ($('select.data-status', $filtersCurrent).length>0) ? $('select.data-status', $filtersCurrent).val() : $status.val(),
            
            sitesFilter = null,
            zonesFilter = null,
            listSites = [],
            listZones = [],
            sitesExeclude = null,
            zonesExeclude = null,
            
            dates = null,
            datesValues = [],
            date0, date1,
            sort = currentSort,
            asc = currentAsc,
            filtersUrl = '',
            getHashVars = !(isLocationHash !== undefined && !isLocationHash);
    
        date0 = (datepicker1.selectedDates[0]) ? new Date(datepicker1.selectedDates[0]) : nowDate;
        date1 = (datepicker2.selectedDates[0]) ? new Date(datepicker2.selectedDates[0]) : nowDate;
        dates = [new Date(date0.getFullYear()+'-'+(date0.getMonth()+1)+'-'+date0.getDate()), new Date(date1.getFullYear()+'-'+(date1.getMonth()+1)+'-'+date1.getDate())];
        
        datesValues.push(formatDate(datepicker1.selectedDates[0]));
        datesValues.push(formatDate(datepicker2.selectedDates[0]));

        // Дата "от" позже, чем "до":
        if (dates[0] > dates[1]) {
            datepicker1.selectDate(date1);
            datepicker2.selectDate(date1);
            return false;
        }
        
        // Устанавливаем фильтры в url:
        if  (getHashVars) {
            filtersUrl += '&dates=' + datesValues.join(',');
            filtersUrl += (country) ? '&country=' + country : '';
            filtersUrl += (partner) ? '&partner=' + partner : '';
            filtersUrl += (status) ? '&status=' + status : '';
            filtersUrl += (sort) ? '&sort=' + sort : '';
            filtersUrl += (asc) ? '&asc=' + asc : '';
        }
        
        // Фильтры по сайтам-зонам:
        if ($('.b-filters_site .values-string-list li').length == 0) {
            if (currentFilters['sites_in']) {
                listSites = currentFilters['sites_in'];
                sitesExeclude = 0;
            }
            if (currentFilters['sites_not']) {
                listSites = currentFilters['sites_not'];
                sitesExeclude = 1;
            }
            if (currentFilters['zones_in']) {
                listZones = currentFilters['zones_in'];
                zonesExeclude = 0;
            }
            if (currentFilters['zones_not']) {
                listZones = currentFilters['zones_not'];
                zonesExeclude = 1;
            }
            
        } else {
            $('.b-filters_site .values-string-list li').each(function(){
                listSites.push($('input', $(this)).data('id'));
            });
            sitesExeclude = ($siteExclude.is(':checked')) ? 1 : 0;
            
            $('.b-filters_zone .values-string-list li').each(function(){
                listZones.push($('input', $(this)).data('id'));
            });
            zonesExeclude = ($zoneExclude.is(':checked')) ? 1 : 0;
        }
        
        
        if (listSites.length > 0) {
            sitesFilter = {
                'exclude': sitesExeclude,
                'list': listSites
            };

            if (sitesFilter.exclude) {
                filtersUrl += '&sites_not=' + sitesFilter.list.join(',');
            } else {
                filtersUrl += '&sites_in=' + sitesFilter.list.join(',');
            }
        }
        if (listZones.length > 0) {
            zonesFilter = {
                'exclude': zonesExeclude,
                'list': listZones
            };

            if (zonesFilter.exclude) {
                filtersUrl += '&zones_not=' + zonesFilter.list.join(',');
            } else {
                filtersUrl += '&zones_in=' + zonesFilter.list.join(',');
            }
        }
        
        filtersUrl = (filtersUrl == '') ? '' : '#' + filtersUrl;
        history.replaceState( {} , null, location.pathname + filtersUrl);
        
        
        // Запрос данных в соответствии с установленнымифильтрами:
        var requestData = {
            action: 'list', 
            dates: datesValues
        };
        if (country) requestData['country'] = country;
        if (partner) requestData['partner'] = partner;
        if (status) requestData['status'] = status;
        if (sort) requestData['sort'] = sort;
        if (asc) requestData['asc'] = asc;
        if (sitesFilter) requestData['sites'] = sitesFilter;
        if (zonesFilter) requestData['zones'] = zonesFilter;
        
        setFiltersControls(requestData);
        
        currentRequesData = requestData;
        currentFiltersUrl = filtersUrl
        
        requestDataFilters(requestData);
    }

    // Запрос данных для таблицы, в соответствии с фильтрами:
    function requestDataFilters(dataRequest)
    {
        //console.log('AAA requestDataFilters ', dataRequest);
        dataRequest['step'] = parseInt($('select', $pagerStep).val());
        
        isLoadingStat = true;
        EnableLoadingState(isLoadingStat);
        
        $.ajax({
            url: $applyButton.attr('data-link'),
            method: 'POST',
            data: dataRequest,
            success: function(res) {
                isLoadingStat = false;
                EnableLoadingState(isLoadingStat);
                
                if (res == null) {
                    console.log("AAA requestDataStatReport success res: NULL");
                } else if (res.status == 'Error') {
                    console.log("AAA requestDataStatReport error");
                } else {
                    //console.log("AAA requestDataStatReport success res: SUCCESS", res);
                    renderOrdersTable(res.data);
                    renderPager([res.pager, res.info]);
                    renderInfo(res.total);
                    markSortTable(res.sort);
                }
            },
            error: function (e) {
                console.log('error: ', e);
                isLoadingStat = false;
                EnableLoadingState(isLoadingStat);
            }
        });
        
    }
    
    // Отрисовка таблицы:
    function renderOrdersTable(data)
    {
        var 
            $tableBody = $('tbody', $table),
            $tableContent = $('<tbody>');

        for (var i = 0; i < data.length; i++) {
            //console.log('AAA order = ', data[i]);
            var
                itemOrder = data[i],
                date = (itemOrder.Timestamp).split(' '),
                statusStyle;
        
            switch(itemOrder.status) {
                case 'new': statusStyle = 'color: #deb30b;'; break;
                case 'lead': statusStyle = 'color: #337ab7;';break;
                case 'sale': statusStyle = 'color: #009444;'; break;
                case 'reject': statusStyle = 'color: #FF0909;'; break;
                case 'decline': statusStyle = 'color: #8F0909;'; break;
            }
            
            var $orderTr = $('<tr data-order="' + itemOrder.OrderID + '" data-status="' + itemOrder.status + '" data-country="' + itemOrder.Country + '" data-partner="' + itemOrder.PartnerID + '" data-timestamp="' + itemOrder.Timestamp + '">');
            $('<td class="is-br"><span class="item-id">' + itemOrder.OrderID + '</span></td>').appendTo($orderTr);
            $('<td class="is-br"><span class="item-timestamp">' + date[0] + '</span><br /><b>' + date[1] + '</b></td>').appendTo($orderTr);
            $('<td class="is-br"><span class="item-browser"><b>' + itemOrder.BrowserNameRaw + '</b><br />' + itemOrder.BrowserVerRaw + '</span></td>').appendTo($orderTr);
            $('<td class="is-br"><span class="item-country"><b>' + itemOrder.Country + '</b><br />' + itemOrder.IP + '</span></td>').appendTo($orderTr);
            $('<td class="is-br"><span class="item-site"><b>' + itemOrder.site_id + '</b><br /><span class="zone-id">' + itemOrder.zone_id + '</span></span></td>').appendTo($orderTr);
            
            if (itemOrder.OfferID) {
                var offerLink = '/ru/offers-system/offer/' + itemOrder.OfferID + '/';
                $('<td class="is-br"><a href="' + offerLink + '"><span class="item-offer"><b>' + itemOrder.offer_title + '</b></span></a><br />' + itemOrder.ad_id + '</td>').appendTo($orderTr);
            } else {
                $('<td class="is-br"><span class="item-offer">' + itemOrder.offer_title + '</span><br />' + itemOrder.ad_id + '</td>').appendTo($orderTr);
            }
            
            $('<td class="is-br"><span class="item-land">[' + itemOrder.land_id + ']&nbsp;' + itemOrder.land_title + '<br /><b>' + itemOrder.AdDataID + '</b>, ' + itemOrder.partner_name + '</span></td>').appendTo($orderTr);
            $('<td class="is-br" style="' + statusStyle + '"><span class="item-status">' + itemOrder.status + '</span></td>').appendTo($orderTr);
            $('<td class="is-br"><span class="item-price"><b>' + itemOrder.sale_price + ' $</b></span></td>').appendTo($orderTr);
            
            $orderTr.appendTo($tableContent);
        }

        $tableBody.html('').append($tableContent.children());
        
    }
    
    // Отрисовка сводной инфо:
    function renderInfo(info)
    {
        $totalOrdersCount.text(info.count);
        $totalOrdersMoney.text(Math.round(info.sum*100)/100 + ' $');
    }

    // Отрисовка пейджера:
    function renderPager(dataPager)
    {
        var
            data = dataPager[0],
            info = dataPager[1];
        
        if (data) {
            var $pagerContent = $('<ul>');

            // Отображать "<"
            if (data[1] > 1) {
                $('<li data-page="' + (data[1]-1) + '"> &lt; </li>').appendTo($pagerContent);
            }
            // Страниц не больше 7
            if (data[0] < 8) {
                for (var i = 0; i < data[0]; i++) {
                    $('<li' + ((i+1 == data[1]) ? ' class="current"' : '') + ' data-page="' + (i+1) + '">' + (i+1) + '</li>').appendTo($pagerContent);
                }
            } else {
                if (data[1]<5) {
                    for (var i = 0; i < 5; i++) {
                        $('<li' + ((i+1 == data[1]) ? ' class="current"' : '') + ' data-page="' + (i+1) + '">' + (i+1) + '</li>').appendTo($pagerContent);
                    }
                    $('<li class="not-active"> ... </li>').appendTo($pagerContent);
                    $('<li data-page="' + data[0] + '">' + data[0] + '</li>').appendTo($pagerContent);
                }
                if (data[1]>=5 && data[1]<=data[0]-3) {
                    $('<li data-page="' + 1 + '">' + 1 + '</li>').appendTo($pagerContent);
                    $('<li class="not-active"> ... </li>').appendTo($pagerContent);
                    for (var i = data[1]-2; i < data[1]+1; i++) {
                        $('<li' + ((i+1 == data[1]) ? ' class="current"' : '') + ' data-page="' + (i+1) + '">' + (i+1) + '</li>').appendTo($pagerContent);
                    }
                    $('<li class="not-active"> ... </li>').appendTo($pagerContent);
                    $('<li data-page="' + data[0] + '">' + data[0] + '</li>').appendTo($pagerContent);
                }
                if (data[1]>data[0]-3) {
                    $('<li data-page="' + 1 + '">' + 1 + '</li>').appendTo($pagerContent);
                    $('<li class="not-active"> ... </li>').appendTo($pagerContent);
                    for (var i = data[0]-5; i < data[0]; i++) {
                        $('<li' + ((i+1 == data[1]) ? ' class="current"' : '') + ' data-page="' + (i+1) + '">' + (i+1) + '</li>').appendTo($pagerContent);
                    }
                }
            }
            // Отображать ">"
            if (data[1] < data[0]) {
                $('<li data-page="' + (data[1]+1) + '"> &gt; </li>').appendTo($pagerContent);
            }
            
            $pagerItems.html('').append($pagerContent);
        }
        
        if (info) {
            $('.from', $pagerInfo).text(info.items_interval[0]);
            $('.to', $pagerInfo).text(info.items_interval[1]);
            $('.total', $pagerInfo).text(info.items_count);
        }
    }
    
    // Показываем сортировку в таблице:
    function markSortTable(dataSort)
    {
        var $sortTr = $('thead th span[data-sort="' + dataSort[0] + '"]', $table);
        $('thead th span', $table).removeClass('current').removeClass('asc').removeClass('desc');
        $sortTr.addClass('current').addClass((dataSort[1]>0) ? 'desc' : 'asc').attr('data-sortasc', (dataSort[1]>0) ? -1 : 1);
    }
    

    // Распарсиваем строку URL с фильтрами:
    var
        hashUrl = location.hash.replace('#', '').split('&'),
        filtersNames = ['dates', 'country', 'status', 'partner', 'sites_in', 'sites_not', 'zones_in', 'zones_not'],
        currentFilters = [];

    hashUrl.forEach(function(item) {
        if (item != '' && item.indexOf('=')>-1) {
            var
                filterItem = item.split('='),
                filterName = filterItem[0],
                filterValue = (filterItem[1] == '') ? null : filterItem[1].split(',');
            
            if (filtersNames.indexOf(filterName) != -1 && filterValue) {
                currentFilters[filterName] = filterValue;
            }
        }
    });
    
    
    // Устанавливаем фильтры по url:
    if (Object.keys(currentFilters).length > 0) {
        setFiltersControls(currentFilters);
        if (currentFilters['dates']) {
            datepicker1.selectDate(new Date(currentFilters['dates'][0] + ' 00:00:00'));
            datepicker2.selectDate(new Date(currentFilters['dates'][1] + ' 00:00:00'));
        };
        if (currentFilters['sort']) currentSort = currentFilters['sort'][0];
        if (currentFilters['asc']) currentAsc = currentFilters['asc'][0];
    } else {
        // Установка стартовых значений дат:
        datepicker1.selectDate(nowDate);
        datepicker2.selectDate(nowDate);
        $periodSelect.val('today');
        $status.val('leadOrSaleOrNew');
    }
    

    // Стартовая фильтрация:
    var isLocationHash = (location.hash == "") ? false : true;
    selectOrdersData(isLocationHash);
    
    function setCurrentFilters(filtersUrl)
    {
        var
            hashUrl = filtersUrl.replace('#', '').split('&'),
            currentFilters = [];
    
        hashUrl.forEach(function(item) {
            if (item != '' && item.indexOf('=')>-1) {
                var
                    filterItem = item.split('='),
                    filterName = filterItem[0],
                    filterValue = (filterItem[1] == '') ? null : filterItem[1].split(',');

                if (filtersNames.indexOf(filterName) != -1 && filterValue) {
                    currentFilters[filterName] = filterValue;
                }
            }
        });

        // Устанавливаем фильтры по url:
        if (Object.keys(currentFilters).length > 0) {
            if (currentFilters['dates']) {
                datepicker1.selectDate(new Date(currentFilters['dates'][0] + ' 00:00:00'));
                datepicker2.selectDate(new Date(currentFilters['dates'][1] + ' 00:00:00'));
            };
        } else {
            datepicker1.selectDate(nowDate);
            datepicker2.selectDate(nowDate);
            $periodSelect.val('today');
        }
        setFiltersControls(currentFilters);
    }
    
    // Клик на "Применить"
    $applyButton.click(function(){
        selectOrdersData();
    });
    
    // Клик на страницу пейджера:
    $pager.on('click', 'li', function(){
        var
            $pagerItem = $(this);
        if (!$pagerItem.hasClass('current')) {
            currentRequesData['page'] = parseInt($pagerItem.text());
            setCurrentFilters(currentFiltersUrl);
            requestDataFilters(currentRequesData);
        }
    });
    
    // Смена шага пейджера:
    $('select', $pagerStep).on('change', function(){
        var $stepValue = $(this).val();
        $('select', $pagerStep).val($stepValue);
        currentRequesData['page'] = null;
        setCurrentFilters(currentFiltersUrl);
        requestDataFilters(currentRequesData);
    });
    
    // Сортировка в таблице:
    $('table.table-striped thead th span.sort').on('click', function(){
        var
            $this = $(this),
            sort = $this.data('sort'),
            asc = $this.attr('data-sortasc'),
            filtersSortUrl = '',
            currentSortUrl = '';
            
        if (currentRequesData['sort']) {
            currentSortUrl += '&sort=' + currentRequesData['sort'];
        }
        if (currentRequesData['asc']) {
            currentSortUrl += '&asc=' + currentRequesData['asc'];
        }
        
        currentRequesData['sort'] = sort;
        currentRequesData['asc'] = asc;
        
        currentSort = sort;
        currentAsc = asc;
        
        if (currentSortUrl) {
            currentFiltersUrl = currentFiltersUrl.replace(currentSortUrl, '');
        }
        
        // Добавляем фильтры в url:
        filtersSortUrl += '&sort=' + sort + '&asc=' + asc;
        filtersSortUrl = (currentFiltersUrl == '') ? '#' + filtersSortUrl : currentFiltersUrl + filtersSortUrl;
        
        history.replaceState( {} , null, location.pathname + filtersSortUrl);
        
        setCurrentFilters(currentFiltersUrl);
        requestDataFilters(currentRequesData);
    });
    
    // Выгрузка таблицы в Excel
    $exportExcelButton.click(function(){
        $("#table2excel").table2excel({
            exclude: ".noExl",
            name: "Worksheet Name",
            filename: "Orders"
        });
    });
    
    // Управление отображением фильтров:
    (function(){
        var
            $filtersShow = $('.b-filters__show'),
            $filtersSitesShow = $('.b-filters-sites-zones__show');
        
        // Показать фильтры:
        $filtersShow.on('click', function(){
           $filtersItems.toggle();
        });
        // Показать фильтры по сайтам-зонам:
        $filtersSitesShow.on('click', function(){
           $filtersSitesZones.toggle();
        });
        
    })();
    
    // Фильтры по странам-зонам:
    (function(){
        
        var
            $filtersItems = $('.b-filters_site, .b-filters_zone'),
            $sitesList = $('.b-filters_site .values-string-list');
        
        // Запрос списка фильтров:
        function RequestFilters() {
            
            // Подгружаем список фильтров:
            
            var
                templateSiteItem = _.template('' +
                    '<li>' +
                    '    <input type="checkbox" id="site-id-<%= site.site_id %>" data-id="<%= site.site_id %>" data-text="<%= site.domain %>">' +
                    '    <label for="site-id-<%= site.id %>">[<%= site.site_id %>] <%= site.domain %></label>' +
                    '</li>'
                ),
                templateZoneItem = _.template('' +
                    '<li data-site="<%= data[\'site_id\'] %>" data-domain="<%= data[\'domain\'] %>">' +
                    '    <input type="checkbox" id="zone-id-<%= zoneId %>" data-id="<%= zoneId %>" data-text="<%= zoneId %>" data-size="<%= data[\'size\'] %>">' +
                    '    <label for="zone-id-<%= zoneId %>"><%= zoneId %> [<%= data[\'size\'] %>] - <%= data[\'domain\'] %></label>' +
                    '</li>'
                );
               
            var
                $filtersSitesZonesControls = $('.b-filters_sites-zones button, .b-filters_sites-zones input'),
                $filtersSitesZonesWrap = $('.b-filters_sites-zones');

            $filtersSitesZonesControls.prop('disabled', true);
            $filtersSitesZonesWrap.addClass('state-loading');
            
            // Запрашиваем списки сайтов и зон:
            $.ajax({
                url: $applyButton.attr('data-link'),
                method: 'POST',
                data: {
                    action: 'siteszoneslist',
                },
                success: function(sitesZonesList) {
                    
                    if (sitesZonesList) {
                        var
                            $sitesListWrap = $('.b-filters_site .list-filter'),
                            $zonesListWrap = $('.b-template-zones-list');
                    
                        sitesZonesList.forEach(function(item) {
                            $sitesListWrap.append(templateSiteItem({site: item}));
                            
                            item['zones'].forEach(function(zone) {
                                $zonesListWrap.append(templateZoneItem({zoneId: zone[0], data: {site_id: item['site_id'], domain: item['domain'], size: zone[1]}}));
                            });
                        });
                    }
                    
                    $filtersSitesZonesControls.prop('disabled', false);
                    $filtersSitesZonesWrap.removeClass('state-loading');
                    
                    SetCurrentFilters(currentFilters, 'sites');
                    SetCurrentFilters(currentFilters, 'zones');
                    
                    
                },
                error: function (e) {
                    console.log('error siteslist: ', e);
                }
            });

        }
        
        // Устанавливаем значения для текущих фильтров:
        function SetCurrentFilters(currentFilters, type)
        {
            var
                filtersVars = ['sites_in', 'sites_not', 'zones_in', 'zones_not'],
                isFiltersInCurrent = false;
            
            filtersVars.forEach(function(item) {
                isFiltersInCurrent = (currentFilters[item]) ? true : isFiltersInCurrent;
            });
            
            if (!isFiltersInCurrent) {
                return false;
            }
            
            // Разворачиваем фильтры:
            $filtersSitesZones.show();
            
            switch(type) {
                case 'sites':
                    if (currentFilters.sites_in || currentFilters.sites_not) {
                        if (currentFilters.sites_not) {
                            $siteExclude.prop("checked", true);
                        }
                        (currentFilters.sites_in || currentFilters.sites_not).forEach(function(item) {
                            $('.b-filters_site .list-filter input[data-id="' + item + '"]').click();
                        });
                    }
                break;
                case 'zones':
                    if (currentFilters.zones_in || currentFilters.zones_not) {
                        if (currentFilters.zones_not) {
                            $zoneExclude.prop("checked", true);
                        }
                        (currentFilters.zones_in || currentFilters.zones_not).forEach(function(item) {
                            $('.b-filters_zone .list-filter input[data-id="' + item + '"]').click();
                        });
                    }
                break;
            }
        }
        
        // Обработка изменения в списках сайтов-фильтров:
        function ChangeListSites() {

            var
                $filtersZone = $('.b-filters_zone'),
                $sitesItems = $('.b-filters_site .values-string-list li'),
                noFilterSites = ($sitesItems.length == 0) ? true : false,
                $selectedZones = $('.b-filters_zone .values-string-list'),
                $listZones = $('.b-filters_zone .list-filter');

            // Пустой список фильтров-сайтов:
            if (noFilterSites) {
                
                $filtersZone.hide();
                $selectedZones.empty();
                $listZones.empty();
                
            } else {
                
                $listZones.empty();
                $sitesItems.each(function(){
                    
                    var
                        siteId = $('input', $(this)).data('id'),
                        $zoneItems = $('.b-template-zones-list li[data-site="'+ siteId +'"]').clone(),
                        $input,
                        $label,
                        zoneId;
                    
                    $zoneItems.each(function(ind, $zoneItem){
                        $input = $('input', $zoneItem),
                        $label = $('label', $zoneItem),
                        zoneId = $input.attr('id');

                        $input.attr('id', 'm_' + zoneId);
                        $label.attr('for', 'm_' + zoneId);
                    });
                    
                    $listZones.append($zoneItems);
                });
                
                // Логика выставления галочек уже выбранных зон:
                $('li', $selectedZones).each(function(){
                    var
                        //zoneItemId = $(this).data('id'),
                        zoneItemId = $('input', $(this)).data('id'),
                        $zoneItem = $('input[data-id="' + zoneItemId + '"]', $listZones);
                    
                    // Удаления зоны из списка при удалении её сайта:
                    if ($zoneItem.length == 0) {
                        $(this).remove();
                    } else {
                        $zoneItem.attr('checked', true);
                    }
                });
                
                $filtersZone.show();
            }
        }
        
        RequestFilters();
        
        // Изменение списка фильтров чекбоксом:
        $filtersItems.on('change', '.list-filter input',function(){
            
            var
                $listItems = $('li', $(this).parents('ul')),
                $listString = $('.values-string-list', $(this).parents('.form-group')[0]),
                values = [],
                tplId = ($(this).parents('.b-filters_site').length) ? 'l-site-id-' : 'l-zone-id-';
            
            $listItems.each(function(){
                var
                    $this = $(this),
                    $checkbox = $('input', $this);
                    
                if ($checkbox.is(':checked')) {
                    values.push([$checkbox.data('id'), $checkbox.data('text')]);
                }
            });
            
            $listString.empty();
            if (values.length > 0) {
                values.forEach(function(valuesItem) {
                    $listString.append('<li><input type="checkbox" checked id="' + tplId + valuesItem[0] + '" data-id="' + valuesItem[0] + '" data-text="' + valuesItem[1] + '"> <label for="' + tplId + valuesItem[0] + '">[' + valuesItem[0] + '] ' + valuesItem[1] + '</label></li>');
                });
            }
            $listString.trigger('change');
        });
        
        // Изменение фильтрации внутри фильтра:
        $filtersItems.on('keyup', 'input.filter',function(){
            var
                $this = $(this),
                val = $this.val(),
                $listItems = $('.filters-select li', $this.parents('.form-group'));
            
            // Фильтрация списка сайтов:
            if ($this.attr('name') == 'sites-filter') {
                $listItems.each(function(){
                    var
                        $item = $(this),
                        id = $('input', $item).data('id').toString(),
                        domain = $('input', $item).data('text'),
                        reg = new RegExp("^\\d+"+val+"$", "i");
                    
                    $item.hide();
                    if (domain.indexOf(val) == 0 || id.match(reg)) {
                        $item.show();
                    }
                    
                });
            }
            
            // Фильтрация списка зон:
            if ($this.attr('name') == 'zones-filter') {
                $listItems.each(function(){
                    var
                        $item = $(this),
                        id = $('input', $item).data('id').toString(),
                        size = $('input', $item).data('size'),
                        width = size.split('x')[0],
                        height = size.split('x')[1],
                        reg = new RegExp("^\\d+"+val+"$", "i");
                    
                    $item.hide();
                    if (size == val || width == val || height == val || id.match(reg)) {
                        $item.show();
                    }
                    
                });
            }
            
        });
        
        
        // Удаление из списка фильтров снятием галочки:
        $filtersItems.on('change', '.values-string-list input',function(){
            var
                itemId = $(this).data('id'),
                $listFilterItem = $('.list-filter input[data-id="' + itemId + '"]', $(this).parents('.form-group'));
            
            $listFilterItem.attr('checked', false);
            $listFilterItem.change();
        });
        
        // Отслеживаем изменение в списках сайтов:
        $sitesList.on('change', function(){
            ChangeListSites();
        });
        
    })();
    
    // Устанавливаем набор фильтров по данным:
    function setFiltersControls(filters)
    {
        var
            filtersList = ['status', 'partner', 'country', 'sites_in', 'sites_not', 'zones_in', 'zones_not'],
            name;
        
        $filtersCurrent.empty();
        
        if (Object.keys(filters).length > 0) {
            filtersList.forEach(function(item) {
                name = item;
                var $filterItemList = $('.form-group.' + name).parents('.b-filters__list-item');
                if (filters[item]) {
                    
                    var $itemFilter = $filterItemList.clone();
                    
                    $('select.form-control', $itemFilter).val(filters[name]);
                    $('select.form-control.data-' + name, $filtersItems).val(filters[name]);
                    $filterItemList.hide();
                    $itemFilter.show();
                    $filtersCurrent.append($itemFilter);
                    
                    if (['sites_in', 'sites_not', 'zones_in', 'zones_not'].indexOf(name)>-1) {
                        $filtersSitesZones.show();
                    }
                    
                } else {
                    $('select.form-control.data-' + name, $filtersItems).val('');
                    $filterItemList.show();
                }
            });
        }
            
    }
    
    
});