$(document).ready(function () {
    "use strict";
    
    /* Стр. кампании пользователя */
    
    (function(){
        
        // Переключение данных вкладок для отображения
        var
            $switchItems = $('.switch-item'),
            $formGroups = $('.form-group-data'),
            classSelected = 'selected';

        $switchItems.on('click', function(){
            var
                $this = $(this),
                type = $this.data('type');
                
            $switchItems.removeClass(classSelected);
            $this.addClass(classSelected);

            $formGroups.removeClass(classSelected);
            $('.form-group-data[data-type="' + type + '"]').addClass(classSelected);
        });
    
    })();
    
    // Превьюшки:
    (function(){
        
        var
            $popupBg = $('.l-popup'),
            $popup = $('.b-popup__window.preview', $popupBg),
            $popupClose = $('.button-close', $popup),
            $popupInner = $('.b-popup-content', $popup),
            $popupMessage = $('.b-popup-message', $popup),
            $banners = $('.form-group.banners'),
            $tableBanners = $('table.campaign-banners', $banners);
        
        // Открываем попап:
        $tableBanners.on('click', '.banner-preview', function(){
            var
                $this = $(this),
                size = $.trim($('.banner-size', $this.parents('tr')).text()),
                data = {
                    id: $this.parents('tr').data('id'),
                    size: size.split('x'),
                    img: $this.attr('src')
                };
                
            ShowPopup(data);
        });
        
        // Закрыввем попап по клику на Х:
        $popupClose.on('click', function(){
            ClosePopup();
        });
        // Закрыввем попап по клику извне:
        $popup.on('click', function(event){
            event.stopPropagation();
        });
        $popupBg.on('click', function(){
            ClosePopup();
        });
        
        function ShowPopup(data)
        {
            var $content = $(document.createElement('div'));
            $content.append('<h2>id: <b>'+ data.id +'</b> <span>('+ data.size[0] +'х'+ data.size[1] +')</span></h2>');
            $content.append('<div class="banner-img"><img width="' + data.size[0] + '" height="' + data.size[1] + '" src="' + data.img + '" /></div>');
            
            $popupInner.append($content)
            
            $popupBg.addClass('open-popup');
            $popup.show();
        }
        
        function ClosePopup()
        {
            $popupBg.removeClass('open-popup');
            $popupMessage.hide();
            $popup.hide();
            $popupInner.empty();
        }
        
        
    })();
    
    // Статистика по кампании:
    (function(){
        
        var
            dataStat, dataStatTotal,
            $statWrap = $('.campaign-stat'),
            $statInfo = $('.chart-graph-stat-info', $statWrap),
            $statError = $('.chart-graph-stat-error', $statWrap),
            selectorStatChart = '#chart-graph-stat',
            $statChart = $(selectorStatChart, $statWrap),
            $statTableWrap = $('.b-table_wrapp', $statWrap),
            $tableCommonStat = $('#table-line-common', $statTableWrap),
            chart,
            activeLine,
            activeLines,
            activeLinesId,
            currencyFields = ['money'],
            dateTimeFields = ['period'],
            
            $tableContent = $('<tbody>'),
            $tableCommonBody = $tableCommonStat.find('tbody').first(),
            
            nowDate = new Date(),
            $dateFrom = $('.campaign-date-begin'),
            $dateTo = $('.campaign-date-end'),
            datepicker1 = $dateFrom.datepicker({
                dateFormat: "yyyy-mm-dd",
                autoClose: true,
                maxDate: nowDate,
                onSelect: function(fd, d, picker) {
                    selectDatePicker(fd, d, picker);
                },
            }).data('datepicker'),
            datepicker2 = $dateTo.datepicker({
                dateFormat: "yyyy-mm-dd",
                autoClose: true,
                maxDate: nowDate,
                onSelect: function(fd, d, picker) {
                    selectDatePicker(fd, d, picker);
                },
            }).data('datepicker'),
            
            dataSitesStat,
            $statSitesWrap = $('.form-group-data.stat-sites'),
            $statSitesInfo = $('.sites-stats-info', $statRegionsWrap),
            $statSitesError = $('.sites-stats-error', $statSitesWrap),
            $statSitesTableWrap = $('.b-table_wrapp', $statSitesWrap),
            $tableSites = $('#table-line-sites'),
            $tableSitesBody = $tableSites.find('tbody').first(),
            
            dataRegionsStat,
            $statRegionsWrap = $('.form-group-data.stat-regions'),
            $statRegionsInfo = $('.regions-stats-info', $statRegionsWrap),
            $statRegionsError = $('.regions-stats-error', $statRegionsWrap),
            $statRegionsTableWrap = $('.b-table_wrapp', $statRegionsWrap),
            $tableRegions = $('#table-line-regions'),
            $tableRegionsBody = $tableRegions.find('tbody').first(),
            codeRegions, codeCities,
            regionName, cityName;
            
            
        // Добавление впереди 0 у однозначных значений
        function pad(number) {
            var r = String(number);
            if ( r.length === 1 ) {
              r = '0' + r;
            }
            return r;
        }
        
        // Форматирование даты
        function formatDate(date)
        {
            return date.getFullYear() +'-'+ pad(date.getMonth()+1) +'-'+ pad(date.getDate());
        }
        
        // Форматирование значений для графика
        function valueFormat(value, ratio, id)
        {
            var
                dataLine = activeLinesId[parseInt(id.replace('data', '')) - 1],
                isCurrencyValue = currencyFields.indexOf(dataLine) > -1,
                format = (isCurrencyValue) ? d3.format(',.2f') : d3.format(',.0f');
            
            if (parseFloat(format(value)) == 0 && value != 0) {
                var accuracy = Math.abs(Math.floor(Math.log10(value)));
                return value.toFixed(accuracy);
            }

            if (isCurrencyValue || (['cpm', 'cpc'].indexOf(dataLine) > -1)) {
                return format(value) + ' &#8372;';
            } else {
                return format(value);
            }
        }

        // Форматирование значений меток для графика
        function valueFormatTick(value)
        {
            var
                isCurrencyValue = currencyFields.indexOf(activeLine) > -1,
                format = (isCurrencyValue) ? d3.format(',.2f') : d3.format(',.0f');

            return format(value);
        }

        // Форматирование значений для таблицы
        function valueFormatTable(value, currentActiveLine)
        {
            var
                isCurrencyValue = currencyFields.indexOf(currentActiveLine) > -1,
                format = d3.format(',.0f');

            if (isCurrencyValue)            format = d3.format(',.2f');
            if (currentActiveLine == 'ctr') format = d3.format(',.2f');
            if (currentActiveLine == 'cpc') format = d3.format(',.1f');

            if (isCurrencyValue)            return format(value) + ' &#8372;';
            if (currentActiveLine == 'ctr') return format(value) + ' %';
            if (currentActiveLine == 'cpm') return format(value) + ' &#8372;';
            if (currentActiveLine == 'cpc') return format(value) + ' &#8372;';

            return format(value);
        }
        
        // Получение данных для отрисовки графика Stat при старте:
        if ($('#campaign-stat').val() && $('#campaign-stat-total').val()) {
            dataStat = JSON.parse($('#campaign-stat').val());
            dataStatTotal = JSON.parse($('#campaign-stat-total').val());
        } else {
            ShowCommonStatError();
        }
        
        // Получение данных для статистики по сайтам:
        if ($('#campaign-sites-stat').val()) {
            dataSitesStat = JSON.parse($('#campaign-sites-stat').val());
        } else {
            ShowSitesStatError();
        }
        
        // Получение данных для статистики по регионам:
        if ($('#campaign-regions-stat').val()) {
            dataRegionsStat = JSON.parse($('#campaign-regions-stat').val());
        } else {
            ShowRegionsStatError();
        }
        
        // Получение конфигов-кодов регионов и городов:
        if ($('#regions-codes').val()) {
            codeRegions = JSON.parse($('#regions-codes').val());
        }
        if ($('#cities-codes').val()) {
            codeCities = JSON.parse($('#cities-codes').val());
        }
        
        console.log('AAA dataStat = ', dataStat);
        
        function ShowCommonStatInfo()
        {
            $statInfo.show();
            $statError.hide();
            $statChart.hide();
            $statTableWrap.hide();
        }

        function ShowSitesStatInfo()
        {
            $statSitesInfo.show();
            $statSitesError.hide();
            $statSitesTableWrap.hide();
        }
        
        function ShowRegionsStatInfo()
        {
            $statRegionsInfo.show();
            $statRegionsError.hide();
            $statRegionsTableWrap.hide();
        }

        function ShowCommonStatError()
        {
            $statError.show();
            $statInfo.hide();
            $statChart.hide();
            $statTableWrap.hide();
        }
        
        function ShowSitesStatError()
        {
            $statSitesError.show();
            $statSitesInfo.hide();
            $statSitesTableWrap.hide();
        }
        
        function ShowRegionsStatError()
        {
            $statRegionsError.show();
            $statRegionsInfo.hide();
            $statRegionsTableWrap.hide();
        }
        
        function EnableLoadingState($target, isLoading)
        {
            var $loading = $('.b-content__loading', $target);
            if (isLoading) {
                $loading.show();
            } else {
                $loading.hide();
            }
        }
        
        function getCheckedCategories() {
            var listCats = [];
            $('thead th input[type="checkbox"]', $tableCommonStat).each(function(){
                if ($(this).is(":checked")) {
                    listCats.push($(this).data('field'));
                }
            });
            return listCats;
        }
        
        function renderCommonChart() {
            
            var
                dataPeriod = dataStat['period'],
                rotateX = null,
                formatTimeX = '%m-%d',
                selectedCategoriesId;

            var
                dataColumnsTemp = [['x'].concat(dataPeriod)],
                names = {},
                types = {},
                axes = {},
                colors = {};

            // Определяем выбранные категории для графика:
            selectedCategoriesId = getCheckedCategories();

            // Скрываем график, если в таблице не выбраны категории:
            if (selectedCategoriesId.length == 0) {
                $statChart.hide();
                return false;
            } else {
                $statChart.show();
            }
            
            var i = 0;
            Object.keys(activeLines).forEach(function(activeLineItem){
                if (selectedCategoriesId.indexOf(activeLineItem) > -1) {
                    i++;
                    dataColumnsTemp.push(['data'+i].concat(dataStat[activeLineItem]));
                    names['data'+i] = activeLines[activeLineItem]['title'];
                    types['data'+i] = 'area-spline';
                    axes['data'+i] = 'y';
                    colors['data'+i] = activeLines[activeLineItem]['color'];
                }
            });
            
            chart = c3.generate({
                bindto: selectorStatChart,
                data: {
                    x: 'x',
                    columns: dataColumnsTemp,
                    names: names,
                    types: types,
                    axes: axes,
                    colors: colors,
                },
                axis: {
                    x: {
                        type: 'timeseries',
                        categories: dataPeriod,
                        padding: {left: 0},
                        tick: {
                            culling: {max: 25},
                            format: formatTimeX,
                            rotate: rotateX
                        }
                    },
                    y: {
                        min: 0,
                        padding: {top: 50, bottom: 0},
                        tick: {
                            format: valueFormatTick
                        }
                    }
                },
                grid: {
                    x: {show: true},
                    y: {show: true},
                },
                tooltip: {
                    format: {
                        title: formatDate,
                        value: valueFormat
                    }
                },
                legend: {
                    show: true,
                    item: {
                        onclick: function (id) {
                            //toggleData(chart, id);
                        }
                    }
                },
            });

            // Подсвечиваем Определяем индексы воскресенья:
            dataPeriod.forEach(function(date, ind) {
                if ((new Date(date)).getUTCDay() == 0) {
                    $('.c3-axis.c3-axis-x .tick').eq(ind).attr('class', 'tick sunday');
                }
            });
            
            //chart.toggle(toggelDates);
            
        };
        
        function renderCommonTable() {
            
            var
                dataTable = dataStat,
                dataPeriod = dataStat['period'],
                dataTableForSort = [],
                $selectedField = $('thead th b.selected', $tableCommonStat),
                $row,
                sortField = false,
                isDesc = true;

            // Определение поля для сортировки строк в таблице:
            if ($selectedField.length > 0) {
                sortField = $selectedField.attr('id');
                isDesc = $selectedField.hasClass('desc');
            }
            if (!sortField) {
                sortField = 'period';
                isDesc = true;
            }
            //console.log('AAA sortField = ', sortField, '  isDesc = ', isDesc);
            
            // Подготовка данных для сортировки:
            dataPeriod.forEach(function(dataTableItem, ind){
                var dataTableSortItem = {};
                dataTableSortItem['period'] = dataTableItem;
                activeLinesId.forEach(function(activeLine){
                    dataTableSortItem[activeLine] = dataTable[activeLine][ind];
                });
                dataTableForSort.push(dataTableSortItem);
            });
            
            // Сортировка данных для таблицы:
            dataTableForSort.sort(function(a,b){
                if (dateTimeFields.indexOf(sortField) > -1) {
                    var
                        aT = new Date(a[sortField]),
                        bT = new Date(b[sortField]);
                    return (isDesc) ? bT-aT : aT-bT;
                } else {
                    return (isDesc) ? b[sortField]-a[sortField] : a[sortField]-b[sortField];
                }
            });
            
            // Отрисовка таблицы:
            dataTableForSort.forEach(function(item){
                
                $row = $('<tr>');
                $row.append($('<td>').html(item['period']));

                activeLinesId.forEach(function(line){
                    $row.append($('<td class="'+ line +'">').html(valueFormatTable(item[line], line)));
                });
                $row.appendTo($tableContent);
            });
            
            // Добавляем строку "Итого" для отчета 'common':
            $row = $('<tr class="total">');
            $row.append($('<td>').html("Итого"));
            activeLinesId.forEach(function(item){
                $row.append($('<td>').html(valueFormatTable(dataStatTotal[item], item)));
            });
            $row.appendTo($tableContent);

            $tableCommonBody.html('').append($tableContent.children());
            
            $statTableWrap.show();
            $statError.hide();
            $statInfo.hide();
            
        };
    
        function renderSitesTable() {
            
            var
                dataTable = dataSitesStat,
                dataTableForSort = [],
                $selectedField = $('thead th b.selected', $tableSites),
                $tableContent = $('<tbody>'),
                $row,
                sortField = false,
                isDesc = true;

            // Определение поля для сортировки строк в таблице:
            if ($selectedField.length > 0) {
                sortField = $selectedField.attr('id');
                isDesc = $selectedField.hasClass('desc');
            }
            if (!sortField) {
                sortField = 'money';
                isDesc = true;
            }
            //console.log('AAA sortField = ', sortField, '  isDesc = ', isDesc);
            
            // Подготовка данных для сортировки:
            for (var site in dataTable) {
                var dataTableSortItem = dataTable[site];
                dataTableSortItem['site'] = site;
                dataTableForSort.push(dataTableSortItem);
            }
            
            // Сортировка данных для таблицы:
            dataTableForSort.sort(function(a,b){
                if (dateTimeFields.indexOf(sortField) > -1) {
                    var
                        aT = new Date(a[sortField]),
                        bT = new Date(b[sortField]);
                    return (isDesc) ? bT-aT : aT-bT;
                } else {
                    return (isDesc) ? b[sortField]-a[sortField] : a[sortField]-b[sortField];
                }
            });
            //console.log('AAA dataTableForSort = ', dataTableForSort);

            // Отрисовка таблицы:
            dataTableForSort.forEach(function(item){
                
                $row = $('<tr class="cat" data-id="' + item['site'] + '">');
                if (item['sub']) {
                    $row.append($('<td class="period">').html('<span class="group"><b class="closed">+</b><b class="open">&ndash;</b></span> ' + item['site']));
                } else {
                    $row.append($('<td class="period">').html(item['site']));
                }

                activeLinesId.forEach(function(line){
                    $row.append($('<td class="stat '+ line +'">').html(valueFormatTable(item[line], line)));
                });
                $row.appendTo($tableContent);
                
                if (item['sub']) {
                    for (var zone in item['sub']) {
                        $row = $('<tr class="subcat" data-parent="' + item['site'] + '">');
                        $row.append($('<td class="subcat-title">').html('[зона ' + zone % 100 + '] (' + item['sub'][zone]['size'] + ')'));
                        activeLinesId.forEach(function(line){
                            $row.append($('<td class="stat '+ line +'">').html(valueFormatTable(item['sub'][zone][line], line)));
                        });
                        $row.appendTo($tableContent);
                    }
                }
                
            });

            $tableSitesBody.html('').append($tableContent.children());
            
            $statSitesTableWrap.show();
            $statSitesError.hide();
            $statSitesInfo.hide();
            
        }
        
        function renderRegionsTable() {
            
            var
                dataTable = dataRegionsStat,
                dataTableForSort = [],
                $selectedField = $('thead th b.selected', $tableRegions),
                $tableContent = $('<tbody>'),
                $row,
                sortField = false,
                isDesc = true;

            // Определение поля для сортировки строк в таблице:
            if ($selectedField.length > 0) {
                sortField = $selectedField.attr('id');
                isDesc = $selectedField.hasClass('desc');
            }
            if (!sortField) {
                sortField = 'money';
                isDesc = true;
            }
            //console.log('AAA sortField = ', sortField, '  isDesc = ', isDesc);
            
            // Подготовка данных для сортировки:
            for (var region in dataTable) {
                var dataTableSortItem = dataTable[region];
                dataTableSortItem['region'] = region;
                dataTableForSort.push(dataTableSortItem);
            }
            
            // Сортировка данных для таблицы:
            dataTableForSort.sort(function(a,b){
                if (dateTimeFields.indexOf(sortField) > -1) {
                    var
                        aT = new Date(a[sortField]),
                        bT = new Date(b[sortField]);
                    return (isDesc) ? bT-aT : aT-bT;
                } else {
                    return (isDesc) ? b[sortField]-a[sortField] : a[sortField]-b[sortField];
                }
            });
            //console.log('AAA dataTableForSort = ', dataTableForSort);
            
            // Отрисовка таблицы:
            dataTableForSort.forEach(function(item){
                
                regionName = (codeRegions[item['region']]) ? codeRegions[item['region']] : item['region'];
                
                $row = $('<tr class="cat" data-id="' + item['region'] + '">');
                if (item['sub']) {
                    $row.append($('<td class="period">').html('<span class="group"><b class="closed">+</b><b class="open">&ndash;</b></span> ' + regionName));
                } else {
                    $row.append($('<td class="period">').html(regionName));
                }

                activeLinesId.forEach(function(line){
                    $row.append($('<td class="stat '+ line +'">').html(valueFormatTable(item[line], line)));
                });
                $row.appendTo($tableContent);
                
                if (item['sub']) {
                    for (var city in item['sub']) {
                        cityName = (codeCities[city]) ? codeCities[city] : city;
                        $row = $('<tr class="subcat" data-parent="' + item['region'] + '">');
                        $row.append($('<td class="subcat-title">').html(cityName));
                        activeLinesId.forEach(function(line){
                            $row.append($('<td class="stat '+ line +'">').html(valueFormatTable(item['sub'][city][line], line)));
                        });
                        $row.appendTo($tableContent);
                    }
                }
                
            });

            $tableRegionsBody.html('').append($tableContent.children());
            
            $statRegionsTableWrap.show();
            $statRegionsError.hide();
            $statRegionsInfo.hide();
        }
        
        // Выбор времени:
        function selectDatePicker(fd, d, picker)
        {
            var type = picker.$el.parents('.form-group-data').data('type');
            requestDataPeriod(type);
            
            //datepicker2.update('minDate', d);
            //datepicker1.update('maxDate', d);
        }
        
        // Запрос данных за временной период:
        function requestDataPeriod(type)
        {
            
            var
                $groupWrap = $('.form-group-data[data-type="' + type + '"]'),
                $dateFrom = $('.campaign-date-begin', $groupWrap),
                $dateTo = $('.campaign-date-end', $groupWrap),
                dataRequest = {type: type, period: [$dateFrom.val(),$dateTo.val()]};
            
            EnableLoadingState($groupWrap, true);

            $.ajax({
                url: $('#campaign-create-form').attr('action'),
                method: 'POST',
                data: dataRequest,
                success: function(res) {
                    EnableLoadingState($groupWrap, false);
                    if (res) {
                        if (res.data == null || res.data.stat == null) {
                            if (type == 'stat-common') ShowCommonStatInfo();
                            if (type == 'stat-sites') ShowSitesStatInfo();
                            if (type == 'stat-regions') ShowRegionsStatInfo();

                        } else if (res.status == 'Error') {
                            if (type == 'stat-common') ShowCommonStatError();
                            if (type == 'stat-sites') ShowSitesStatError();
                            if (type == 'stat-regions') ShowRegionsStatError();
                        } else {
                            //console.log("AAA requestDataStat SUCCESS res: ", res);
                            if (res.type == 'stat-common') {
                                dataStat = res.data.stat;
                                dataStatTotal = res.data.total;
                                renderCommonChart();
                                renderCommonTable();
                            }
                            if (res.type == 'stat-sites') {
                                dataSitesStat = res.data;
                                renderSitesTable();
                            }
                            if (res.type == 'stat-regions') {
                                dataRegionsStat = res.data;
                                renderRegionsTable();
                            }
                        }
                    
                    } else {
                        if (type == 'stat-common') ShowCommonStatError();
                        if (type == 'stat-sites') ShowSitesStatError();
                        if (type == 'stat-regions') ShowRegionsStatError();
                    }
                    
                },
                error: function (e) {
                    console.log('error: ', e);
                    EnableLoadingState($groupWrap, false);
                }
            });
            
        }
        
        activeLine = 'views';
        activeLines = JSON.parse($('#campaign-stat-cats').val());
        activeLinesId = Object.keys(activeLines);

        // Общая статистика
        if (dataStat) {
            // Отрисовка графика и таблицы по стартовым данным:
            if (dataStat.status == 'Error') {
                ShowCommonStatError();
            } else {
                renderCommonChart();
                renderCommonTable();
            }
        } else {
            ShowCommonStatInfo();
            $statChart.hide();
            $statTableWrap.hide();
        }
        
        // Статистика по сайтам
        if (dataSitesStat) {
            // Отрисовка таблицы по стартовым данным:
            if (dataSitesStat.status == 'Error') {
                ShowSitesStatError();
            } else {
                renderSitesTable();
            }
        } else {
            ShowSitesStatError();
        }
        
        // Статистика по регионам
        if (dataRegionsStat) {
            // Отрисовка таблицы по стартовым данным:
            if (dataRegionsStat.status == 'Error') {
                ShowRegionsStatError();
            } else {
                renderRegionsTable();
            }
        } else {
            ShowRegionsStatError();
        }
        
        // Клик на checkbox в названии поля таблицы:
        var $tableHeadColsChecks = $('thead th input[type="checkbox"]', $tableCommonStat);
        $tableHeadColsChecks.on('change', function(){
            renderCommonChart();
        });
        
        // Свернуть-развернуть дочерние ячейки в таблице:
        $('table.table-striped').on('click', 'span.group', function(e) {

            var
                $this = $(this),
                $tableBody = $('tbody', $this.parents('table')),
                $wrap = $this.parents('tr').eq(0),
                id = $wrap.data('id'),
                isOpen,
                $subcats = $('tr.subcat[data-parent="'+ id + '"]', $tableBody);
                
            $this.toggleClass('open');
            isOpen = $this.hasClass('open');
            
            if (isOpen) {
                $subcats.addClass('open');
            } else {
                $subcats.removeClass('open');
            }
            
        });
        
        
    })();
});

