function chartsLine(arrayDataChart, colorLine, isAniamtionCharts, colorFill, scaleStartValue) {

  colorFill = colorFill || 'transparent';

  var newArray = [];

  function matrixArray(rows,columns){
    var arr = new Array();
    for(var i=0; i<columns; i++){
      arr[i] = new Array();
      for(var j=0; j<rows; j++){
        arr[i][j] = null;//вместо i+j+1 пишем любой наполнитель. В простейшем случае - null
      }
    }
    return arr;
  }

  var getDataCharts = {
      labels : arrayDataChart[0],
      datasets : [
        {
          fillColor : colorFill,
          strokeColor : colorLine[0],
          pointColor : colorLine[0],
          pointStrokeColor : "#fff",
          data : newArray[0] || arrayDataChart[1]
        },
        {
          fillColor : colorFill,
          strokeColor : colorLine[1],
          pointColor : colorLine[1],
          pointStrokeColor : "#fff",
          data : newArray[1] || arrayDataChart[2] || 0
        },
        {
          fillColor : colorFill,
          strokeColor : colorLine[2],
          pointColor : colorLine[2],
          pointStrokeColor : "#fff",
          data : newArray[2] || arrayDataChart[3] || 0
        }
      ]
  }

  var strLegend = "<%=value%>";

  var chartLine = document.getElementById('chart-line');
  var ctx = chartLine.getContext("2d");

  options = {

    //Boolean - Whether to animate the chart
    animation : isAniamtionCharts,

    //Interpolated JS string - can access value
    scaleLabel : strLegend,

    //String - Scale label font declaration for the scale label
    scaleFontFamily : "'Raleway'",

    //Number - Scale label font size in pixels
    scaleFontSize : 12,

    //Number - Number of animation steps
    animationSteps : 60,

    //String - Animation easing effect
    animationEasing : "easeOutQuart",

    //Function - Fires when the animation is complete
    onAnimationComplete : null

  }
  if(scaleStartValue !== false) {
      options['scaleStartValue'] = scaleStartValue;
  }
  
  new Chart(ctx).Line(getDataCharts,options);
}