<?php
/**
 * Copyright (c) 2016 Serhii Borodai <clarifying@gmail.com>.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 *  all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 *
 *
 */

namespace App\Entity\Feeds;

use App\Entity\Common;


/**
 * Class CategoryFee
 * @package App\Entity
 */
class CategoryFee extends Common
{
            
    /**
     * @return mixed
     */
    public function getFeedid(): int
    {
        return $this->feedid;
    }

    /**
     * @param mixed $feed_id
     * @return CategoryFee
     */
    public function setFeedid($feed_id)
    {
        $this->feedid = $feed_id;
        return $this;
    }
    
    /**
     * @return mixed
     */
    public function getCatid(): int
    {
        return $this->catid;
    }

    /**
     * @param mixed $cat_id
     * @return CategoryFee
     */
    public function setCatid($cat_id)
    {
        $this->catid = $cat_id;
        return $this;
    }
    
    /**
     * @return mixed
     */
    public function getForeigncatid(): int
    {
        return $this->foreigncatid;
    }

    /**
     * @param mixed $foreign_cat_id
     * @return CategoryFee
     */
    public function setForeigncatid($foreign_cat_id)
    {
        $this->foreigncatid = $foreign_cat_id;
        return $this;
    }
    
    
    /**
     * @return mixed
     */
    public function getOrderpercent(): int
    {
        return $this->orderpercent;
    }

    /**
     * @param mixed $order_percent
     * @return CategoryFee
     */
    
    public function setOrderpercent($order_percent)
    {
        $this->orderpercent = $order_percent;
        return $this;
    }

}