$(document).ready(function () {
    "use strict";

    // Клик на "Сохранить":
    $('#feed-create-form').on('submit', function(e) {        
        var
            $form = $('#feed-create-form'),
            action = $form.attr('action'),
            method = $form.attr('method'),
            formData = new FormData(),
            warningInfo;
        
        // Данные фида:
        var
            feedTitle = $('#feed-title').val(),
            clientId = $('select#feed-clientid').val(),
            formatValue = $('select#feed-format').val(),
            curValue = $('select#feed-defaultcur').val(),
            urlValue = $('input#feed-url').val();
        
        if (curValue == 0)      {warningInfo = 'Выберите основную валюту';}
        if (formatValue == 0)   {warningInfo = 'Выберите формат';}
        if (clientId == 0)      {warningInfo = 'Выберите пользователя фида';}
        if (urlValue == '')     {warningInfo = 'Введите URL';}
        if (feedTitle == '')    {warningInfo = 'Введите название фида';}
        
        formData.append('active', ($('input#feed-active').prop('checked')) ? 1 : 0);
        formData.append('title', feedTitle);
        formData.append('clientid', clientId);
        formData.append('url', urlValue);
        formData.append('format', formatValue);
        formData.append('defaultcur', curValue);
        
        if (warningInfo) {
            alert(warningInfo);
            return false;
        }
        
        //console.log('AAA formData = ', feedTitle);
        //return false;
        
        $.ajax(action, {
            type: method,
            data: formData,
            contentType: false,
            processData: false,
            success: function(data) {
                if(data) {
                    if(data.result === true && data.redirect) {
                        document.location.href = data.redirect;
                    }
                    if(data.result === false && data.msg) {
                        $.showMessage('error', data.msg);
                    }
                } 
            },
            error: function(rew, status, err) {
                console.log(status, err);
                $.showMessage('error', err);
            }
        });
        
        return false;
    });
    
    
    
});