$(document).ready(function(){
    
    $.extend({
        ReportsConf: {
            ListProvidersMetrics: ['winstat', 'bidstat', 'providersblockstat', 'ndspstat'],
            DefaultCategories: {
                minstat:    'sspViewsCnt',
                pagestat:   'startCnt',
                blockstat:  'sumViews',
                ndspstat:   'adMoney',
                bidstat:    'bidMoney',
                winstat:    'sspMoney',
                providersblockstat: 'sum',
            },
            CurrencyFields: ['sspMoney', 'bidMoney', 'adMoney', 'cpc', 'sspSiteMoney', 'sspSystemMoney', 'siteCpc', 'systemCpc'],
            SpecialFields: ['cpm', 'siteCpm', 'systemCpm', 'ctr', 'ctrRtb', 'runRatio', 'sumRatio', 'siteRatio', 'systemRatio', 'cpc', 'siteCpc', 'systemCpc'],
            PercentsFields: ['runRatio', 'ctr', 'ctrRtb', 'sumRatio', 'siteRatio', 'systemRatio'],
            NotCategoryIdFields: ['byCountries', 'byZones', 'bySites', 'metric', 'period', 'type'],
            GetCalculationParams: function(metric, activeLine) {
                var
                    calcData = {
                        cpm: {
                            minstat: [1000, 'sspMoney', 'sspViewsCnt'],
                            ndspstat: [1000, 'adMoney', 'adViewsCnt'],
                            bidstat: [1000, 'bidMoney', 'bidCnt'],
                            winstat: [1000, 'sspMoney', 'sspViewsCnt'],
                        },
                        siteCpm: {
                            minstat: [1000, 'sspSiteMoney', 'sspViewsCnt'],
                        },
                        systemCpm: {
                            minstat: [1000, 'sspSystemMoney', 'sspViewsCnt'],
                        },
                        runRatio: {
                            pagestat: [1, 'runCnt', 'loadCnt']
                        },
                        sumRatio: {
                            minstat: [1, 'sspMoney', 'sspMoney']
                        },
                        siteRatio: {
                            minstat: [1, 'sspSiteMoney', 'sspMoney']
                        },
                        systemRatio: {
                            minstat: [1, 'sspSystemMoney', 'sspMoney']
                        },
                        ctr: {
                            minstat: [1, 'sspClicksCnt', 'sspViewsCnt'],
                            ndspstat: [1, 'adClicksCnt', 'adViewsCnt'],
                            blockstat: [1, 'blockClicksCnt', 'blockViewsCnt'],
                            winstat: [1, 'sspClicksCnt', 'sspViewsCnt'],
                            providersblockstat: [1, 'blockClicksCnt', 'blockViewsCnt'],
                        },
                        ctrRtb: {
                            blockstat: [1, 'sspClicksCnt', 'sspViewsCnt'],
                        },
                        cpc: {
                            minstat: [100, 'sspMoney', 'sspClicksCnt'],
                            ndspstat: [100, 'adMoney', 'adClicksCnt'],
                            winstat: [100, 'sspMoney', 'sspClicksCnt'],
                        },
                        siteCpc: {
                            minstat: [100, 'sspSiteMoney', 'sspClicksCnt'],
                        },
                        systemCpc: {
                            minstat: [100, 'sspSystemMoney', 'sspClicksCnt'],
                        },
                    },
                    calcParams = {
                        k: calcData[activeLine][metric][0],
                        n: calcData[activeLine][metric][1],
                        d: calcData[activeLine][metric][2],
                    };

                return calcParams;
            },
            GetCategoryType: function(dataStat) {
                var categoryType;
                if (dataStat.bySites) categoryType = 'bySites';
                if (dataStat.byZones) categoryType = 'byZones';
                if (dataStat.byCountries) categoryType = 'byCountries';
                return categoryType;
            }
            
        }
    });

});
