<?php

namespace App\Entity;

use App\Entity\IdentityTrait\Identity;
use App\Entity\Caterogy;
use App\Entity\Country;
use App\Entity\Currency;
use App\Entity\Support;

/**
 * Users
 *
 */
class User extends Common implements IdentityInterface
{

    use Identity;

    const NOT_BLOCKED = 0;
    const BLOCKED = 1;
    const NOT_ACTIVATED = 0;
    const ACTIVATED = 1;

    /**
     * @var string
     */
    protected $email;

    /**
     * @var string
     */
    protected $password;

    /**
     * @var string
     */
    protected $fullname;
    
    /**
     * @var string
     */
    protected $phone;
    
    /**
     *
     * @var string
     */
    protected $segment;    
    
    /**
     *
     * @var int
     */
    protected $traffic;
        
    /**
     *
     * @var string
     */
    protected $countryCode;

    /**
     *
     * @var string
     */
    protected $currencyCode;
    
    /**
     * @var string
     */
    protected $dateCreate;

    /**
     * @var boolean
     */
    protected $blocked = 0;

    /**
     * @var boolean
     */
    protected $activated = 0;

    /**
     * @var string
     */
    protected $comment;

    /**
     * @var string
     */
    protected $uuid;         
    
    /**
     *
     * @var int
     */
    protected $supportId;    

    /**
     * @var int
     */
    protected $userTypesId = UserType::TYPE_SINGLE_USER;

    /**
     *
     * @var array
     */
    protected $categories = [];
    
    /**
     *
     * @var Country
     */
    protected $country;
        
    /**
     *
     * @var Currency
     */
    protected $currency;
    
    /**
     *
     * @var Support
     */
    protected $manager;


    /**
     * Set email
     *
     * @param string $email
     *
     * @return User
     */
    public function setEmail($email)
    {
        $this->email = $email;

        return $this;
    }

    /**
     * Get email
     *
     * @return string
     */
    public function getEmail()
    {
        return $this->email;
    }

    /**
     * Set password
     *
     * @param string $password
     *
     * @return User
     */
    public function setPassword($password)
    {
        $this->password = $password;

        return $this;
    }

    /**
     * Get password
     *
     * @return string
     */
    public function getPassword()
    {
        return $this->password;
    }
    
    /**
     * Set fullname
     *
     * @param string $fullname
     *
     * @return User
     */
    public function setFullname($fullname)
    {
        $this->fullname = $fullname;

        return $this;
    }

    /**
     * Get fullname
     *
     * @return string
     */
    public function getFullname()
    {
        return $this->fullname;
    }
    
    /**
     * @return string
     */
    public function getPhone(): string
    {
        return (string) $this->phone;
    }

    /**
     * @param string $phone
     * @return User
     */
    public function setPhone($phone): User
    {
        $this->phone = $phone;
        return $this;
    }
    
    /**
     * 
     * @return string
     */
    public function getSegment(): string
    {
        return (string) $this->segment;
    }    
    
    /**
     * 
     * @param string $segment
     * @return $this
     */
    public function setSegment($segment)
    {
        $this->segment = $segment;
        return $this;        
    }
    
    /**
     * 
     * @return int
     */
    public function getTraffic(): int
    {
        return (int) $this->traffic;
    }
            
    /**
     * 
     * @param int $traffic
     * @return $this
     */
    public function setTraffic($traffic)
    {
        $this->traffic = $traffic;
        return $this;
    }
        
    /**
     * 
     * @return string
     */
    public function getCountryCode(): string
    {
        return (string) $this->countryCode;
    }
    
    /**
     * 
     * @param string $country
     * @return $this
     */
    public function setCountryCode($country)
    {
        $this->countryCode = $country;
        return $this;
    }
    
    /**
     * 
     * @return string
     */
    public function getCurrencyCode(): string
    {
        return (string) $this->currencyCode;
    }
    
    /**
     * 
     * @param string $currency
     * @return $this
     */
    public function setCurrencyCode($currency)
    {
        $this->currencyCode = $currency;
        return $this;
    }
    
    /**
     * 
     * @return string
     */
    public function getCodeProvider(): string
    {
        return (string) $this->codeProvider;
    }
    
    /**
     * 
     * @param string $currency
     * @return $this
     */
    public function setCodeProvider($code_provider)
    {
        $this->codeProvider = $code_provider;
        return $this;
    }

    /**
     * Set dateCreate
     *
     * @param string $dateCreate
     *
     * @return User
     */
    public function setDateCreate($dateCreate)
    {
        $this->dateCreate = $dateCreate;

        return $this;
    }

    /**
     * Get dateCreate
     *
     * @return string
     */
    public function getDateCreate()
    {
        return $this->dateCreate ?? (new \DateTimeImmutable())->format('Y-m-d');
    }

    /**
     * Set blocked
     *
     * @param boolean $blocked
     *
     * @return User
     */
    public function setBlocked($blocked)
    {
        $this->blocked = $blocked;

        return $this;
    }

    /**
     * Get blocked
     *
     * @return boolean
     */
    public function getBlocked()
    {
        return $this->blocked;
    }

    /**
     * @return bool
     */
    public function getActivated()
    {
        return $this->activated;
    }

    /**
     * @param bool $activated
     * @return $this
     */
    public function setActivated($activated)
    {
        $this->activated = $activated;

        return $this;
    }

    /**
     * Set comment
     *
     * @param string $comment
     *
     * @return User
     */
    public function setComment($comment)
    {
        $this->comment = $comment;

        return $this;
    }

    /**
     * Get comment
     *
     * @return string
     */
    public function getComment()
    {
        return $this->comment;
    }

    /**
     * Set uuid
     *
     * @param string $uuid
     *
     * @return User
     */
    public function setUuid($uuid)
    {
        $this->uuid = $uuid;

        return $this;
    }

    /**
     * Get uuid
     *
     * @return string
     */
    public function getUuid()
    {
        return $this->uuid;
    }    

    /**
     * @return int
     */
    public function getUserTypesId(): int
    {
        return $this->userTypesId;
    }

    /**
     * @param int $userTypesId
     */
    public function setUserTypesId(int $userTypesId)
    {
        $this->userTypesId = $userTypesId;
    }    
    
    /**
     * 
     * @return int
     */
    public function getSupportId(): int
    {
        return $this->supportId;
    }
    
    /**
     * 
     * @param int $supportId
     * @return $this
     */
    public function setSupportId($supportId)
    {
        $this->supportId = $supportId;
        return $this;
    }

        /**
     * 
     * @return array Caterogy
     */
    public function getCategories()
    {
        return $this->categories;
    }
    
    /**
     * 
     * @param array $categories
     * @return $this
     */
    public function setCategories($categories)
    {
        $this->categories = $categories;
        return $this;
    }
    
    /**
     * 
     * @return Country
     */
    public function getCountry()
    {
        return $this->country;
    }
    
    /**
     * 
     * @param Country $country
     */
    public function setCountry($country) 
    {
        $this->country = $country;
    }
    
    /**
     * Set currency
     *
     * @param string $currency
     *
     * @return User
     */
    public function setCurrency($currency)
    {
        $this->currency = $currency;
        
        return $this;
    }
    
    /**
     * Get currency
     *
     * @return string
     */
    public function getCurrency()
    {
        return $this->currency;
    }
    
    
    /**
     * 
     * @return Support 
     */
    public function getManager()
    {
        return $this->manager;
    }

    /**
     * 
     * @param Support $manager
     * @return $this
     */
    public function setManager($manager)
    {
        $this->manager = $manager;
        return $this;
    }
    
    /**
     * 
     * @return string
     */
    public function getType(): string
    {
        return (string) $this->type;
    }    
    
    /**
     * 
     * @param string $type
     * @return $this
     */
    public function setType($type)
    {
        $this->type = $type;
        return $this;        
    }
}
