<?php
use Interop\Container\ContainerInterface;
use Zend\Expressive\Application;
use Zend\Expressive\Container\ApplicationFactory;
use Zend\Expressive\Helper;
use Zend\Hydrator\HydratorPluginManager;

return [
    // Provides application-wide services.
    // We recommend using fully-qualified class names whenever possible as
    // service names.
    'dependencies' => [
        // Use 'invokables' for constructor-less services, or services that do
        // not require arguments to the constructor. Map a service name to the
        // class name.
        'invokables' => [
            // Fully\Qualified\InterfaceName::class => Fully\Qualified\ClassName::class,
            Helper\ServerUrlHelper::class => Helper\ServerUrlHelper::class,
        ],
        // Use 'factories' for services provided by callbacks/factory classes.
        'factories' => [
            Application::class => ApplicationFactory::class,
            Helper\UrlHelper::class => Helper\UrlHelperFactory::class,
            \Zend\Db\Adapter\Adapter::class => function (ContainerInterface $container) {
                return new Zend\Db\Adapter\Adapter($container->get('config')['db']);
            },
            \Zend\Db\Adapter\AdapterEcpa::class => function (ContainerInterface $container) {
                return new Zend\Db\Adapter\Adapter($container->get('config')['db_ecpa']);
            },
            \Zend\Db\Adapter\AdapterRetarg::class => function (ContainerInterface $container) {
                return new Zend\Db\Adapter\Adapter($container->get('config')['db_retarg']);
            },
            \Zend\Db\Adapter\AdapterTpl::class => function (ContainerInterface $container) {
                return new Zend\Db\Adapter\Adapter($container->get('config')['db_tpl']);
            },
            \Zend\Hydrator\DelegatingHydrator::class => function (ContainerInterface $container) {
                return new \Zend\Hydrator\DelegatingHydrator($container->get(HydratorPluginManager::class));
            },
            \Zend\Hydrator\HydratorPluginManager::class => function (ContainerInterface $container) {
                $hpm = new \Zend\Hydrator\HydratorPluginManager($container);

                $hpm->setService(\App\Entity\User::class, new \Zend\Hydrator\ClassMethods());
                $hpm->setService(\App\Entity\UserType::class, new \Zend\Hydrator\ClassMethods());
                $hpm->setService(\App\Entity\UserCategory::class, new \Zend\Hydrator\ClassMethods());
                $hpm->setService(\App\Entity\Country::class, new \Zend\Hydrator\ClassMethods());
                $hpm->setService(\App\Entity\Currency::class, new \Zend\Hydrator\ClassMethods());
                
                $hpm->setService(\App\Entity\Support::class, new \Zend\Hydrator\ClassMethods());

                $hpm->setService(\App\Entity\FAQ\Item::class, new \Zend\Hydrator\ClassMethods());
                $hpm->setService(\App\Entity\FAQ\Category::class, new \Zend\Hydrator\ClassMethods());


                //TODO: Delete this?

                
                $hpm->setService(\App\Entity\Feeds\Feed::class, new \Zend\Hydrator\ClassMethods());
                $hpm->setService(\App\Entity\Feeds\StatsDay::class, new \Zend\Hydrator\ClassMethods());
                $hpm->setService(\App\Entity\Feeds\Transaction::class, new \Zend\Hydrator\ClassMethods());

                $hpm->setService(\App\Entity\Contacts::class, new \Zend\Hydrator\ClassMethods());

                $hpm->setService(\App\Entity\Feedback::class, new \Zend\Hydrator\ClassMethods());

                $hpm->setService(\App\Entity\Tag::class, new \Zend\Hydrator\ClassMethods());

                return $hpm;
            },
            \Netcarver\Textile\Parser::class => function (ContainerInterface $container) {
                return new \Netcarver\Textile\Parser('html5');
            },
            \App\Model\Users::class => function (ContainerInterface $container) {
                return new \App\Model\Users(
                    new Zend\Db\TableGateway\TableGateway(
                        'users',
                        $container->get(Zend\Db\Adapter\Adapter::class),
                        new \Zend\Db\TableGateway\Feature\MetadataFeature(),
                        new \Zend\Db\ResultSet\HydratingResultSet($container->get(\Zend\Hydrator\DelegatingHydrator::class), new \App\Entity\User())
                    ),
                    $container->get(\Zend\Hydrator\DelegatingHydrator::class),
                    $container->get(\Monolog\Logger::class),
                    $container->get(\App\Model\UserCategory::class),
                    $container->get(\App\Model\Countries::class),
                    $container->get(\App\Model\Currencies::class),
                    $container->get(\App\Model\Supports::class)
                );
            },
            \App\Model\Categories::class => function (ContainerInterface $container) {                                                                
                return new \App\Model\Categories(
                    new Zend\Db\TableGateway\TableGateway(
                        'categories',
                        $container->get(Zend\Db\Adapter\Adapter::class),
                        new \Zend\Db\TableGateway\Feature\MetadataFeature(),
                        new \Zend\Db\ResultSet\HydratingResultSet($container->get(\Zend\Hydrator\DelegatingHydrator::class), new \App\Entity\Caterogy())
                    ),
                    $container->get(\Zend\Hydrator\DelegatingHydrator::class),
                    $container->get(\Monolog\Logger::class)
                );
            },
            \App\Model\UserCategory::class => function (ContainerInterface $container) {                                                                
                return new \App\Model\UsersCategory(
                    new Zend\Db\TableGateway\TableGateway(
                        'user_category',
                        $container->get(Zend\Db\Adapter\Adapter::class),
                        new \Zend\Db\TableGateway\Feature\MetadataFeature(),
                        new \Zend\Db\ResultSet\HydratingResultSet($container->get(\Zend\Hydrator\DelegatingHydrator::class), new \App\Entity\UserCategory())
                    ),
                    $container->get(\Zend\Hydrator\DelegatingHydrator::class),
                    $container->get(\Monolog\Logger::class),
                    $container->get(\App\Model\Categories::class)                    
                );
            },
            \App\Model\Countries::class => function(ContainerInterface $container) {
                return new \App\Model\Countries(
                    new Zend\Db\TableGateway\TableGateway(
                        'countries',
                        $container->get(Zend\Db\Adapter\Adapter::class),
                        new \Zend\Db\TableGateway\Feature\MetadataFeature(),
                        new \Zend\Db\ResultSet\HydratingResultSet($container->get(\Zend\Hydrator\DelegatingHydrator::class), new \App\Entity\Country())
                    ),
                    $container->get(\Zend\Hydrator\DelegatingHydrator::class),
                    $container->get(\Monolog\Logger::class)
                );
            },
            
            \App\Model\Currencies::class => function(ContainerInterface $container) {
                return new \App\Model\Currencies(
                    new Zend\Db\TableGateway\TableGateway(
                        'currencies',
                        $container->get(Zend\Db\Adapter\Adapter::class),
                        new \Zend\Db\TableGateway\Feature\MetadataFeature(),
                        new \Zend\Db\ResultSet\HydratingResultSet($container->get(\Zend\Hydrator\DelegatingHydrator::class), new \App\Entity\Currency())
                    ),
                    $container->get(\Zend\Hydrator\DelegatingHydrator::class),
                    $container->get(\Monolog\Logger::class)
                );
            },
            
            \App\Model\Supports::class => function (ContainerInterface $container) {
                return new \App\Model\Supports(
                    new Zend\Db\TableGateway\TableGateway(
                        'supports',
                        $container->get(Zend\Db\Adapter\Adapter::class),
                        new \Zend\Db\TableGateway\Feature\MetadataFeature(),
                        new \Zend\Db\ResultSet\HydratingResultSet($container->get(\Zend\Hydrator\DelegatingHydrator::class), new \App\Entity\Support())
                    ),
                    $container->get(\Zend\Hydrator\DelegatingHydrator::class),
                    $container->get(\Monolog\Logger::class)
                );
            },
            \App\Model\Feeds\Feeds::class => function (ContainerInterface $container) {
                return new \App\Model\Feeds\Feeds(
                    new Zend\Db\TableGateway\TableGateway(
                        'feeds',
                        $container->get(Zend\Db\Adapter\AdapterRetarg::class),
                        new \Zend\Db\TableGateway\Feature\MetadataFeature(),
                        new \Zend\Db\ResultSet\HydratingResultSet($container->get(\Zend\Hydrator\DelegatingHydrator::class), new \App\Entity\Feeds\Feed())
                    ),
                    $container->get(\Zend\Hydrator\DelegatingHydrator::class),
                    $container->get(\Monolog\Logger::class)
                );
            },
            \App\Model\FAQ\Categories::class => function (ContainerInterface $container) {
                return new \App\Model\FAQ\Categories(
                    new Zend\Db\TableGateway\TableGateway(
                        'faq_categories',
                        $container->get(Zend\Db\Adapter\Adapter::class),
                        new \Zend\Db\TableGateway\Feature\MetadataFeature(),
                        new \Zend\Db\ResultSet\HydratingResultSet($container->get(\Zend\Hydrator\DelegatingHydrator::class), new \App\Entity\FAQ\Category())
                    ),
                    $container->get(\Zend\Hydrator\DelegatingHydrator::class),
                    $container->get(\Monolog\Logger::class)
                );
            },
            \App\Model\FAQ\Items::class => function (ContainerInterface $container) {
                return new \App\Model\FAQ\Items(
                    new Zend\Db\TableGateway\TableGateway(
                        'faq_items',
                        $container->get(Zend\Db\Adapter\Adapter::class),
                        new \Zend\Db\TableGateway\Feature\MetadataFeature(),
                        new \Zend\Db\ResultSet\HydratingResultSet($container->get(\Zend\Hydrator\DelegatingHydrator::class), new \App\Entity\FAQ\Item())
                    ),
                    $container->get(\Zend\Hydrator\DelegatingHydrator::class),
                    $container->get(\Monolog\Logger::class),
                    $container->get(\Netcarver\Textile\Parser::class)
                );
            },
            \App\Model\Articles::class => function (ContainerInterface $container) {
                return new \App\Model\Articles(
                    new Zend\Db\TableGateway\TableGateway(
                        'articles',
                        $container->get(Zend\Db\Adapter\Adapter::class),
                        new \Zend\Db\TableGateway\Feature\MetadataFeature(),
                        new \Zend\Db\ResultSet\HydratingResultSet($container->get(\Zend\Hydrator\DelegatingHydrator::class), new \App\Entity\Article())
                    ),
                    $container->get(\Zend\Hydrator\DelegatingHydrator::class),
                    $container->get(\Monolog\Logger::class),
                    $container->get(\App\Model\Tags::class),
                    $container->get(\App\Model\ArticlesHasTags::class)
                );
            },
            \App\Model\Tags::class => function (ContainerInterface $container) {
                return new \App\Model\Tags(
                    new Zend\Db\TableGateway\TableGateway(
                        'tags',
                        $container->get(Zend\Db\Adapter\Adapter::class),
                        new \Zend\Db\TableGateway\Feature\MetadataFeature(),
                        new \Zend\Db\ResultSet\HydratingResultSet($container->get(\Zend\Hydrator\DelegatingHydrator::class), new \App\Entity\Tag())
                    ),
                    $container->get(\Zend\Hydrator\DelegatingHydrator::class),
                    $container->get(\Monolog\Logger::class)
                );
            },
            \App\Model\ArticlesHasTags::class => function (ContainerInterface $container) {
                return new \App\Model\ArticlesHasTags(
                    new Zend\Db\TableGateway\TableGateway(
                        'articles_has_tags',
                        $container->get(Zend\Db\Adapter\Adapter::class),
                        new \Zend\Db\TableGateway\Feature\MetadataFeature()//,
//                        new \Zend\Db\ResultSet\HydratingResultSet($container->get(\Zend\Hydrator\DelegatingHydrator::class), new \App\Entity\Vacancies\Item())
                    ),
                    $container->get(\Zend\Hydrator\DelegatingHydrator::class),
                    $container->get(\Monolog\Logger::class)
                );
            },
            \App\Model\Locales::class => function (ContainerInterface $container) {
                return new \App\Model\Locales();
            },
            \App\Model\Contacts::class => function (ContainerInterface $container) {
                return new \App\Model\Contacts();
            },
            \App\Model\Translations::class => function (ContainerInterface $container) {
                return new \App\Model\Translations(
                    $container->get(\App\Model\FAQ\Categories::class),
                    $container->get(\App\Model\FAQ\Items::class),
                    ['templates', 'src'] // source code directories to parse by translations generator
                );
            },
            \App\Model\Statistics::class => function(ContainerInterface $container) {
                return new \App\Model\Statistics(
                    //$container->get(\App\Model\Sites::class),
                    //$container->get(\App\Model\Zones::class),
                    //$container->get('config')['country_codes']
                );
            },             
        ],
    ],
];
