<?php
namespace App\Authentication\Tokenizer;

use stdClass;

/**
 * Interface TokenizerInterface
 * @package App\Authentication\Tokenizer
 */
interface TokenizerInterface
{
    /**
     * Encode data to token.
     *
     * @param array $data
     *
     * @return string
     */
    public function encode(array $data) : string;

    /**
     * Decode token to data.
     *
     * @param string $encoded
     *
     * @return stdClass|null
     */
    public function decode(string $encoded);
}