(function($) {
    $.extend({
        showMessage : function(type, text)
        {

            /*
             Defaults
             */
            var config = {
                type: type,
                text: text,
                showClose: true,
                secondsToClose: 3,
                onClose: false
            };

            /*
             Show message
             */
            $('.jGrowl-close').click();

            $.jGrowl(config.text, {
                theme: config.type,
                sticky: (config.secondsToClose == 0) ? true : false,
                life: config.secondsToClose * 1000,
                open: function(context) {
                    if (!config.showClose)
                    {
                        context.find('.jGrowl-close').hide();
                    }
                },
                close: function(){
                    if(config.onClose) {
                        config.onClose();
                    }
                }
            });
        }
    });
})(jQuery);