<?php

// Delegate static file requests back to the PHP built-in webserver
if (php_sapi_name() === 'cli-server'
    && is_file(__DIR__ . parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH))
) {
    return false;
}

chdir(dirname(__DIR__));
require 'vendor/autoload.php';

/**
 * Translation function to avoid get gettext metainfo on empty strings
 * assume translations always enabled e.g (new Gettext\Translator)->register()
 *
 * @param $string
 * @return string
 */
function _t(string $string)
{
    $result = $string;

    if ($string === '' || $string === null) {
        $result =  "";
    } else {
        if (func_num_args() >1) {
            $params = func_get_args();
            array_shift($params);
            $result = __($string, $params);
        } else {
            $result = __($string);
        }
    }
    return $result;
}

function _p($data, $exit=0, $export=0)
{
    if($exit && isset($_SERVER['HTTP_HOST'])) {
        header('Content-type: text/plain', true);
    }
    if($export) {
        echo var_export($data, 1);
    } else {
        echo print_r($data, 1);
    }
    
    if($exit) {
        exit();
    }    
}

/** @var \Interop\Container\ContainerInterface $container */
$container = require 'config/container.php';

/** @var \Zend\Expressive\Application $app */
$app = $container->get(\Zend\Expressive\Application::class);
$app->run();
