$(document).ready(function () {
    "use strict";
    
    // Исхдные данные в таблице фидов:
    var
        dataItems = [];
        
    AddDataItems();
    
    // Формирование данных о сайтах из таблицы
    function AddDataItems()
    {
        var
            $itemsRows = $('table.table-striped tbody tr'),
            $itemRow;

        dataItems = [];
        $itemsRows.each(function(i, e){
            $itemRow = $(e);
            dataItems.push({
                tr: $itemRow, // строка в таблице
                id: $.trim($('.feed-id', $itemRow).text()),
                title: $.trim($('.feed-title', $itemRow).text()),
                clientid: $.trim($('.feed-clientid', $itemRow).text()),
                url: $.trim($('.feed-url', $itemRow).text()),
                format: $.trim($('.feed-format', $itemRow).text()),
                status: $.trim($('.feed-status', $itemRow).text()),
                defaultcur: $.trim($('.feed-defaultcur', $itemRow).text()),
                goodscount: $.trim($('.feed-goodscount', $itemRow).text()),
                lastcheck: $.trim($('.feed-lastcheck', $itemRow).text()),
            });
        });
        
    }
    
    // Клик по названию колонки для сортировки:
    Array.prototype.forEach.call(document.querySelectorAll(".sort[data-sort]"), function (el) {
        $(el).on("click", function (e) {
            
            // Сортировка в таблице
            var
                sortField = $(this).data('sort'),
                sortAsc = $(this).attr('data-sortasc');
                
            $(this).attr('data-sortasc', -sortAsc);
            
            dataItems.sort(function(a, b) {
                if (sortAsc < 0) {
                    return (a[sortField] > b[sortField]) ? 1 : -1;
                } else {
                    return (a[sortField] < b[sortField]) ? 1 : -1;
                }
            });
            
            // Переписываем таблицу:
            var 
                $table = $('table.table-striped'),
                $tableContent = $('<tbody>'),
                $tableBody = $table.find('tbody').first();
            
            for (var i = 0; i < dataItems.length; i++) {
                (dataItems[i].tr).appendTo($tableContent);
            }
            
            $tableBody.html('').append($tableContent.children());
        });
    });
    
});