-- MySQL Script generated by MySQL Workbench
-- 01/31/17 09:09:14
-- Model: New Model    Version: 1.0
-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL,ALLOW_INVALID_DATES';

-- -----------------------------------------------------
-- Schema noadtech
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Schema noadtech
-- -----------------------------------------------------
CREATE SCHEMA IF NOT EXISTS `noadtech` DEFAULT CHARACTER SET utf8 ;
USE `noadtech` ;

-- -----------------------------------------------------
-- Table `noadtech`.`user_types`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `noadtech`.`user_types` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(45) NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `noadtech`.`users`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `noadtech`.`users` (
  `id` INT UNSIGNED NOT NULL AUTO_INCREMENT,
  `email` VARCHAR(255) NOT NULL,
  `password` VARCHAR(60) NOT NULL,
  `fullname` VARCHAR(255) NOT NULL,
  `date_create` DATETIME NOT NULL,
  `blocked` TINYINT(1) NOT NULL DEFAULT 0,
  `activated` TINYINT(1) NOT NULL DEFAULT 0,
  `comment` VARCHAR(255) NULL,
  `uuid` VARCHAR(36) NOT NULL,
  `website` VARCHAR(255) NOT NULL,
  `user_types_id` INT NOT NULL,
  `phone` VARCHAR(45) NULL,
  `role_id` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_users_user_types`
    FOREIGN KEY (`user_types_id`)
    REFERENCES `noadtech`.`user_types` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION);

CREATE UNIQUE INDEX `uuid_UNIQUE` ON `noadtech`.`users` (`uuid` ASC);

CREATE UNIQUE INDEX `website_UNIQUE` ON `noadtech`.`users` (`website` ASC);

CREATE INDEX `fk_users_user_types_idx` ON `noadtech`.`users` (`user_types_id` ASC);

CREATE UNIQUE INDEX `sample` ON `noadtech`.`users` (`email` ASC, `fullname` ASC, `user_types_id` ASC, `comment` ASC);


-- -----------------------------------------------------
-- Table `noadtech`.`faq_categories`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `noadtech`.`faq_categories` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(50) NOT NULL,
  `desc` VARCHAR(255) NULL,
  `hidden` TINYINT(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `noadtech`.`faq_items`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `noadtech`.`faq_items` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `faq_categories_id` INT NOT NULL,
  `name` VARCHAR(255) NULL,
  `content` VARCHAR(4096) NULL,
  `hidden` TINYINT(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_faq_items_faq_groups1`
    FOREIGN KEY (`faq_categories_id`)
    REFERENCES `noadtech`.`faq_categories` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

CREATE INDEX `fk_faq_items_faq_groups1_idx` ON `noadtech`.`faq_items` (`faq_categories_id` ASC);


-- -----------------------------------------------------
-- Table `noadtech`.`vacancies`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `noadtech`.`vacancies` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `title` VARCHAR(50) NOT NULL,
  `annotation` VARCHAR(128) NULL,
  `desc` VARCHAR(1024) NOT NULL,
  `appeal` VARCHAR(1024) NULL,
  `offer1` VARCHAR(512) NULL,
  `offer2` VARCHAR(512) NULL,
  `offer3` VARCHAR(512) NULL,
  `offer4` VARCHAR(512) NULL,
  `hidden` TINYINT(1) NOT NULL DEFAULT 0,
  `debugging_skills_show` TINYINT(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `noadtech`.`vacancies_offers`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `noadtech`.`vacancies_offers` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `vacancies_id` INT NULL,
  `desc` VARCHAR(512) NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_vacancies_offers_vacancies1`
    FOREIGN KEY (`vacancies_id`)
    REFERENCES `noadtech`.`vacancies` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

CREATE INDEX `fk_vacancies_offers_vacancies1_idx` ON `noadtech`.`vacancies_offers` (`vacancies_id` ASC);


-- -----------------------------------------------------
-- Table `noadtech`.`vacancies_skills`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `noadtech`.`vacancies_skills` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `vacancies_id` INT NOT NULL,
  `title` VARCHAR(50) NOT NULL,
  `desc` VARCHAR(1024) NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `fk_vacancies_knowledge_vacancies1`
    FOREIGN KEY (`vacancies_id`)
    REFERENCES `noadtech`.`vacancies` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

CREATE INDEX `fk_vacancies_knowledge_vacancies1_idx` ON `noadtech`.`vacancies_skills` (`vacancies_id` ASC);


-- -----------------------------------------------------
-- Table `noadtech`.`locales`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `noadtech`.`locales` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `lang` VARCHAR(10) NOT NULL,
  `locale` VARCHAR(10) NOT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;

CREATE UNIQUE INDEX `locales_locale_uindex` ON `noadtech`.`locales` (`locale` ASC);


-- -----------------------------------------------------
-- Table `noadtech`.`supports`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `noadtech`.`supports` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `email` VARCHAR(255) NOT NULL,
  `password` VARCHAR(60) NOT NULL,
  `date_create` DATETIME NOT NULL,
  `role` ENUM('admin', 'manager', 'translator') NOT NULL,
  `role_id` VARCHAR(255) NOT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `noadtech`.`phinxlog`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `noadtech`.`phinxlog` (
  `version` BIGINT(20) NOT NULL,
  `migration_name` VARCHAR(100) NULL DEFAULT NULL,
  `start_time` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `end_time` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `breakpoint` TINYINT(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`version`))
ENGINE = InnoDB
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `noadtech`.`sites`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `noadtech`.`sites` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `domain` VARCHAR(255) NOT NULL,
  `users_id` INT UNSIGNED NOT NULL,
  PRIMARY KEY (`id`, `users_id`),
  CONSTRAINT `fk_sites_users1`
    FOREIGN KEY (`users_id`)
    REFERENCES `noadtech`.`users` (`id`)
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;

CREATE UNIQUE INDEX `domain_UNIQUE` ON `noadtech`.`sites` (`domain` ASC);

CREATE INDEX `fk_sites_users1_idx` ON `noadtech`.`sites` (`users_id` ASC);


-- -----------------------------------------------------
-- Table `noadtech`.`tags`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `noadtech`.`tags` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(100) NOT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `noadtech`.`articles`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `noadtech`.`articles` (
  `id` INT NOT NULL AUTO_INCREMENT,
  `title` VARCHAR(255) NOT NULL,
  `desc` VARCHAR(1024) NOT NULL,
  `content` TEXT NOT NULL,
  `hidden` TINYINT(1) NOT NULL,
  `date_create` TIMESTAMP NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `date_update` TIMESTAMP NULL DEFAULT NULL,
  `title_img_url` VARCHAR(1024) NOT NULL,
  PRIMARY KEY (`id`))
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `noadtech`.`articles_has_tags`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `noadtech`.`articles_has_tags` (
  `id` INT(11) NOT NULL AUTO_INCREMENT,
  `tags_id` INT NOT NULL,
  `articles_id` INT NOT NULL,
  PRIMARY KEY (`id`),
  CONSTRAINT `articles_has_tags_ibfk_1`
    FOREIGN KEY (`tags_id`)
    REFERENCES `noadtech`.`tags` (`id`),
  CONSTRAINT `articles_has_tags_ibfk_2`
    FOREIGN KEY (`articles_id`)
    REFERENCES `noadtech`.`articles` (`id`))
ENGINE = InnoDB;

CREATE UNIQUE INDEX `tags_has_articles` ON `noadtech`.`articles_has_tags` (`tags_id` ASC, `articles_id` ASC);

CREATE UNIQUE INDEX `articles_has_tags` ON `noadtech`.`articles_has_tags` (`articles_id` ASC, `tags_id` ASC);


SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;

-- -----------------------------------------------------
-- Data for table `noadtech`.`user_types`
-- -----------------------------------------------------
START TRANSACTION;
USE `noadtech`;
INSERT INTO `noadtech`.`user_types` (`id`, `name`) VALUES (1, 'single user');

COMMIT;


-- -----------------------------------------------------
-- Data for table `noadtech`.`faq_categories`
-- -----------------------------------------------------
START TRANSACTION;
USE `noadtech`;
INSERT INTO `noadtech`.`faq_categories` (`id`, `name`, `desc`, `hidden`) VALUES (DEFAULT, 'Какие-то вопросы', NULL, DEFAULT);
INSERT INTO `noadtech`.`faq_categories` (`id`, `name`, `desc`, `hidden`) VALUES (DEFAULT, 'Дополнительная информация', NULL, DEFAULT);
INSERT INTO `noadtech`.`faq_categories` (`id`, `name`, `desc`, `hidden`) VALUES (DEFAULT, 'Больше вопросов', NULL, DEFAULT);

COMMIT;


-- -----------------------------------------------------
-- Data for table `noadtech`.`vacancies`
-- -----------------------------------------------------
START TRANSACTION;
USE `noadtech`;
INSERT INTO `noadtech`.`vacancies` (`id`, `title`, `annotation`, `desc`, `appeal`, `offer1`, `offer2`, `offer3`, `offer4`, `hidden`, `debugging_skills_show`) VALUES (1, 'zero title', 'zero vacancy for common offers for vacancies page', '', NULL, NULL, NULL, NULL, NULL, 1, DEFAULT);

COMMIT;


-- -----------------------------------------------------
-- Data for table `noadtech`.`vacancies_offers`
-- -----------------------------------------------------
START TRANSACTION;
USE `noadtech`;
INSERT INTO `noadtech`.`vacancies_offers` (`id`, `vacancies_id`, `desc`) VALUES (DEFAULT, 1, 'Sample offer one');
INSERT INTO `noadtech`.`vacancies_offers` (`id`, `vacancies_id`, `desc`) VALUES (DEFAULT, 1, 'Next offer description');
INSERT INTO `noadtech`.`vacancies_offers` (`id`, `vacancies_id`, `desc`) VALUES (DEFAULT, 1, 'Huge description. The PHP development team announces the immediate availability of PHP 7.0.14. This is a security release. Several security bugs were fixed in this release. All PHP 7.0 users are encouraged to upgrade to this version.');
INSERT INTO `noadtech`.`vacancies_offers` (`id`, `vacancies_id`, `desc`) VALUES (DEFAULT, 1, 'Vestibulum consequat molestie neque, at sagittis augue accumsan ut. Vestibulum aliquet ipsum nibh, at sagittis libero finibus eget. Phasellus commodo dolor id arcu convallis suscipit. Duis non ex pretium turpis pharetra aliquet. Suspendisse et ante ac purus pharetra malesuada non et felis. Praesent lobortis massa purus, vel maximus sem facilisis ut. Morbi in urna accumsan purus ornare convallis.');

COMMIT;


-- -----------------------------------------------------
-- Data for table `noadtech`.`locales`
-- -----------------------------------------------------
START TRANSACTION;
USE `noadtech`;
INSERT INTO `noadtech`.`locales` (`id`, `lang`, `locale`) VALUES (DEFAULT, 'en', 'en_US');
INSERT INTO `noadtech`.`locales` (`id`, `lang`, `locale`) VALUES (DEFAULT, 'ru', 'ru_RU');
INSERT INTO `noadtech`.`locales` (`id`, `lang`, `locale`) VALUES (DEFAULT, 'ua', 'uk_UA');

COMMIT;

