/*
    CodeItem
*/

class CodeItem extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            data: this.props.data,
            showCode: (this.props.data.added) ? true : false,
        };
    };
    onInputChange = (e) => {
        //console.log('AAA onInputChange ', e.target.name, e.target.value);
        var currentData = this.state.data;
        currentData[e.target.name] = e.target.value;
        this.setState({data: currentData});
        this.props.editCode(currentData);
    };
    onProviderChange = (provider) => {
        console.log('AAA onProviderChange ', provider);
        var currentData = this.state.data;
        currentData.provider = provider;
        this.props.editCode(currentData);
    };
    remove = () => {
        this.props.deleteCode(this.props.data);
    };
    toggleShowCode = () => {
        this.setState({showCode: !this.state.showCode});
    };
    rendClosed = () => {
        return (
            <div className="code-item">
                <span className="show-code" onClick={this.toggleShowCode}><span className="close">+</span></span>
                <label className="for-code" data-name={this.props.index+1} data-id={this.state.data.id}>{this.props.index+1}</label>
                <span className="code-info">[ <span className="title">{this.state.data.title}</span> ]</span>
                <div className="delete-code" onClick={this.remove}>&#215;</div>
                <ClearBoth />
            </div>
        );
    };
    rendOpen = () => {
        const allProviders = (store.getState()).allProviders;
        return (
            <div className="code-item">
                <span className="show-code" onClick={this.toggleShowCode}><span className="open">&ndash;</span></span>
                <label className="for-code" data-name={this.props.index+1} data-id={this.state.data.id}>{this.props.index+1}</label>
                <div className="delete-code" onClick={this.remove}>&#215;</div>
                <div className="code-content">
                    <div>
                        <div className="code-title">
                            <span>title:</span>
                            <input type="text" className="form-control title" name="title" onChange={this.onInputChange} value={this.state.data.title} />
                        </div>
                        <div className="code-provider">
                            <SelectValue data={this.state.data.provider} options={allProviders} name="provider" onChange={this.onProviderChange}/>
                        </div>
                        <ClearBoth />
                    </div>
                    <div>
                        <div className="left">
                            <span>code:</span>
                        </div>
                        <div className="center">
                            <textarea className="form-control code" name="code" onChange={this.onInputChange} defaultValue={this.state.data.code} />
                        </div>
                    </div>
                </div>
                <ClearBoth />
            </div>
        );
    };
    render() {
        if (this.state.showCode) {
            return this.rendOpen ();
        } else {
            return this.rendClosed ();
        }
    }
}
