/*
    CodeItem
*/

class SlotItem extends React.Component {
    constructor(props) {
        super(props);
        this.state = {
            data: this.props.data,
            showSlot: (this.props.data.added) ? true : false,
            showFixed: this.props.data.f
        };
    };
    onInputChange = (e) => {
        //console.log('AAA onInputChange ', e.target.name, e.target.value, e.target.checked);
        var currentData = this.state.data;
        
        switch(e.target.name) {
            case 'isActive':
                currentData.disabled = !e.target.checked;
            break;
            case 'nodeSelector':
                currentData.n.selector = e.target.value;
            break;
            case 'nodeParent':
                currentData.n.parent = e.target.value;
            break;
            case 'nodeNext':
                currentData.n.next = e.target.value;
            break;
            case 'offsetTop':
                currentData.o.top = e.target.value;
            break;
            case 'offsetBottom':
                currentData.o.bottom = e.target.value;
            break;
            case 'offsetLeft':
                currentData.o.left = e.target.value;
            break;
            case 'offsetRight':
                currentData.o.right = e.target.value;
            break;
            case 'margin':
                currentData.m = e.target.value;
            break;
            case 'hAlign':
                currentData.ha = e.target.value;
            break;
            case 'isSyncHeight':
                currentData.sh = e.target.checked;
            break;
            case 'styles':
                //currentData[e.target.name] = e.target.value;
                //var currentStyles = currentData.s;
                //currentData.s = currentStyles;
            break;
            case 'fixedNodeSelector':
                currentData.f.node.selector = e.target.value;
            break;
            case 'fixedBottomSync':
                currentData.f.bottomSync = e.target.value;
            break;
            case 'fixedTopOffset':
                currentData.f.topOffset = e.target.value;
            break;
            case 'slotСomment':
                currentData.comment = e.target.value;
            break;
            default:
                currentData[e.target.name] = e.target.value;
            break;
        }
        
        this.setState({data: currentData});
        this.props.editSlot(currentData);
    };
    onZonesChange = (data) => {
        var eventData = {target: {name: 'zones',value: data}};
        this.onInputChange(eventData);
    };
    onEditStyles = (data) => {
        var eventData = {target: {name: 'styles',value: data}};
        this.onInputChange(eventData);
    };
    remove = () => {
        this.props.deleteSlot(this.props.data);
    };
    toggleShowSlot = () => {
        this.setState({showSlot: !this.state.showSlot});
    };
    changeFixed = () => {
        this.setState({showFixed: !this.state.showFixed});
    };
    rendFixed = () => {
        var
            slot = this.state.data,
            fixedNodeSelector = (slot.f && slot.f.node.selector) ? slot.f.node.selector : "",
            fixedTopOffset = (slot.f && slot.f.topOffset) ? slot.f.topOffset : "",
            fixedBottomSync = (slot.f && slot.f.bottomSync) ? slot.f.bottomSync : "bottom";
        
        return (
            <div className="fixed-content">
                <span className="field-name">node-selector:</span><br />
                <input type="text" className="form-control fixed-node-selector" name="fixedNodeSelector" onChange={this.onInputChange} value={fixedNodeSelector} /><br />
                <span className="field-name">bottomSync:</span>
                <select className="form-control fixed-bottomSync" name="fixedBottomSync" onChange={this.onInputChange} value={fixedBottomSync}>
                    <option value="top">top</option>
                    <option value="bottom">bottom</option>
                </select>
                <span className="field-name">topOffset:</span>
                <input type="text" className="form-control fixed-topOffset" name="fixedTopOffset" onChange={this.onInputChange} value={fixedTopOffset} />
            </div>
        );
    };
    rendSyncHeight = () => {
        var slot = this.state.data;
                
        return (
            <div className="syncHeight-inner">
                <input type="checkbox" className="is-syncHeight" name="isSyncHeight" onChange={this.onInputChange} checked={slot.sh} />&nbsp;
                <span className="title">Синхронизировать высоту</span>
            </div>
        );
    };
    rendClosed = () => {
        var
            slot = this.state.data,
            isHiddenClass = (slot.disabled) ? ' is-hidden' : '',
            slotInfo = (slot.zones) ? slot.zones.join(', ') : "";
            
        return (
            <div className={"slot-item" + isHiddenClass}>
                <span className="show-slot" onClick={this.toggleShowSlot} ><span className="close">+</span><span className="open">&ndash;</span></span>
                <label className="for-slot" data-id={slot.id} data-name={slot.name}>{slot.name}</label>
                <span className="slot-info">
                    [ <span className="title">{slotInfo}</span> ]
                    { slot.comment && <span className="info-comment">{slot.comment}</span> }
                </span>
                <div className="delete-slot" onClick={this.remove}>&#215;</div>
                <ClearBoth />
            </div>
        );
    };
    rendOpen = () => {
        var
            slot = this.state.data,
            isHiddenClass = (slot.disabled) ? ' is-hidden' : '',
            showSync = ['left','right'].indexOf(slot.m)>-1,
            nodeSelector = (slot.n && slot.n.selector) ? slot.n.selector : "",
            nodeParent = (slot.n && slot.n.parent) ? slot.n.parent : "",
            nodeNext = (slot.n && slot.n.next) ? slot.n.next: "",
            offsetTop = (slot.o && slot.o.top) ? slot.o.top : "",
            offsetLeft = (slot.o && slot.o.left) ? slot.o.left : "",
            offsetBottom = (slot.o && slot.o.bottom) ? slot.o.bottom : "",
            offsetRight = (slot.o && slot.o.right) ? slot.o.right : "";
        
        // Формируем список id зон для выбора:
        const allZones = [];
        (store.getState()).zones.forEach(function(zone) {
            allZones.push(zone.id);
        });
        
        return (
            <div className={"slot-item open" + isHiddenClass}>
                <span className="show-slot" onClick={this.toggleShowSlot} ><span className="close">+</span><span className="open">&ndash;</span></span>
                <label className="for-slot" data-id={slot.id} data-name={slot.name}>{slot.name}</label>
                <div className="delete-slot" onClick={this.remove}>&#215;</div>
                <div className="slot-content">
                    <div className="is-hidden">
                        <input type="checkbox" className="is_hidden" name="isActive" onChange={this.onInputChange} checked={!slot.disabled} />&nbsp;
                        <label htmlFor="is_hidden">Активный слот</label>
                    </div>
                    
                    <div className="form-group zones_id">
                        <Values data={slot.zones} name={'zones'} options={allZones} onEditValues={(data) => this.onZonesChange(data)} />
                    </div>
                    
                    <div className="node-margin-offset">
                        <div className="form-group node">
                            <span>node:</span><br />
                            <span className="field-name">selector:</span><br />
                            <input type="text" className="form-control node-selector" name="nodeSelector" onChange={this.onInputChange} value={nodeSelector} /><br />
                            <span className="field-name">parent:</span>
                            <input type="text" className="form-control node-parent" name="nodeParent" onChange={this.onInputChange} value={nodeParent} />
                            <span className="field-name">next:</span>
                            <input type="text" className="form-control node-next" name="nodeNext" onChange={this.onInputChange} value={nodeNext} />
                        </div>
                        <div className="form-group offset">
                            <span>offset</span>
                            <input type="text" className="form-control offset-top" name="offsetTop" onChange={this.onInputChange} value={offsetTop} />
                            <input type="text" className="form-control offset-bottom" name="offsetBottom" onChange={this.onInputChange} value={offsetBottom} />
                            <input type="text" className="form-control offset-left" name="offsetLeft" onChange={this.onInputChange} value={offsetLeft} />
                            <input type="text" className="form-control offset-right" name="offsetRight" onChange={this.onInputChange} value={offsetRight} />
                        </div>
                        <div className="form-group margin">
                            <span className="field-name">margin:</span>
                            <select className="form-control slot-margin" name="margin" onChange={this.onInputChange} value={slot.m}>
                                <option value="">Выберите значение</option>
                                <option value="top">top</option>
                                <option value="bottom">bottom</option>
                                <option value="left">left</option>
                                <option value="right">right</option>
                            </select>
                        </div>
                        <div className="form-group hAlign">
                            <span className="field-name">hAlign:</span>
                            <select className="form-control slot-hAlign" name="hAlign" onChange={this.onInputChange} value={slot.ha}>
                                <option value="">Выберите значение</option>
                                <option value="left">left</option>
                                <option value="center">center</option>
                                <option value="right">right</option>
                            </select>
                        </div>
                        <div className="form-group syncHeight">
                            {showSync && this.rendSyncHeight()}
                        </div>
                        <ClearBoth />
                    </div>
                    
                    <div>
                        <SlotStyles editStyles={(data) => this.onEditStyles(data)} data={slot.s} />
                        <div className="form-group fixed">
                            <input type="checkbox" className="is-fixed" name="is-fixed" defaultChecked={this.state.showFixed} onChange={this.changeFixed} />&nbsp;
                            <span className="title">fixed:</span>
                            {this.state.showFixed && this.rendFixed()}
                        </div>
                        <ClearBoth />
                    </div>
            
                    <div className="comment">
                        <textarea className="form-control comment" placeholder="Комментарий для слота..." name="slotСomment" onChange={this.onInputChange} value={slot.comment} />
                    </div>
                    
                </div>
                <ClearBoth />
            </div>
        );
    };
    render() {
        if (this.state.showSlot) {
            return this.rendOpen ();
        } else {
            return this.rendClosed ();
        }
    }
}
